/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RouterIterator<T extends GenericTileEntity>
implements Iterator<T> {
    @Nonnull
    private final Level world;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final Class<T> clazz;
    private int facingIdx = 0;
    private T foundRouter = null;

    Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this, (long)OrientationTools.DIRECTION_VALUES.length, 16), false);
    }

    RouterIterator(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Class<T> clazz) {
        this.world = world;
        this.pos = pos;
        this.clazz = clazz;
        this.findNext();
    }

    private void findNext() {
        this.foundRouter = null;
        while (this.facingIdx != -1) {
            BlockEntity te;
            BlockPos routerPos = this.pos.m_142300_(OrientationTools.DIRECTION_VALUES[this.facingIdx]);
            ++this.facingIdx;
            if (this.facingIdx >= OrientationTools.DIRECTION_VALUES.length) {
                this.facingIdx = -1;
            }
            if (!this.clazz.isInstance(te = this.world.m_7702_(routerPos))) continue;
            this.foundRouter = (GenericTileEntity)te;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.foundRouter != null;
    }

    @Override
    public T next() {
        T f = this.foundRouter;
        this.findNext();
        return f;
    }
}

