/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.property;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import dev.ftb.mods.ftbteams.property.TeamPropertyType;
import dev.ftb.mods.ftbteams.property.TeamPropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class EnumProperty
extends TeamProperty<String> {
    private final List<String> values;
    private final Map<String, Component> names;

    public EnumProperty(ResourceLocation id, String def, List<String> v, Map<String, Component> n) {
        super(id, def);
        this.values = v;
        this.names = n;
    }

    public <T> EnumProperty(ResourceLocation id, NameMap<T> nameMap) {
        super(id, nameMap.getName(nameMap.defaultValue));
        this.values = nameMap.keys;
        this.names = new HashMap<String, Component>();
        for (Object val : nameMap) {
            this.names.put(nameMap.getName(val), nameMap.getDisplayName(val));
        }
    }

    public EnumProperty(ResourceLocation id, FriendlyByteBuf buf) {
        super(id, buf.m_130136_(Short.MAX_VALUE));
        int sv = buf.m_130242_();
        this.values = new ArrayList<String>(sv);
        for (int i = 0; i < sv; ++i) {
            this.values.add(buf.m_130136_(Short.MAX_VALUE));
        }
        int sn = buf.m_130242_();
        this.names = new HashMap<String, Component>(sn);
        for (int i = 0; i < sn; ++i) {
            this.names.put(buf.m_130136_(Short.MAX_VALUE), buf.m_130238_());
        }
    }

    @Override
    public TeamPropertyType<String> getType() {
        return TeamPropertyType.ENUM;
    }

    @Override
    public Optional<String> fromString(String string) {
        return Optional.of(string);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130072_((String)this.defaultValue, Short.MAX_VALUE);
        buf.m_130130_(this.values.size());
        for (String string : this.values) {
            buf.m_130072_(string, Short.MAX_VALUE);
        }
        buf.m_130130_(this.names.size());
        for (Map.Entry entry : this.names.entrySet()) {
            buf.m_130072_((String)entry.getKey(), Short.MAX_VALUE);
            buf.m_130083_((Component)entry.getValue());
        }
    }

    @Override
    public void config(ConfigGroup config, TeamPropertyValue<String> value) {
        config.addEnum(this.id.m_135827_() + "." + this.id.m_135815_(), (Object)((String)value.value), value.consumer, NameMap.of((Object)((String)this.defaultValue), this.values).name(s -> this.names.getOrDefault(s, (Component)new TextComponent(s))).create());
    }

    @Override
    public Tag toNBT(String value) {
        return StringTag.m_129297_((String)value);
    }

    @Override
    public Optional<String> fromNBT(Tag tag) {
        if (tag instanceof StringTag) {
            return Optional.of(tag.m_7916_());
        }
        return Optional.empty();
    }
}

