/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class PartyTeam
extends Team {
    UUID owner = Util.f_137441_;

    public PartyTeam(TeamManager m) {
        super(m);
    }

    @Override
    public TeamType getType() {
        return TeamType.PARTY;
    }

    @Override
    protected void serializeExtraNBT(CompoundTag tag) {
        tag.m_128359_("owner", this.owner.toString());
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.owner = UUID.fromString(tag.m_128461_("owner"));
    }

    @Override
    public TeamRank getHighestRank(UUID playerId) {
        if (this.owner.equals(playerId)) {
            return TeamRank.OWNER;
        }
        return super.getHighestRank(playerId);
    }

    public boolean isOwner(UUID profile) {
        return this.owner.equals(profile);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Nullable
    public ServerPlayer getOwnerPlayer() {
        return FTBTUtils.getPlayerByUUID(this.manager.server, this.owner);
    }

    @Deprecated
    public int join(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        Team oldTeam = this.manager.getPlayerTeam(player);
        if (!oldTeam.getType().isPlayer()) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        UUID id = player.m_142081_();
        ((PlayerTeam)oldTeam).actualTeam = this;
        this.ranks.put(id, TeamRank.MEMBER);
        this.sendMessage(Util.f_137441_, (Component)new TextComponent("").m_7220_(player.m_7755_()).m_130946_(" joined your party!").m_130940_(ChatFormatting.GREEN));
        this.save();
        oldTeam.ranks.remove(id);
        oldTeam.save();
        ((PlayerTeam)oldTeam).updatePresence();
        this.manager.syncAll();
        this.changedTeam(oldTeam, id, player, false);
        return 1;
    }

    @Deprecated
    public int invite(ServerPlayer from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            if (this.isMember(player.getId())) continue;
            this.ranks.put(player.getId(), TeamRank.INVITED);
            this.save();
            this.sendMessage(from.m_142081_(), (Component)new TextComponent("Invited " + player.getName()).m_130940_(ChatFormatting.GREEN));
            ServerPlayer p = FTBTUtils.getPlayerByUUID(this.manager.getServer(), player.getId());
            if (p == null) continue;
            p.m_6352_((Component)new TextComponent("").m_7220_(from.m_7755_()).m_130946_(" has invited you to join their party!"), Util.f_137441_);
            MutableComponent acceptButton = new TextComponent("Accept \u2714").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams party join " + this.getStringID())));
            MutableComponent denyButton = new TextComponent("Deny \u2718").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbteams party deny_invite " + this.getStringID())));
            p.m_6352_((Component)new TextComponent("[").m_7220_((Component)acceptButton).m_130946_("] [").m_7220_((Component)denyButton).m_130946_("]"), Util.f_137441_);
        }
        return 1;
    }

    @Deprecated
    public int kick(ServerPlayer from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            UUID id = player.getId();
            Team oldTeam = this.manager.getPlayerTeam(id);
            if (oldTeam != this) {
                throw TeamArgument.NOT_IN_PARTY.create();
            }
            if (this.isOwner(id)) {
                throw TeamArgument.CANT_KICK_OWNER.create();
            }
            PlayerTeam team = this.manager.getInternalPlayerTeam(id);
            team.actualTeam = team;
            ServerPlayer playerEntity = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            team.ranks.put(id, TeamRank.OWNER);
            this.sendMessage(from.m_142081_(), (Component)new TextComponent("Kicked ").m_7220_(this.manager.getName(id)).m_130946_(" from ").m_7220_(this.getName()).m_130940_(ChatFormatting.RED));
            team.save();
            this.ranks.remove(id);
            this.save();
            team.updatePresence();
            this.manager.syncAll();
            if (playerEntity != null) {
                playerEntity.m_5661_((Component)new TextComponent("You have been kicked from ").m_7220_(this.getName()).m_130946_("!"), false);
                this.updateCommands(playerEntity);
            }
            team.changedTeam(this, id, playerEntity, false);
        }
        return 1;
    }

    @Deprecated
    public int transferOwnership(ServerPlayer from, ServerPlayer to) throws CommandSyntaxException {
        if (!this.getOnlineMembers().contains(to)) {
            throw TeamArgument.NOT_MEMBER.create((Object)to.m_5446_(), (Object)this.getName());
        }
        if (from == to) {
            from.m_6352_((Component)new TextComponent("What."), Util.f_137441_);
            return 0;
        }
        this.ranks.put(this.owner, TeamRank.OFFICER);
        this.owner = to.m_142081_();
        this.ranks.put(this.owner, TeamRank.OWNER);
        this.save();
        ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent(this, from, to));
        this.sendMessage(from.m_142081_(), (Component)new TextComponent("Transferred ownership to ").m_7220_(to.m_5446_()).m_130940_(ChatFormatting.RED));
        this.updateCommands(from);
        this.updateCommands(to);
        this.manager.syncAll();
        return 1;
    }

    @Deprecated
    public int leave(ServerPlayer player) throws CommandSyntaxException {
        UUID id = player.m_142081_();
        if (this.isOwner(id) && this.getMembers().size() > 1) {
            throw TeamArgument.OWNER_CANT_LEAVE.create();
        }
        PlayerTeam team = this.manager.getInternalPlayerTeam(id);
        team.actualTeam = team;
        team.ranks.put(id, TeamRank.OWNER);
        this.sendMessage(Util.f_137441_, (Component)new TextComponent("").m_7220_(player.m_7755_()).m_130946_(" left your party!").m_130940_(ChatFormatting.YELLOW));
        team.save();
        this.ranks.remove(id);
        this.manager.save();
        boolean deleted = false;
        if (this.getMembers().isEmpty()) {
            deleted = true;
            this.manager.saveNow();
            this.manager.teamMap.remove(this.getId());
            String fn = this.getId() + ".snbt";
            try {
                Path dir = this.manager.server.m_129843_(TeamManager.FOLDER_NAME).resolve("deleted");
                if (Files.notExists(dir, new LinkOption[0])) {
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                Files.move(this.manager.server.m_129843_(TeamManager.FOLDER_NAME).resolve("party/" + fn), dir.resolve(fn), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    Files.deleteIfExists(this.manager.server.m_129843_(TeamManager.FOLDER_NAME).resolve("party/" + fn));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        team.updatePresence();
        this.manager.syncAll();
        team.changedTeam(this, id, player, deleted);
        return 1;
    }

    @Deprecated
    public int addAlly(CommandSourceStack source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.m_81373_() == null ? Util.f_137441_ : source.m_81373_().m_142081_();
        boolean changed = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.isAlly(id)) continue;
            this.ranks.put(id, TeamRank.ALLY);
            this.sendMessage(from, (Component)new TextComponent("").m_130946_(player.getName()).m_130946_(" added as ally!").m_130940_(ChatFormatting.YELLOW));
            changed = true;
        }
        if (changed) {
            this.save();
            this.manager.syncAll();
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int removeAlly(CommandSourceStack source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.m_81373_() == null ? Util.f_137441_ : source.m_81373_().m_142081_();
        boolean changed = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (!this.isAlly(id) || this.isMember(id)) continue;
            this.ranks.remove(id);
            this.sendMessage(from, (Component)new TextComponent("").m_130946_(player.getName()).m_130946_(" removed from allies!").m_130940_(ChatFormatting.YELLOW));
            changed = true;
        }
        if (changed) {
            this.save();
            this.manager.syncAll();
            return 1;
        }
        return 0;
    }

    @Deprecated
    public int listAllies(CommandSourceStack source) throws CommandSyntaxException {
        source.m_81354_((Component)new TextComponent("Allies:"), false);
        boolean any = false;
        for (Map.Entry<UUID, TeamRank> entry : this.getRanked(TeamRank.ALLY).entrySet()) {
            if (entry.getValue().is(TeamRank.MEMBER)) continue;
            source.m_81354_(this.manager.getName(entry.getKey()), false);
            any = true;
        }
        if (!any) {
            source.m_81354_((Component)new TextComponent("None"), false);
        }
        return 1;
    }
}

