/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class GhostItemHelper {
    public static void setItemGhostAmount(ItemStack stack, int amount) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128405_("stackSize", amount);
    }

    public static int getItemGhostAmount(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128451_("stackSize");
    }

    public static boolean hasGhostAmount(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        return tag.m_128441_("stackSize");
    }

    public static void incrementGhostAmout(ItemStack stack, int value) {
        int amount = GhostItemHelper.getItemGhostAmount(stack);
        GhostItemHelper.setItemGhostAmount(stack, amount += value);
    }

    public static void decrementGhostAmount(ItemStack stack, int value) {
        int amount = GhostItemHelper.getItemGhostAmount(stack);
        GhostItemHelper.setItemGhostAmount(stack, amount -= value);
    }

    public static ItemStack getStackFromGhost(ItemStack ghostStack) {
        ItemStack newStack = ghostStack.m_41777_();
        NBTHelper.checkNBT(newStack);
        CompoundTag tag = newStack.m_41783_();
        int amount = GhostItemHelper.getItemGhostAmount(ghostStack);
        tag.m_128473_("stackSize");
        if (tag.m_128456_()) {
            newStack.m_41751_(null);
        }
        newStack.m_41764_(amount);
        return newStack;
    }

    public static ItemStack getSingleStackFromGhost(ItemStack ghostStack) {
        ItemStack newStack = ghostStack.m_41777_();
        NBTHelper.checkNBT(newStack);
        CompoundTag tag = newStack.m_41783_();
        tag.m_128473_("stackSize");
        if (tag.m_128456_()) {
            newStack.m_41751_(null);
        }
        newStack.m_41764_(1);
        return newStack;
    }
}

