/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;

public class DungeonRoomRegistry {
    public static Map<DungeonRoom, Integer> dungeonWeightMap = new HashMap<DungeonRoom, Integer>();
    public static Map<String, List<DungeonRoom>> dungeonStartingRoomMap = new HashMap<String, List<DungeonRoom>>();
    private static int totalWeight = 0;
    public static Map<ResourceLocation, DungeonRoom> dungeonRoomMap = new HashMap<ResourceLocation, DungeonRoom>();
    public static Map<ResourceLocation, List<Pair<ResourceLocation, Integer>>> roomPoolTable = new HashMap<ResourceLocation, List<Pair<ResourceLocation, Integer>>>();
    private static Map<ResourceLocation, Integer> totalWeightMap = new HashMap<ResourceLocation, Integer>();
    public static List<ResourceLocation> unloadedDungeonRooms = new ArrayList<ResourceLocation>();
    public static List<ResourceLocation> unloadedDungeonRoomPools = new ArrayList<ResourceLocation>();

    public static void registerDungeonRoom(ResourceLocation res, DungeonRoom room, int weight) {
        room.key = res;
        dungeonWeightMap.put(room, weight);
        totalWeight += weight;
        dungeonRoomMap.put(res, room);
    }

    public static void registerUnloadedDungeonRoom(ResourceLocation res) {
        unloadedDungeonRooms.add(res);
    }

    public static void registerUnloadedDungeonRoomPool(ResourceLocation res) {
        unloadedDungeonRoomPools.add(res);
    }

    public static void registerDungeomRoomPool(ResourceLocation poolRes, List<Pair<ResourceLocation, Integer>> pool) {
        roomPoolTable.put(poolRes, pool);
        int totalWeightOfPool = 0;
        for (Pair<ResourceLocation, Integer> room : pool) {
            totalWeightOfPool += ((Integer)room.getValue()).intValue();
        }
        totalWeightMap.put(poolRes, totalWeightOfPool);
    }

    public static DungeonRoom getRandomDungeonRoom(ResourceLocation roomPoolName, Random rand) {
        List<Pair<ResourceLocation, Integer>> roomPool;
        Integer maxWeight = totalWeightMap.get(roomPoolName);
        int wantedWeight = 0;
        if (maxWeight != null) {
            wantedWeight = rand.nextInt(maxWeight);
            if (DungeonSynthesizer.displayDetailedInformation) {
                System.out.println("Wanted weight: " + wantedWeight);
            }
        }
        if ((roomPool = roomPoolTable.get(roomPoolName)) == null) {
            if (DungeonSynthesizer.displayDetailedInformation) {
                System.out.println("There's nothing here... No room pool!");
                System.out.println("Number of registered room pools: " + roomPoolTable.size());
            }
            return null;
        }
        if (DungeonSynthesizer.displayDetailedInformation) {
            System.out.println("Pool size: " + roomPool.size());
        }
        for (Pair<ResourceLocation, Integer> entry : roomPool) {
            wantedWeight -= ((Integer)entry.getValue()).intValue();
            if (DungeonSynthesizer.displayDetailedInformation) {
                System.out.println("Room name: " + entry.getLeft());
            }
            if (wantedWeight >= 0) continue;
            ResourceLocation dungeonName = (ResourceLocation)entry.getKey();
            if (DungeonSynthesizer.displayDetailedInformation) {
                System.out.println("Dungeon name: " + dungeonName);
                System.out.println("All dungeons: " + dungeonRoomMap);
                System.out.println("Size of dungeons: " + dungeonRoomMap.size());
            }
            return dungeonRoomMap.get(dungeonName);
        }
        return null;
    }

    public static DungeonRoom getDungeonRoom(ResourceLocation dungeonName) {
        return dungeonRoomMap.get(dungeonName);
    }

    public static void registerStarterDungeonRoom(DungeonRoom room, String key) {
        if (dungeonStartingRoomMap.containsKey(key)) {
            dungeonStartingRoomMap.get(key).add(room);
        } else {
            ArrayList<DungeonRoom> roomList = new ArrayList<DungeonRoom>();
            roomList.add(room);
            dungeonStartingRoomMap.put(key, roomList);
        }
    }

    public static DungeonRoom getRandomDungeonRoom(Random rand) {
        int wantedWeight = rand.nextInt(totalWeight);
        for (Map.Entry<DungeonRoom, Integer> entry : dungeonWeightMap.entrySet()) {
            if ((wantedWeight -= entry.getValue().intValue()) >= 0) continue;
            return entry.getKey();
        }
        return null;
    }

    public static DungeonRoom getRandomStarterDungeonRoom(Random rand, String key) {
        if (dungeonStartingRoomMap.containsKey(key)) {
            List<DungeonRoom> roomList = dungeonStartingRoomMap.get(key);
            return roomList.get(rand.nextInt(roomList.size()));
        }
        return null;
    }
}

