/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.arc;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;

public class ARCRecipeCategory
implements IRecipeCategory<RecipeARC> {
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 4;
    private static final int CATALYST_SLOT = 5;
    public static final ResourceLocation UID = BloodMagic.rl("arc");
    public static final ResourceLocation BACKGROUNDRL = BloodMagic.rl("gui/jei/arc.png");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public ARCRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()));
        this.background = guiHelper.createDrawable(BACKGROUNDRL, 0, 0, 157, 43);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.bloodmagic.recipe.arc");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull RecipeARC recipe, @Nonnull IFocusGroup focuses) {
        NonNullList<Ingredient> inputList = recipe.m_7527_();
        int inputSize = recipe.getRequiredInputCount();
        List<ItemStack> inputStackList = List.of(((Ingredient)inputList.get(0)).m_43908_());
        if (inputSize > 1) {
            for (ItemStack stack : inputStackList) {
                stack.m_41764_(inputSize);
            }
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 1, 6).addIngredients(VanillaTypes.ITEM, inputStackList)).setSlotName("input");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 22, 17).addIngredients((Ingredient)inputList.get(1))).setSlotName("tool");
        List<ItemStack> outputList = recipe.getAllListedOutputs();
        for (int i = 0; i < outputList.size(); ++i) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 54 + i * 22, 17).addItemStack(outputList.get(i))).setSlotName("output");
        }
    }

    public Class<? extends RecipeARC> getRecipeClass() {
        return RecipeARC.class;
    }

    public void draw(RecipeARC recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        List<Pair<Double, Double>> chanceArray = recipe.getAllOutputChances();
        String[] infoString = new String[chanceArray.size()];
        for (int i = 0; i < infoString.length; ++i) {
            Pair<Double, Double> chance = chanceArray.get(i);
            double totalChance = (Double)chance.getLeft() + (Double)chance.getRight();
            infoString[i] = totalChance >= 1.0 ? "" : (totalChance < 0.01 ? "<1%" : (int)Math.round(totalChance * 100.0) + "%");
            mc.f_91062_.m_92750_(matrixStack, infoString[i], (float)(86 + 22 * i - mc.f_91062_.m_92895_(infoString[i]) / 2), 5.0f, Color.white.getRGB());
        }
        FluidStack outputStack = recipe.getFluidOutput();
        ClientHandler.handleGuiTank(matrixStack, outputStack, outputStack.getAmount(), 140, 7, 16, 36, 157, 6, 18, 38, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), null);
        if (recipe.getFluidIngredient() != null) {
            List inputFluids = recipe.getFluidIngredient().getRepresentations();
            FluidStack inputStack = (FluidStack)inputFluids.get(0);
            ClientHandler.handleGuiTank(matrixStack, inputStack, inputStack.getAmount(), 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), null);
        }
    }

    public List<Component> getTooltipStrings(RecipeARC recipe, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        FluidStack outputStack = recipe.getFluidOutput();
        if (!outputStack.isEmpty()) {
            ClientHandler.handleGuiTank(null, outputStack, -1, 140, 8, 16, 34, 157, 7, 18, 36, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), tooltip);
        }
        if (recipe.getFluidIngredient() != null) {
            List inputFluids = recipe.getFluidIngredient().getRepresentations();
            FluidStack inputStack = (FluidStack)inputFluids.get(0);
            ClientHandler.handleGuiTank(null, inputStack, -1, 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), tooltip);
        }
        return tooltip;
    }
}

