/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileExplosiveCharge;

public class TileVeinMineCharge
extends TileExplosiveCharge {
    private Map<BlockPos, Boolean> veinPartsMap;
    private List<BlockPos> veinPartsCache;
    private boolean finishedAnalysis;
    private Vec3i[] diagonals = new Vec3i[]{new Vec3i(0, 1, 1), new Vec3i(0, 1, -1), new Vec3i(0, -1, 1), new Vec3i(0, -1, -1), new Vec3i(1, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, -1), new Vec3i(1, 1, 0), new Vec3i(-1, 1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, -1, 0)};
    public double internalCounter = 0.0;
    public int currentBlocks = 0;
    public int maxBlocks = 128;

    public TileVeinMineCharge(BlockEntityType<?> type, int maxBlocks, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.maxBlocks = maxBlocks;
    }

    public TileVeinMineCharge(BlockPos pos, BlockState state) {
        this(128, pos, state);
    }

    public TileVeinMineCharge(int maxBlocks, BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.VEINMINE_CHARGE_TYPE.get(), maxBlocks, pos, state);
    }

    @Override
    public void onUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        Direction explosiveDirection = ((Direction)this.m_58900_().m_61143_(BlockShapedExplosive.ATTACHED)).m_122424_();
        BlockState attachedState = this.f_58857_.m_8055_(this.f_58858_.m_142300_(explosiveDirection));
        Block attachedBlock = attachedState.m_60734_();
        if (!this.isValidStartingBlock(attachedState)) {
            return;
        }
        if (this.veinPartsMap == null) {
            this.veinPartsMap = new HashMap<BlockPos, Boolean>();
            this.veinPartsMap.put(this.f_58858_.m_142300_(explosiveDirection), false);
            this.veinPartsCache = new LinkedList<BlockPos>();
            this.veinPartsCache.add(this.f_58858_.m_142300_(explosiveDirection));
            this.internalCounter = 0.0;
            this.currentBlocks = 1;
        }
        boolean foundNew = false;
        LinkedList<BlockPos> newPositions = new LinkedList<BlockPos>();
        for (BlockPos currentPos : this.veinPartsCache) {
            boolean isTree;
            BlockState checkState;
            BlockPos checkPos;
            if (this.veinPartsMap.getOrDefault(currentPos, false).booleanValue()) continue;
            for (Direction direction : Direction.values()) {
                checkPos = currentPos.m_142300_(direction);
                if (this.veinPartsMap.containsKey(checkPos)) continue;
                checkState = this.f_58857_.m_8055_(checkPos);
                isTree = false;
                if (this.currentBlocks >= this.maxBlocks) continue;
                if (this.isValidBlock(attachedState, checkState)) {
                    ++this.currentBlocks;
                    isTree = true;
                }
                if (!isTree) continue;
                this.veinPartsMap.put(checkPos, false);
                newPositions.add(checkPos);
                foundNew = true;
            }
            if (this.checkDiagonals()) {
                for (Direction direction : this.diagonals) {
                    checkPos = currentPos.m_141952_((Vec3i)direction);
                    if (this.veinPartsMap.containsKey(checkPos)) continue;
                    checkState = this.f_58857_.m_8055_(checkPos);
                    isTree = false;
                    if (this.currentBlocks >= this.maxBlocks) continue;
                    if (this.isValidBlock(attachedState, checkState)) {
                        ++this.currentBlocks;
                        isTree = true;
                    }
                    if (!isTree) continue;
                    this.veinPartsMap.put(checkPos, false);
                    newPositions.add(checkPos);
                    foundNew = true;
                }
            }
            this.veinPartsMap.put(currentPos, true);
            if (this.currentBlocks < this.maxBlocks) continue;
            this.finishedAnalysis = true;
            break;
        }
        this.veinPartsCache.addAll(newPositions);
        if (foundNew) {
            return;
        }
        this.internalCounter += 1.0;
        if (this.internalCounter == 20.0) {
            this.f_58857_.m_6263_((Player)null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.nextFloat() * 0.4f + 0.8f);
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 5, 0.02, 0.03, 0.02, 0.0);
        }
        if (this.internalCounter == 30.0) {
            this.f_58857_.m_6263_((Player)null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.internalCounter < 30.0) {
            return;
        }
        if (this.f_58857_.f_46441_.nextDouble() < 0.3) {
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.internalCounter == 100.0) {
            ItemStack toolStack = this.getHarvestingTool();
            this.f_58857_.m_6263_((Player)null, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
            int numParticles = 10;
            ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)this.f_58858_.m_123341_() + 0.5 + (double)explosiveDirection.m_122429_(), (double)this.f_58858_.m_123342_() + 0.5 + (double)explosiveDirection.m_122430_(), (double)this.f_58858_.m_123343_() + 0.5 + (double)explosiveDirection.m_122431_(), numParticles, 1.0, 1.0, 1.0, 0.0);
            ObjectArrayList objectarraylist = new ObjectArrayList();
            for (BlockPos blockPos : this.veinPartsCache) {
                BlockState blockState = this.f_58857_.m_8055_(blockPos);
                Block block = blockState.m_60734_();
                if (blockState.m_60795_()) continue;
                BlockPos blockpos1 = blockPos.m_7949_();
                if (!(this.f_58857_ instanceof ServerLevel)) continue;
                BlockEntity tileentity = blockState.m_60734_() instanceof EntityBlock ? this.f_58857_.m_7702_(blockPos) : null;
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78977_(this.f_58857_.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockPos)).m_78972_(LootContextParams.f_81463_, (Object)toolStack).m_78984_(LootContextParams.f_81462_, (Object)tileentity);
                blockState.m_60724_(lootcontext$builder).forEach(stack -> TileVeinMineCharge.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                this.f_58857_.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
        }
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.internalCounter = tag.m_128459_("internalCounter");
        this.maxBlocks = tag.m_128451_("maxBlocks");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128347_("internalCounter", this.internalCounter);
        tag.m_128405_("maxBlocks", this.maxBlocks);
        return tag;
    }

    public boolean isValidBlock(BlockState originalBlockState, BlockState testState) {
        return originalBlockState.m_60734_() == testState.m_60734_();
    }

    public boolean isValidStartingBlock(BlockState originalBlockState) {
        return originalBlockState.m_60800_((BlockGetter)this.f_58857_, this.f_58858_) != -1.0f;
    }

    public boolean checkDiagonals() {
        return true;
    }
}

