/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BlockAlchemicalReactionChamber;
import wayoftime.bloodmagic.common.container.tile.ContainerAlchemicalReactionChamber;
import wayoftime.bloodmagic.common.item.arc.IARCTool;
import wayoftime.bloodmagic.common.item.inventory.InventoryWrapper;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.network.ARCTanksPacket;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.util.MultiSlotItemHandler;

public class TileAlchemicalReactionChamber
extends TileInventory
implements MenuProvider,
WorldlyContainer,
IFluidHandler {
    public static final int ARC_TOOL_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int NUM_OUTPUTS = 5;
    public static final int INPUT_SLOT = 6;
    public static final int INPUT_BUCKET_SLOT = 7;
    public static final int OUTPUT_BUCKET_SLOT = 8;
    public FluidTank inputTank = new FluidTank(20000);
    public FluidTank outputTank = new FluidTank(20000);
    public double currentProgress = 0.0;
    public static final double DEFAULT_SPEED = 0.005;
    private LazyOptional fluidOptional;

    public TileAlchemicalReactionChamber(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 9, "alchemicalreactionchamber", pos, state);
        this.initializeFluidCapabilities();
    }

    public TileAlchemicalReactionChamber(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.ARC_TYPE.get(), pos, state);
    }

    @Override
    public void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        this.currentProgress = tag.m_128459_("progress");
        CompoundTag inputTankTag = tag.m_128469_("inputtank");
        this.inputTank.readFromNBT(inputTankTag);
        CompoundTag outputTankTag = tag.m_128469_("outputtank");
        this.outputTank.readFromNBT(outputTankTag);
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        super.serialize(tag);
        tag.m_128347_("progress", this.currentProgress);
        CompoundTag inputTankTag = new CompoundTag();
        this.inputTank.writeToNBT(inputTankTag);
        tag.m_128365_("inputtank", (Tag)inputTankTag);
        CompoundTag outputTankTag = new CompoundTag();
        this.outputTank.writeToNBT(outputTankTag);
        tag.m_128365_("outputtank", (Tag)outputTankTag);
        return tag;
    }

    public void tick() {
        RecipeARC recipe;
        boolean outputChanged = false;
        ItemStack fullBucketStack = this.m_8020_(7);
        ItemStack emptyBucketStack = this.m_8020_(8);
        ItemStack[] outputInventory = new ItemStack[]{this.m_8020_(1), this.m_8020_(2), this.m_8020_(3), this.m_8020_(4), this.m_8020_(5)};
        MultiSlotItemHandler outputSlotHandler = new MultiSlotItemHandler(outputInventory, 64);
        if (!this.f_58857_.f_46443_) {
            ItemStack testEmptyBucketStack;
            ArrayList<ItemStack> arrayList;
            IFluidHandlerItem fluidHandler;
            FluidStack transferedStack;
            ItemStack testFullBucketStack;
            LazyOptional fluidHandlerWrapper;
            if (!fullBucketStack.m_41619_() && this.inputTank.getSpace() >= 1000 && (fluidHandlerWrapper = FluidUtil.getFluidHandler((ItemStack)(testFullBucketStack = ItemHandlerHelper.copyStackWithSize((ItemStack)fullBucketStack, (int)1)))).isPresent() && !(transferedStack = FluidUtil.tryFluidTransfer((IFluidHandler)this.inputTank, (IFluidHandler)(fluidHandler = (IFluidHandlerItem)fluidHandlerWrapper.resolve().get()), (int)1000, (boolean)false)).isEmpty()) {
                fluidHandler.drain(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                arrayList = new ArrayList<ItemStack>();
                arrayList.add(fluidHandler.getContainer());
                if (outputSlotHandler.canTransferAllItemsToSlots(arrayList, true)) {
                    outputChanged = true;
                    this.inputTank.fill(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                    outputSlotHandler.canTransferAllItemsToSlots(arrayList, false);
                    if (fullBucketStack.m_41613_() > 1) {
                        fullBucketStack.m_41764_(fullBucketStack.m_41613_() - 1);
                    } else {
                        this.m_6836_(7, ItemStack.f_41583_);
                    }
                }
            }
            if (!emptyBucketStack.m_41619_() && this.outputTank.getFluidAmount() >= 1000 && (fluidHandlerWrapper = FluidUtil.getFluidHandler((ItemStack)(testEmptyBucketStack = ItemHandlerHelper.copyStackWithSize((ItemStack)emptyBucketStack, (int)1)))).isPresent() && !(transferedStack = FluidUtil.tryFluidTransfer((IFluidHandler)(fluidHandler = (IFluidHandlerItem)fluidHandlerWrapper.resolve().get()), (IFluidHandler)this.outputTank, (int)1000, (boolean)false)).isEmpty()) {
                fluidHandler.fill(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                arrayList = new ArrayList();
                arrayList.add(fluidHandler.getContainer());
                if (outputSlotHandler.canTransferAllItemsToSlots(arrayList, true)) {
                    outputChanged = true;
                    this.outputTank.drain(transferedStack, IFluidHandler.FluidAction.EXECUTE);
                    outputSlotHandler.canTransferAllItemsToSlots(arrayList, false);
                    if (emptyBucketStack.m_41613_() > 1) {
                        emptyBucketStack.m_41764_(emptyBucketStack.m_41613_() - 1);
                    } else {
                        this.m_6836_(8, ItemStack.f_41583_);
                    }
                }
            }
        }
        ItemStack inputStack = this.m_8020_(6);
        ItemStack toolStack = this.m_8020_(0);
        double craftingMultiplier = 1.0;
        EnumDemonWillType type = EnumDemonWillType.DEFAULT;
        if (toolStack.m_41720_() instanceof IARCTool) {
            craftingMultiplier = ((IARCTool)toolStack.m_41720_()).getCraftingSpeedMultiplier(toolStack);
            type = ((IARCTool)toolStack.m_41720_()).getDominantWillType(toolStack);
        }
        if (this.canCraft(recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getARC(this.f_58857_, inputStack, toolStack, this.inputTank.getFluid()), inputStack, toolStack, outputSlotHandler)) {
            this.setIsCrafting(this.f_58857_, this.f_58858_, this.m_58900_(), true);
            this.setDisplayedType(this.f_58857_, this.f_58858_, this.m_58900_(), type);
            this.currentProgress += craftingMultiplier * 0.005;
            if (this.currentProgress >= 1.0) {
                if (!this.f_58857_.f_46443_) {
                    outputChanged = true;
                    double bonusChance = 1.0;
                    if (toolStack.m_41720_() instanceof IARCTool) {
                        bonusChance = ((IARCTool)toolStack.m_41720_()).getAdditionalOutputChanceMultiplier(toolStack);
                    }
                    this.craftItem(recipe, inputStack, toolStack, outputSlotHandler, bonusChance);
                }
                this.currentProgress = 0.0;
            }
        } else if (toolStack.m_204117_(BloodMagicTags.ARC_TOOL_FURNACE)) {
            InventoryWrapper invWrapper = new InventoryWrapper(1);
            invWrapper.m_6836_(0, inputStack.m_41777_());
            Optional furnaceRecipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, (Container)invWrapper, this.f_58857_);
            if (furnaceRecipe.isPresent()) {
                ItemStack outputStack = ((SmeltingRecipe)furnaceRecipe.get()).m_5874_((Container)invWrapper);
                if (this.canCraftFurnace(outputStack, outputSlotHandler)) {
                    this.setIsCrafting(this.f_58857_, this.f_58858_, this.m_58900_(), true);
                    this.setDisplayedType(this.f_58857_, this.f_58858_, this.m_58900_(), type);
                    this.currentProgress += craftingMultiplier * 0.005;
                    if (this.currentProgress >= 1.0) {
                        if (!this.f_58857_.f_46443_) {
                            this.craftFurnace(outputStack, outputSlotHandler);
                            outputChanged = true;
                        }
                        this.currentProgress = 0.0;
                    }
                }
            } else {
                this.currentProgress = 0.0;
                this.setIsCrafting(this.f_58857_, this.m_58899_(), this.m_58900_(), false);
                this.setDisplayedType(this.f_58857_, this.f_58858_, this.m_58900_(), type);
            }
        } else {
            this.currentProgress = 0.0;
            this.setIsCrafting(this.f_58857_, this.m_58899_(), this.m_58900_(), false);
            this.setDisplayedType(this.f_58857_, this.f_58858_, this.m_58900_(), type);
        }
        if (outputChanged && !this.f_58857_.f_46443_) {
            for (int i = 0; i < 5; ++i) {
                this.m_6836_(1 + i, outputSlotHandler.getStackInSlot(i));
            }
        }
    }

    public void setIsCrafting(Level world, BlockPos pos, BlockState state, boolean isCrafting) {
        boolean isCurrentlyCrafting = (Boolean)state.m_61143_((Property)BlockAlchemicalReactionChamber.LIT);
        if (isCurrentlyCrafting != isCrafting) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockAlchemicalReactionChamber.LIT, (Comparable)Boolean.valueOf(isCrafting)), 2);
        }
    }

    public void setDisplayedType(Level world, BlockPos pos, BlockState state, EnumDemonWillType type) {
        EnumDemonWillType currentType = (EnumDemonWillType)((Object)state.m_61143_(BlockAlchemicalReactionChamber.TYPE));
        if (type != currentType) {
            world.m_7731_(pos, (BlockState)state.m_61124_(BlockAlchemicalReactionChamber.TYPE, (Comparable)((Object)type)), 2);
        }
    }

    private boolean canCraft(RecipeARC recipe, ItemStack inputStack, ItemStack toolStack, MultiSlotItemHandler outputSlotHandler) {
        if (recipe == null) {
            return false;
        }
        if (inputStack.m_41613_() < recipe.getRequiredInputCount()) {
            return false;
        }
        if (toolStack.m_41763_() && toolStack.m_41773_() >= toolStack.m_41776_()) {
            return false;
        }
        FluidStackIngredient inputFluidIngredient = recipe.getFluidIngredient();
        if (inputFluidIngredient != null && !inputFluidIngredient.test(this.inputTank.getFluid())) {
            return false;
        }
        if (outputSlotHandler.canTransferAllItemsToSlots(recipe.getAllListedOutputs(), true)) {
            FluidStack outputStack = recipe.getFluidOutput();
            return outputStack.isEmpty() ? true : this.outputTank.fill(outputStack, IFluidHandler.FluidAction.SIMULATE) >= outputStack.getAmount();
        }
        return false;
    }

    private void craftItem(RecipeARC recipe, ItemStack inputStack, ItemStack toolStack, MultiSlotItemHandler outputSlotHandler, double modifier) {
        if (this.canCraft(recipe, inputStack, toolStack, outputSlotHandler)) {
            if (recipe.getFluidIngredient() != null) {
                FluidStack inputFluidStack = recipe.getFluidIngredient().getMatchingInstance(this.inputTank.getFluid());
                this.inputTank.drain(inputFluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            outputSlotHandler.canTransferAllItemsToSlots(recipe.getAllOutputs(this.f_58857_.f_46441_, inputStack, toolStack, modifier), false);
            this.outputTank.fill(recipe.getFluidOutput().copy(), IFluidHandler.FluidAction.EXECUTE);
            this.consumeInventory(recipe.getRequiredInputCount(), recipe.getConsumeIngredient(), recipe.breakTool());
        }
    }

    private boolean canCraftFurnace(ItemStack outputStack, MultiSlotItemHandler outputSlotHandler) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        outputList.add(outputStack);
        return outputSlotHandler.canTransferAllItemsToSlots(outputList, true);
    }

    private void craftFurnace(ItemStack outputStack, MultiSlotItemHandler outputSlotHandler) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        outputList.add(outputStack);
        outputSlotHandler.canTransferAllItemsToSlots(outputList, false);
        this.consumeInventory(1, false, false);
    }

    public void consumeInventory(int inputCount, boolean consumeInput, boolean breakTool) {
        ItemStack toolStack;
        ItemStack inputStack = this.m_8020_(6);
        if (!inputStack.m_41619_()) {
            if (!consumeInput && inputStack.m_41720_().hasContainerItem(inputStack)) {
                this.m_6836_(6, inputStack.m_41720_().getContainerItem(inputStack));
            } else {
                inputStack.m_41774_(inputCount);
                if (inputStack.m_41619_()) {
                    this.m_6836_(6, ItemStack.f_41583_);
                }
            }
        }
        if (!(toolStack = this.m_8020_(0)).m_41619_()) {
            if (toolStack.m_41763_()) {
                int unbreakingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)toolStack);
                if (unbreakingLevel == 0 || this.f_58857_.f_46441_.nextInt(unbreakingLevel + 1) == 0) {
                    toolStack.m_41721_(toolStack.m_41773_() + 1);
                    if (toolStack.m_41773_() >= toolStack.m_41776_() && breakTool) {
                        this.m_6836_(0, ItemStack.f_41583_);
                    }
                }
            } else if (toolStack.m_41720_().hasContainerItem(toolStack)) {
                this.m_6836_(0, toolStack.m_41720_().getContainerItem(inputStack));
            } else {
                toolStack.m_41774_(1);
                if (toolStack.m_41619_()) {
                    this.m_6836_(0, ItemStack.f_41583_);
                }
            }
        }
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player p_createMenu_3_) {
        assert (this.f_58857_ != null);
        return new ContainerAlchemicalReactionChamber(this, p_createMenu_1_, p_createMenu_2_);
    }

    public Component m_5446_() {
        return new TextComponent("Alchemical Reaction Chamber");
    }

    public double getProgressForGui() {
        return this.currentProgress;
    }

    public int[] m_7071_(Direction side) {
        switch (side) {
            case UP: {
                return new int[]{0};
            }
            case DOWN: {
                return new int[]{1, 2, 3, 4, 5};
            }
        }
        return new int[]{6, 7, 8};
    }

    public boolean m_7155_(int index, ItemStack itemStack, Direction direction) {
        if (index == 7 || index == 8) {
            Optional fluidStackOptional = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluidStackOptional.isPresent() && (index == 8 && !((FluidStack)fluidStackOptional.get()).isEmpty() || index == 7 && ((FluidStack)fluidStackOptional.get()).isEmpty());
        }
        if (index >= 1 && index < 6) {
            return false;
        }
        if (index == 0) {
            return itemStack.m_204117_(BloodMagicTags.ARC_TOOL);
        }
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index >= 1 && index < 6;
    }

    protected void initializeFluidCapabilities() {
        this.fluidOptional = LazyOptional.of(() -> this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidOptional.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
            this.fluidOptional = null;
        }
    }

    public int getTanks() {
        return 2;
    }

    public FluidStack getFluidInTank(int tank) {
        switch (tank) {
            case 0: {
                return this.inputTank.getFluid();
            }
        }
        return this.outputTank.getFluid();
    }

    public int getTankCapacity(int tank) {
        switch (tank) {
            case 0: {
                return this.inputTank.getCapacity();
            }
        }
        return this.outputTank.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        switch (tank) {
            case 0: {
                return this.inputTank.isFluidValid(stack);
            }
        }
        return this.outputTank.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int fillAmount = this.inputTank.fill(resource, action);
        if (fillAmount > 0 && !this.f_58857_.f_46443_) {
            BloodMagic.packetHandler.sendToAllTracking(new ARCTanksPacket(this), this);
        }
        return fillAmount;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedStack = this.outputTank.drain(resource, action);
        if (!drainedStack.isEmpty() && !this.f_58857_.f_46443_) {
            BloodMagic.packetHandler.sendToAllTracking(new ARCTanksPacket(this), this);
        }
        return drainedStack;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedStack = this.outputTank.drain(maxDrain, action);
        if (!drainedStack.isEmpty() && !this.f_58857_.f_46443_) {
            BloodMagic.packetHandler.sendToAllTracking(new ARCTanksPacket(this), this);
        }
        return drainedStack;
    }
}

