/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.recipe.RecipeBloodAltar;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class BloodAltarRecipeSerializer<RECIPE extends RecipeBloodAltar>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public BloodAltarRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        Ingredient inputIng = Ingredient.m_43917_((JsonElement)input);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        int minimumTier = GsonHelper.m_13927_((JsonObject)json, (String)"upgradeLevel");
        int syphon = GsonHelper.m_13927_((JsonObject)json, (String)"altarSyphon");
        int consumeRate = GsonHelper.m_13927_((JsonObject)json, (String)"consumptionRate");
        int drainRate = GsonHelper.m_13927_((JsonObject)json, (String)"drainRate");
        return this.factory.create(recipeId, inputIng, output, minimumTier, syphon, consumeRate, drainRate);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack output = buffer.m_130267_();
        int minimumTier = buffer.readInt();
        int syphon = buffer.readInt();
        int consumeRate = buffer.readInt();
        int drainRate = buffer.readInt();
        return this.factory.create(recipeId, input, output, minimumTier, syphon, consumeRate, drainRate);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        ((RecipeBloodAltar)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeBloodAltar> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, ItemStack var3, int var4, int var5, int var6, int var7);
    }
}

