/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.event.SacrificeKnifeUsedEvent;
import wayoftime.bloodmagic.util.DamageSourceBloodMagic;
import wayoftime.bloodmagic.util.helper.IncenseHelper;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.PlayerSacrificeHelper;

public class ItemSacrificialDagger
extends Item {
    public ItemSacrificialDagger() {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.sacrificialdagger.desc").m_130940_(ChatFormatting.GRAY));
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player && !entityLiving.m_20193_().f_46443_ && PlayerSacrificeHelper.sacrificePlayerHealth((Player)entityLiving)) {
            IncenseHelper.setHasMaxIncense(stack, (Player)entityLiving, false);
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return IncenseHelper.getHasMaxIncense(stack) || super.m_5812_(stack);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.m_7203_(world, player, hand);
        }
        if (this.canUseForSacrifice(stack)) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        int lpAdded = (Integer)ConfigManager.COMMON.sacrificialDaggerConversion.get() * 2;
        if (!player.m_150110_().f_35937_) {
            SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, 2, lpAdded);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                return super.m_7203_(world, player, hand);
            }
            if (evt.shouldDrainHealth) {
                player.f_19802_ = 0;
                player.m_6469_((DamageSource)DamageSourceBloodMagic.INSTANCE, 0.001f);
                player.m_21153_(Math.max(player.m_21223_() - 1.998f, 1.0E-4f));
                if (player.m_21223_() <= 0.001f && !world.f_46443_) {
                    player.f_19802_ = 0;
                    player.m_6469_((DamageSource)DamageSourceBloodMagic.INSTANCE, 10.0f);
                }
            }
            if (!evt.shouldFillAltar) {
                return super.m_7203_(world, player, hand);
            }
            lpAdded = evt.lpAdded;
        } else if (player.m_6144_()) {
            lpAdded = Integer.MAX_VALUE;
        }
        double posX = player.m_20185_();
        double posY = player.m_20186_();
        double posZ = player.m_20189_();
        world.m_6263_(player, posX, posY, posZ, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), 0.0, 0.0, 0.0);
        }
        if (!world.f_46443_ && PlayerHelper.isFakePlayer(player)) {
            return super.m_7203_(world, player, hand);
        }
        PlayerSacrificeHelper.findAndFillAltar(world, (LivingEntity)player, lpAdded, false);
        return super.m_7203_(world, player, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.f_46443_ && entity instanceof Player) {
            this.setUseForSacrifice(stack, this.isPlayerPreparedForSacrifice(world, (Player)entity));
        }
    }

    public boolean isPlayerPreparedForSacrifice(Level world, Player player) {
        return !world.f_46443_ && PlayerSacrificeHelper.getPlayerIncense(player) > 0.0;
    }

    public boolean canUseForSacrifice(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        return stack.m_41783_().m_128471_("sacrifice");
    }

    public void setUseForSacrifice(ItemStack stack, boolean sacrifice) {
        stack = NBTHelper.checkNBT(stack);
        stack.m_41783_().m_128379_("sacrifice", sacrifice);
    }
}

