/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.container.tile;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.common.tile.TileAlchemicalReactionChamber;

public class ContainerAlchemicalReactionChamber
extends AbstractContainerMenu {
    public final TileAlchemicalReactionChamber tileARC;

    public ContainerAlchemicalReactionChamber(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this((TileAlchemicalReactionChamber)playerInventory.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), windowId, playerInventory);
    }

    public ContainerAlchemicalReactionChamber(@Nullable TileAlchemicalReactionChamber tile, int windowId, Inventory playerInventory) {
        super((MenuType)BloodMagicBlocks.ARC_CONTAINER.get(), windowId);
        this.tileARC = tile;
        this.setup(playerInventory, tile);
    }

    public void setup(Inventory inventory, Container tileARC) {
        int i;
        this.m_38897_(new SlotARCTool(tileARC, 0, 35, 51));
        for (i = 0; i < 5; ++i) {
            this.m_38897_(new SlotOutput(tileARC, 1 + i, 116, 15 + i * 18));
        }
        this.m_38897_(new Slot(tileARC, 6, 71, 15));
        this.m_38897_(new SlotBucket(tileARC, 7, 8, 15, true));
        this.m_38897_(new SlotBucket(tileARC, 8, 152, 87, false));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 123 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 181));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= 1 && index < 6 || index == 7 || index == 8) {
                if (!this.m_38903_(itemstack1, 9, 45, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 9 ? (itemstack1.m_204117_(BloodMagicTags.ARC_TOOL) ? !this.m_38903_(itemstack1, 0, 1, false) : (ContainerAlchemicalReactionChamber.isBucket(itemstack1, true) ? !this.m_38903_(itemstack1, 7, 8, false) : (ContainerAlchemicalReactionChamber.isBucket(itemstack1, false) ? !this.m_38903_(itemstack1, 8, 9, false) : !this.m_38903_(itemstack1, 6, 7, false)))) : !this.m_38903_(itemstack1, 9, 45, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean m_6875_(Player playerIn) {
        return this.tileARC.m_6542_(playerIn);
    }

    private static boolean isBucket(ItemStack stack, boolean requiredFull) {
        Optional fluidStackOptional = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStackOptional.isPresent() && (requiredFull && !((FluidStack)fluidStackOptional.get()).isEmpty() || !requiredFull && ((FluidStack)fluidStackOptional.get()).isEmpty());
    }

    private class SlotARCTool
    extends Slot {
        public SlotARCTool(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack itemStack) {
            return itemStack.m_204117_(BloodMagicTags.ARC_TOOL);
        }
    }

    private class SlotOutput
    extends Slot {
        public SlotOutput(Container inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }

    private class SlotBucket
    extends Slot {
        private final boolean needsFullBucket;

        public SlotBucket(Container inventory, int slotIndex, int x, int y, boolean needsFullBucket) {
            super(inventory, slotIndex, x, y);
            this.needsFullBucket = needsFullBucket;
        }

        public boolean m_5857_(ItemStack itemStack) {
            Optional fluidStackOptional = FluidUtil.getFluidContained((ItemStack)itemStack);
            return fluidStackOptional.isPresent() && (this.needsFullBucket && !((FluidStack)fluidStackOptional.get()).isEmpty() || !this.needsFullBucket && ((FluidStack)fluidStackOptional.get()).isEmpty());
        }
    }
}

