/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import wayoftime.bloodmagic.client.hud.element.ElementTileInformation;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;

public abstract class ElementDivinedInformation<T extends BlockEntity>
extends ElementTileInformation<T> {
    private final boolean simple;

    public ElementDivinedInformation(int lines, boolean simple, Class<T> tileClass) {
        super(100, lines, tileClass);
        this.simple = simple;
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack sigilStack = player.m_21120_(InteractionHand.MAIN_HAND);
        boolean flag = false;
        if (this.simple) {
            flag = sigilStack.m_41720_() == BloodMagicItems.DIVINATION_SIGIL.get() || sigilStack.m_41720_() == BloodMagicItems.SEER_SIGIL.get() ? true : this.isFlagSigilHolding(sigilStack, true);
            if (!flag) {
                sigilStack = player.m_21120_(InteractionHand.OFF_HAND);
                flag = sigilStack.m_41720_() == BloodMagicItems.DIVINATION_SIGIL.get() || sigilStack.m_41720_() == BloodMagicItems.SEER_SIGIL.get() ? true : this.isFlagSigilHolding(sigilStack, true);
            }
        } else {
            flag = sigilStack.m_41720_() == BloodMagicItems.SEER_SIGIL.get() ? true : this.isFlagSigilHolding(sigilStack, false);
            if (!flag) {
                sigilStack = player.m_21120_(InteractionHand.OFF_HAND);
                flag = sigilStack.m_41720_() == BloodMagicItems.SEER_SIGIL.get() ? true : this.isFlagSigilHolding(sigilStack, false);
            }
        }
        return super.shouldRender(minecraft) && flag;
    }

    private boolean isFlagSigilHolding(ItemStack sigilStack, boolean simple) {
        if (sigilStack.m_41720_() instanceof ItemSigilHolding) {
            NonNullList<ItemStack> internalInv = ItemSigilHolding.getInternalInventory(sigilStack);
            int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(sigilStack);
            if (internalInv != null && !((ItemStack)internalInv.get(currentSlot)).m_41619_()) {
                return ((ItemStack)internalInv.get(currentSlot)).m_41720_() == BloodMagicItems.SEER_SIGIL.get() && !simple || ((ItemStack)internalInv.get(currentSlot)).m_41720_() == BloodMagicItems.DIVINATION_SIGIL.get() && simple;
            }
        }
        return false;
    }
}

