/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.ContinueUploadMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class NetworkHandler {
    private static SimpleChannel network;
    private static final IntSet usedIds;

    private NetworkHandler() {
    }

    public static void setup() {
        String version = ComputerCraftAPI.getInstalledVersion();
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("computercraft", "network")).networkProtocolVersion(() -> version).clientAcceptedVersions(version::equals).serverAcceptedVersions(version::equals).simpleChannel();
        NetworkHandler.registerMainThread(0, NetworkDirection.PLAY_TO_SERVER, ComputerActionServerMessage.class, ComputerActionServerMessage::new);
        NetworkHandler.registerMainThread(1, NetworkDirection.PLAY_TO_SERVER, QueueEventServerMessage.class, QueueEventServerMessage::new);
        NetworkHandler.registerMainThread(2, NetworkDirection.PLAY_TO_SERVER, RequestComputerMessage.class, RequestComputerMessage::new);
        NetworkHandler.registerMainThread(3, NetworkDirection.PLAY_TO_SERVER, KeyEventServerMessage.class, KeyEventServerMessage::new);
        NetworkHandler.registerMainThread(4, NetworkDirection.PLAY_TO_SERVER, MouseEventServerMessage.class, MouseEventServerMessage::new);
        NetworkHandler.registerMainThread(5, NetworkDirection.PLAY_TO_SERVER, UploadFileMessage.class, UploadFileMessage::new);
        NetworkHandler.registerMainThread(6, NetworkDirection.PLAY_TO_SERVER, ContinueUploadMessage.class, ContinueUploadMessage::new);
        NetworkHandler.registerMainThread(10, NetworkDirection.PLAY_TO_CLIENT, ChatTableClientMessage.class, ChatTableClientMessage::new);
        NetworkHandler.registerMainThread(11, NetworkDirection.PLAY_TO_CLIENT, ComputerDataClientMessage.class, ComputerDataClientMessage::new);
        NetworkHandler.registerMainThread(12, NetworkDirection.PLAY_TO_CLIENT, ComputerDeletedClientMessage.class, ComputerDeletedClientMessage::new);
        NetworkHandler.registerMainThread(13, NetworkDirection.PLAY_TO_CLIENT, ComputerTerminalClientMessage.class, ComputerTerminalClientMessage::new);
        NetworkHandler.registerMainThread(14, NetworkDirection.PLAY_TO_CLIENT, PlayRecordClientMessage.class, PlayRecordClientMessage::new);
        NetworkHandler.registerMainThread(15, NetworkDirection.PLAY_TO_CLIENT, MonitorClientMessage.class, MonitorClientMessage::new);
        NetworkHandler.registerMainThread(16, NetworkDirection.PLAY_TO_CLIENT, SpeakerAudioClientMessage.class, SpeakerAudioClientMessage::new);
        NetworkHandler.registerMainThread(17, NetworkDirection.PLAY_TO_CLIENT, SpeakerMoveClientMessage.class, SpeakerMoveClientMessage::new);
        NetworkHandler.registerMainThread(18, NetworkDirection.PLAY_TO_CLIENT, SpeakerPlayClientMessage.class, SpeakerPlayClientMessage::new);
        NetworkHandler.registerMainThread(19, NetworkDirection.PLAY_TO_CLIENT, SpeakerStopClientMessage.class, SpeakerStopClientMessage::new);
        NetworkHandler.registerMainThread(20, NetworkDirection.PLAY_TO_CLIENT, UploadResultMessage.class, UploadResultMessage::new);
        NetworkHandler.registerMainThread(21, NetworkDirection.PLAY_TO_CLIENT, UpgradesLoadedMessage.class, UpgradesLoadedMessage::new);
    }

    public static void sendToPlayer(Player player, NetworkMessage packet) {
        network.sendTo((Object)packet, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAllPlayers(NetworkMessage packet) {
        network.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public static void sendToServer(NetworkMessage packet) {
        network.sendToServer((Object)packet);
    }

    public static void sendToAllAround(NetworkMessage packet, Level world, Vec3 pos, double range) {
        PacketDistributor.TargetPoint target = new PacketDistributor.TargetPoint(pos.f_82479_, pos.f_82480_, pos.f_82481_, range, world.m_46472_());
        network.send(PacketDistributor.NEAR.with(() -> target), (Object)packet);
    }

    public static void sendToAllTracking(NetworkMessage packet, LevelChunk chunk) {
        network.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)packet);
    }

    private static <T extends NetworkMessage> void registerMainThread(int id, NetworkDirection direction, Class<T> type, Function<FriendlyByteBuf, T> decoder) {
        if (!usedIds.add(id)) {
            throw new IllegalStateException("Duplicate message kind for for id " + id);
        }
        network.messageBuilder(type, id, direction).encoder(NetworkMessage::toBytes).decoder(decoder).consumer((packet, contextSup) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)contextSup.get();
            context.enqueueWork(() -> packet.handle(context));
            context.setPacketHandled(true);
        }).add();
    }

    static {
        usedIds = new IntOpenHashSet();
    }
}

