/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration.jei;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.IUpgradeBase;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

class RecipeResolver
implements IRecipeManagerPlugin {
    static final ComputerFamily[] MAIN_FAMILIES = new ComputerFamily[]{ComputerFamily.NORMAL, ComputerFamily.ADVANCED};
    private final Map<Item, List<UpgradeInfo>> upgradeItemLookup = new HashMap<Item, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    RecipeResolver() {
    }

    private void setupCache() {
        UpgradeInfo info;
        ItemStack stack;
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        for (ITurtleUpgrade iTurtleUpgrade : TurtleUpgrades.instance().getUpgrades()) {
            stack = iTurtleUpgrade.getCraftingItem();
            if (stack.m_41619_()) {
                return;
            }
            info = new UpgradeInfo(stack, iTurtleUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.m_41720_(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        }
        for (IPocketUpgrade iPocketUpgrade : PocketUpgrades.instance().getUpgrades()) {
            stack = iPocketUpgrade.getCraftingItem();
            if (stack.m_41619_()) continue;
            info = new UpgradeInfo(stack, iPocketUpgrade);
            this.upgradeItemLookup.computeIfAbsent(stack.m_41720_(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        }
    }

    private boolean hasUpgrade(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.m_41720_());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public <V> List<ResourceLocation> getRecipeCategoryUids(@Nonnull IFocus<V> focus) {
        Object value = focus.getTypedValue().getIngredient();
        if (!(value instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ItemStack stack = (ItemStack)value;
        switch (focus.getRole()) {
            case INPUT: {
                return stack.m_41720_() instanceof ITurtleItem || stack.m_41720_() instanceof ItemPocketComputer || this.hasUpgrade(stack) ? Collections.singletonList(VanillaRecipeCategoryUid.CRAFTING) : Collections.emptyList();
            }
            case OUTPUT: {
                return stack.m_41720_() instanceof ITurtleItem || stack.m_41720_() instanceof ItemPocketComputer ? Collections.singletonList(VanillaRecipeCategoryUid.CRAFTING) : Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T, V> List<T> getRecipes(@Nonnull IRecipeCategory<T> recipeCategory, @Nonnull IFocus<V> focus) {
        ItemStack stack;
        block7: {
            block6: {
                Object object = focus.getTypedValue().getIngredient();
                if (!(object instanceof ItemStack)) break block6;
                stack = (ItemStack)object;
                if (recipeCategory.getUid().equals((Object)VanillaRecipeCategoryUid.CRAFTING)) break block7;
            }
            return Collections.emptyList();
        }
        switch (focus.getRole()) {
            case INPUT: {
                return RecipeResolver.cast(this.findRecipesWithInput(stack));
            }
            case OUTPUT: {
                return RecipeResolver.cast(RecipeResolver.findRecipesWithOutput(stack));
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public <T> List<T> getRecipes(@Nonnull IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }

    @Nonnull
    private List<Shaped> findRecipesWithInput(@Nonnull ItemStack stack) {
        this.setupCache();
        Item item = stack.m_41720_();
        if (item instanceof ITurtleItem) {
            ITurtleItem item2 = (ITurtleItem)item;
            ITurtleUpgrade left = item2.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item2.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return Collections.emptyList();
            }
            ArrayList<Shaped> recipes = new ArrayList<Shaped>();
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (left == null) {
                    recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{ingredient, upgrade.ingredient}), RecipeResolver.turtleWith(stack, upgrade.turtle, right)));
                }
                if (right != null) continue;
                recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{upgrade.ingredient, ingredient}), RecipeResolver.turtleWith(stack, left, upgrade.turtle)));
            }
            return RecipeResolver.cast(recipes);
        }
        if (stack.m_41720_() instanceof ItemPocketComputer) {
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                return Collections.emptyList();
            }
            ArrayList<Shaped> recipes = new ArrayList<Shaped>();
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                recipes.add(RecipeResolver.vertical((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{ingredient, upgrade.ingredient}), RecipeResolver.pocketWith(stack, upgrade.pocket)));
            }
            return recipes;
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.m_41720_());
        if (upgrades == null) {
            return Collections.emptyList();
        }
        List<Shaped> recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.m_41619_() || craftingStack.m_41720_() != stack.m_41720_() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList<Shaped>(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? Collections.emptyList() : recipes;
    }

    @Nonnull
    private static List<Shaped> findRecipesWithOutput(@Nonnull ItemStack stack) {
        ArrayList<Shaped> recipes;
        Item item = stack.m_41720_();
        if (item instanceof ITurtleItem) {
            ITurtleItem item2 = (ITurtleItem)item;
            recipes = new ArrayList<Shaped>(0);
            ITurtleUpgrade left = item2.getUpgrade(stack, TurtleSide.LEFT);
            ITurtleUpgrade right = item2.getUpgrade(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{RecipeResolver.turtleWith(stack, null, right)}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{left.getCraftingItem()})}), stack));
            }
            if (right != null) {
                recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{right.getCraftingItem()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{RecipeResolver.turtleWith(stack, left, null)})}), stack));
            }
            return RecipeResolver.cast(recipes);
        }
        if (stack.m_41720_() instanceof ItemPocketComputer) {
            recipes = new ArrayList(0);
            IPocketUpgrade back = ItemPocketComputer.getUpgrade(stack);
            if (back != null) {
                recipes.add(RecipeResolver.vertical((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{back.getCraftingItem()}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{RecipeResolver.pocketWith(stack, null)})}), stack));
            }
            return RecipeResolver.cast(recipes);
        }
        return Collections.emptyList();
    }

    private static <T, U> List<T> cast(List<U> from) {
        return from;
    }

    private static ItemStack turtleWith(ItemStack stack, ITurtleUpgrade left, ITurtleUpgrade right) {
        ITurtleItem item = (ITurtleItem)stack.m_41720_();
        return TurtleItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), left, right, item.getFuelLevel(stack), item.getOverlay(stack));
    }

    private static ItemStack pocketWith(ItemStack stack, IPocketUpgrade back) {
        ItemPocketComputer item = (ItemPocketComputer)stack.m_41720_();
        return PocketComputerItemFactory.create(item.getComputerID(stack), item.getLabel(stack), item.getColour(stack), item.getFamily(), back);
    }

    private static Shaped vertical(NonNullList<Ingredient> input, ItemStack result) {
        return new Shaped(1, input.size(), input, result);
    }

    private static Shaped horizontal(NonNullList<Ingredient> input, ItemStack result) {
        return new Shaped(input.size(), 1, input, result);
    }

    private static class UpgradeInfo {
        final ItemStack stack;
        final Ingredient ingredient;
        final ITurtleUpgrade turtle;
        final IPocketUpgrade pocket;
        final IUpgradeBase upgrade;
        ArrayList<Shaped> recipes;

        UpgradeInfo(ItemStack stack, ITurtleUpgrade turtle) {
            this.stack = stack;
            this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            this.turtle = turtle;
            this.upgrade = this.turtle;
            this.pocket = null;
        }

        UpgradeInfo(ItemStack stack, IPocketUpgrade pocket) {
            this.stack = stack;
            this.ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            this.turtle = null;
            this.pocket = pocket;
            this.upgrade = this.pocket;
        }

        List<Shaped> getRecipes() {
            ArrayList<Shaped> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            for (ComputerFamily family : MAIN_FAMILIES) {
                if (this.turtle != null) {
                    recipes.add(RecipeResolver.horizontal((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null)})}), TurtleItemFactory.create(-1, null, -1, family, null, this.turtle, 0, null)));
                }
                if (this.pocket == null) continue;
                recipes.add(RecipeResolver.vertical((NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient, Ingredient.m_43927_((ItemStack[])new ItemStack[]{PocketComputerItemFactory.create(-1, null, -1, family, null)})}), PocketComputerItemFactory.create(-1, null, -1, family, this.pocket)));
            }
            recipes.trimToSize();
            return recipes;
        }
    }

    private static class Shaped
    extends ShapedRecipe {
        private static final ResourceLocation ID = new ResourceLocation("computercraft", "impostor");

        Shaped(int width, int height, NonNullList<Ingredient> input, ItemStack output) {
            super(ID, null, width, height, input, output);
        }

        @Nonnull
        public RecipeSerializer<?> m_7707_() {
            throw new IllegalStateException("Should not serialise the JEI recipe");
        }
    }
}

