/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.inventory;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.blocks.TileCommandComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.network.container.ViewComputerContainerData;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;

public class ContainerViewComputer
extends ComputerMenuWithoutInventory {
    private final int width;
    private final int height;

    public ContainerViewComputer(int id, Inventory player, ServerComputer computer) {
        super((MenuType<? extends ContainerComputerBase>)((MenuType)Registry.ModContainers.VIEW_COMPUTER.get()), id, player, p -> ContainerViewComputer.canInteractWith(computer, p), computer, computer.getFamily());
        this.height = 0;
        this.width = 0;
    }

    public ContainerViewComputer(int id, Inventory player, ViewComputerContainerData data) {
        super((MenuType<? extends ContainerComputerBase>)((MenuType)Registry.ModContainers.VIEW_COMPUTER.get()), id, player, data);
        this.width = data.getWidth();
        this.height = data.getHeight();
    }

    private static boolean canInteractWith(@Nonnull ServerComputer computer, @Nonnull Player player) {
        if (ComputerCraft.serverComputerRegistry.get(computer.getInstanceID()) != computer) {
            return false;
        }
        return computer.getFamily() != ComputerFamily.COMMAND || TileCommandComputer.isCommandUsable(player);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

