/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.computer;

import dan200.computercraft.core.computer.ComputerThread;
import java.util.concurrent.TimeUnit;

public final class TimeoutState {
    static final long TIMEOUT = TimeUnit.MILLISECONDS.toNanos(7000L);
    static final long ABORT_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(1500L);
    public static final String ABORT_MESSAGE = "Too long without yielding";
    private boolean paused;
    private boolean softAbort;
    private volatile boolean hardAbort;
    private long cumulativeStart;
    private long cumulativeElapsed;
    private long currentStart;
    private long currentDeadline;

    long nanoCumulative() {
        return System.nanoTime() - this.cumulativeStart;
    }

    long nanoCurrent() {
        return System.nanoTime() - this.currentStart;
    }

    public synchronized void refresh() {
        long now = System.nanoTime();
        if (!this.paused) {
            boolean bl = this.paused = this.currentDeadline - now <= 0L && ComputerThread.hasPendingWork();
        }
        if (!this.softAbort) {
            this.softAbort = now - this.cumulativeStart - TIMEOUT >= 0L;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isSoftAborted() {
        return this.softAbort;
    }

    public boolean isHardAborted() {
        return this.hardAbort;
    }

    void hardAbort() {
        this.hardAbort = true;
        this.softAbort = true;
    }

    void startTimer() {
        long now;
        this.currentStart = now = System.nanoTime();
        this.currentDeadline = now + ComputerThread.scaledPeriod();
        this.cumulativeStart = now - this.cumulativeElapsed;
    }

    synchronized void pauseTimer() {
        this.cumulativeElapsed = System.nanoTime() - this.cumulativeStart;
        this.paused = false;
    }

    synchronized void stopTimer() {
        this.cumulativeElapsed = 0L;
        this.hardAbort = false;
        this.softAbort = false;
        this.paused = false;
    }
}

