/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.math.Transformation;
import dan200.computercraft.api.client.TransformedModel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;

public class TurtleMultiModel
implements BakedModel {
    private final BakedModel baseModel;
    private final BakedModel overlayModel;
    private final Transformation generalTransform;
    private final TransformedModel leftUpgradeModel;
    private final TransformedModel rightUpgradeModel;
    private List<BakedQuad> generalQuads = null;
    private final Map<Direction, List<BakedQuad>> faceQuads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);

    public TurtleMultiModel(BakedModel baseModel, BakedModel overlayModel, Transformation generalTransform, TransformedModel leftUpgradeModel, TransformedModel rightUpgradeModel) {
        this.baseModel = baseModel;
        this.overlayModel = overlayModel;
        this.leftUpgradeModel = leftUpgradeModel;
        this.rightUpgradeModel = rightUpgradeModel;
        this.generalTransform = generalTransform;
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> m_6840_(BlockState state, Direction side, @Nonnull Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        if (side != null) {
            if (!this.faceQuads.containsKey(side)) {
                this.faceQuads.put(side, this.buildQuads(state, side, rand));
            }
            return this.faceQuads.get(side);
        }
        if (this.generalQuads == null) {
            this.generalQuads = this.buildQuads(state, side, rand);
        }
        return this.generalQuads;
    }

    private List<BakedQuad> buildQuads(BlockState state, Direction side, Random rand) {
        Transformation upgradeTransform;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        this.transformQuadsTo(quads, this.baseModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), this.generalTransform);
        if (this.overlayModel != null) {
            this.transformQuadsTo(quads, this.overlayModel.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), this.generalTransform);
        }
        if (this.leftUpgradeModel != null) {
            upgradeTransform = this.generalTransform.m_121096_(this.leftUpgradeModel.getMatrix());
            this.transformQuadsTo(quads, this.leftUpgradeModel.getModel().getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), upgradeTransform);
        }
        if (this.rightUpgradeModel != null) {
            upgradeTransform = this.generalTransform.m_121096_(this.rightUpgradeModel.getMatrix());
            this.transformQuadsTo(quads, this.rightUpgradeModel.getModel().getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE), upgradeTransform);
        }
        quads.trimToSize();
        return quads;
    }

    public boolean m_7541_() {
        return this.baseModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.baseModel.m_7539_();
    }

    public boolean m_7521_() {
        return this.baseModel.m_7521_();
    }

    public boolean m_7547_() {
        return this.baseModel.m_7547_();
    }

    @Nonnull
    @Deprecated
    public TextureAtlasSprite m_6160_() {
        return this.baseModel.m_6160_();
    }

    @Nonnull
    @Deprecated
    public ItemTransforms m_7442_() {
        return this.baseModel.m_7442_();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    private void transformQuadsTo(List<BakedQuad> output, List<BakedQuad> quads, Transformation transform) {
        for (BakedQuad quad : quads) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            TRSRTransformer transformer = new TRSRTransformer((IVertexConsumer)builder, transform);
            quad.pipe((IVertexConsumer)transformer);
            output.add(builder.build());
        }
    }
}

