/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.client.render.ComputerBorderRenderer;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.RenderTypes;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.util.Colour;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class ItemPocketRenderer
extends ItemMapLikeRenderer {
    private static final ItemPocketRenderer INSTANCE = new ItemPocketRenderer();

    private ItemPocketRenderer() {
    }

    @SubscribeEvent
    public static void onRenderInHand(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.m_41720_() instanceof ItemPocketComputer)) {
            return;
        }
        event.setCanceled(true);
        INSTANCE.renderItemFirstPerson(event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight(), event.getHand(), event.getInterpolatedPitch(), event.getEquipProgress(), event.getSwingProgress(), event.getItemStack());
    }

    @Override
    protected void renderItem(PoseStack transform, MultiBufferSource bufferSource, ItemStack stack, int light) {
        int termHeight;
        int termWidth;
        Terminal terminal;
        ClientComputer computer = ItemPocketComputer.createClientComputer(stack);
        Terminal terminal2 = terminal = computer == null ? null : computer.getTerminal();
        if (terminal == null) {
            termWidth = ComputerCraft.pocketTermWidth;
            termHeight = ComputerCraft.pocketTermHeight;
        } else {
            termWidth = terminal.getWidth();
            termHeight = terminal.getHeight();
        }
        int width = termWidth * 6 + 4;
        int height = termHeight * 9 + 4;
        transform.m_85836_();
        transform.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        transform.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        transform.m_85841_(0.5f, 0.5f, 0.5f);
        float scale = 0.75f / (float)Math.max(width + 24, height + 24 + 8);
        transform.m_85841_(scale, scale, -1.0f);
        transform.m_85837_(-0.5 * (double)width, -0.5 * (double)height, 0.0);
        ItemPocketComputer item = (ItemPocketComputer)stack.m_41720_();
        ComputerFamily family = item.getFamily();
        int frameColour = item.getColour(stack);
        Matrix4f matrix = transform.m_85850_().m_85861_();
        ItemPocketRenderer.renderFrame(matrix, bufferSource, family, frameColour, light, width, height);
        int lightColour = ItemPocketComputer.getLightState(stack);
        if (lightColour == -1) {
            lightColour = Colour.BLACK.getHex();
        }
        ItemPocketRenderer.renderLight(transform, bufferSource, lightColour, width, height);
        if (computer != null && terminal != null) {
            FixedWidthFontRenderer.drawTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.m_6299_(RenderTypes.TERMINAL)), 2.0f, 2.0f, terminal, !computer.isColour(), 2.0f, 2.0f, 2.0f, 2.0f);
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.m_6299_(RenderTypes.TERMINAL)), 0.0f, 0.0f, width, height);
        }
        transform.m_85849_();
    }

    private static void renderFrame(Matrix4f transform, MultiBufferSource render, ComputerFamily family, int colour, int light, int width, int height) {
        ResourceLocation texture = colour != -1 ? ComputerBorderRenderer.BACKGROUND_COLOUR : ComputerBorderRenderer.getTexture(family);
        float r = (float)(colour >>> 16 & 0xFF) / 255.0f;
        float g = (float)(colour >>> 8 & 0xFF) / 255.0f;
        float b = (float)(colour & 0xFF) / 255.0f;
        ComputerBorderRenderer.render(transform, render.m_6299_(ComputerBorderRenderer.getRenderType(texture)), 0, 0, 0, light, width, height, true, r, g, b);
    }

    private static void renderLight(PoseStack transform, MultiBufferSource render, int colour, int width, int height) {
        byte r = (byte)(colour >>> 16 & 0xFF);
        byte g = (byte)(colour >>> 8 & 0xFF);
        byte b = (byte)(colour & 0xFF);
        byte[] c = new byte[]{r, g, b, -1};
        VertexConsumer buffer = render.m_6299_(RenderTypes.TERMINAL);
        FixedWidthFontRenderer.drawQuad(FixedWidthFontRenderer.toVertexConsumer(transform, buffer), width - 16, (float)height + 6.0f, 0.001f, 16.0f, 8.0f, c, 0xF000F0);
    }
}

