/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaThread;
import cc.tweaked.internal.cobalt.LuaUserdata;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHelpers;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.function.LocalVariable;
import cc.tweaked.internal.cobalt.function.LuaClosure;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import cc.tweaked.internal.cobalt.function.VarArgFunction;
import cc.tweaked.internal.cobalt.lib.LuaLibrary;

public class DebugLib
extends VarArgFunction
implements LuaLibrary {
    static final String[] NAMES = new String[]{"debug", "getfenv", "gethook", "getinfo", "getlocal", "getmetatable", "getregistry", "getupvalue", "setfenv", "sethook", "setlocal", "setmetatable", "setupvalue", "traceback", "upvalueid", "upvaluejoin"};
    private static final LuaString MAIN = ValueFactory.valueOf("main");
    private static final LuaString LUA = ValueFactory.valueOf("Lua");
    private static final LuaString C = ValueFactory.valueOf("C");
    private static final LuaString C_SOURCE = ValueFactory.valueOf("[C]");
    public static final LuaString QMARK = ValueFactory.valueOf("?");
    private static final LuaString EXTERNAL_HOOK = ValueFactory.valueOf("external hook");
    private static final LuaString FUNC = ValueFactory.valueOf("func");
    private static final LuaString NUPS = ValueFactory.valueOf("nups");
    private static final LuaString NAME = ValueFactory.valueOf("name");
    private static final LuaString NAMEWHAT = ValueFactory.valueOf("namewhat");
    private static final LuaString WHAT = ValueFactory.valueOf("what");
    private static final LuaString SOURCE = ValueFactory.valueOf("source");
    private static final LuaString SHORT_SRC = ValueFactory.valueOf("short_src");
    private static final LuaString LINEDEFINED = ValueFactory.valueOf("linedefined");
    private static final LuaString LASTLINEDEFINED = ValueFactory.valueOf("lastlinedefined");
    private static final LuaString CURRENTLINE = ValueFactory.valueOf("currentline");
    private static final LuaString ACTIVELINES = ValueFactory.valueOf("activelines");
    private static final LuaString NPARAMS = ValueFactory.valueOf("nparams");
    private static final LuaString ISVARARG = ValueFactory.valueOf("isvararg");
    private static final LuaString ISTAILCALL = ValueFactory.valueOf("istailcall");

    @Override
    public LuaTable add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable();
        DebugLib.bind(t, DebugLib::new, NAMES);
        env.rawset("debug", (LuaValue)t);
        state.loadedPackages.rawset("debug", (LuaValue)t);
        return t;
    }

    @Override
    public Varargs invoke(LuaState state, Varargs args) throws LuaError {
        switch (this.opcode) {
            case 0: {
                return DebugLib._debug(args);
            }
            case 1: {
                return DebugLib._getfenv(args);
            }
            case 2: {
                return DebugLib._gethook(state, args);
            }
            case 3: {
                return DebugLib._getinfo(state, args, this);
            }
            case 4: {
                return DebugLib._getlocal(state, args);
            }
            case 5: {
                return DebugLib._getmetatable(state, args);
            }
            case 6: {
                return DebugLib._getregistry(args);
            }
            case 7: {
                return DebugLib._getupvalue(args);
            }
            case 8: {
                return DebugLib._setfenv(args);
            }
            case 9: {
                return DebugLib._sethook(state, args);
            }
            case 10: {
                return DebugLib._setlocal(state, args);
            }
            case 11: {
                return DebugLib._setmetatable(state, args);
            }
            case 12: {
                return DebugLib._setupvalue(args);
            }
            case 13: {
                return DebugLib._traceback(state, args);
            }
            case 14: {
                return DebugLib.upvalueId(args);
            }
            case 15: {
                return DebugLib.upvalueJoin(args);
            }
        }
        return Constants.NONE;
    }

    private static Varargs _debug(Varargs args) {
        return Constants.NONE;
    }

    private static Varargs _gethook(LuaState state, Varargs args) throws LuaError {
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        DebugState ds = thread.getDebugState();
        LuaValue hook = ds.hookfunc == null ? Constants.NIL : (ds.hookfunc instanceof LuaValue ? (LuaValue)((Object)ds.hookfunc) : EXTERNAL_HOOK);
        return ValueFactory.varargsOf(hook, (LuaValue)ValueFactory.valueOf((ds.hookcall ? "c" : "") + (ds.hookrtrn ? "r" : "") + (ds.hookline ? "l" : "")), (Varargs)ValueFactory.valueOf(ds.hookcount));
    }

    private static Varargs _sethook(LuaState state, Varargs args) throws LuaError {
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        int i1 = a++;
        LuaFunction func = args.arg(i1).optFunction(null);
        int i3 = a++;
        String str = args.arg(i3).optString("");
        int i2 = a++;
        int count = args.arg(i2).optInteger(0);
        boolean call = false;
        boolean line = false;
        boolean rtrn = false;
        if (func != null) {
            block5: for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case 'c': {
                        call = true;
                        continue block5;
                    }
                    case 'l': {
                        line = true;
                        continue block5;
                    }
                    case 'r': {
                        rtrn = true;
                    }
                }
            }
        } else {
            count = 0;
        }
        thread.getDebugState().setHook(func, call, line, rtrn, count);
        return Constants.NONE;
    }

    private static Varargs _getfenv(Varargs args) throws LuaError {
        LuaValue object = args.first();
        LuaTable env = object.getfenv();
        return env != null ? env : Constants.NIL;
    }

    private static Varargs _setfenv(Varargs args) throws LuaError {
        LuaValue object = args.first();
        LuaTable table = args.arg(2).checkTable();
        object.setfenv(table);
        return object;
    }

    protected static Varargs _getinfo(LuaState state, Varargs args, LuaValue level0func) throws LuaError {
        Object di;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        LuaValue func = args.arg(arg);
        String what = args.arg(arg + 1).optString("flnStu");
        DebugState ds = thread.getDebugState();
        if (func.isNumber()) {
            int level = func.checkInteger();
            di = thread != state.getCurrentThread() ? ds.getFrame(level) : (level < 0 ? null : (level == 0 ? new DebugFrame(level0func.checkFunction()) : ds.getFrame(level - 1)));
        } else {
            di = ds.findDebugInfo(func.checkFunction());
        }
        if (di == null) {
            return Constants.NIL;
        }
        LuaTable info = new LuaTable();
        LuaClosure c = ((DebugFrame)di).closure;
        int j = what.length();
        block9: for (int i = 0; i < j; ++i) {
            switch (what.charAt(i)) {
                case 'S': {
                    if (c != null) {
                        Prototype p = c.getPrototype();
                        info.rawset(WHAT, (LuaValue)(p.linedefined == 0 ? MAIN : LUA));
                        info.rawset(SOURCE, (LuaValue)p.source);
                        info.rawset(SHORT_SRC, (LuaValue)p.sourceShort());
                        info.rawset(LINEDEFINED, (LuaValue)ValueFactory.valueOf(p.linedefined));
                        info.rawset(LASTLINEDEFINED, (LuaValue)ValueFactory.valueOf(p.lastlinedefined));
                        continue block9;
                    }
                    String shortName = ((DebugFrame)di).func == null ? "nil" : ((DebugFrame)di).func.debugName();
                    LuaString name = ValueFactory.valueOf("[C] " + shortName);
                    info.rawset(WHAT, (LuaValue)C);
                    info.rawset(SOURCE, (LuaValue)name);
                    info.rawset(SHORT_SRC, (LuaValue)C_SOURCE);
                    info.rawset(LINEDEFINED, (LuaValue)Constants.MINUSONE);
                    info.rawset(LASTLINEDEFINED, (LuaValue)Constants.MINUSONE);
                    continue block9;
                }
                case 'l': {
                    int line = ((DebugFrame)di).currentLine();
                    info.rawset(CURRENTLINE, (LuaValue)ValueFactory.valueOf(line));
                    continue block9;
                }
                case 'u': {
                    info.rawset(NUPS, (LuaValue)ValueFactory.valueOf(c != null ? c.getPrototype().nups : 0));
                    info.rawset(NPARAMS, (LuaValue)ValueFactory.valueOf(c != null ? c.getPrototype().numparams : 0));
                    info.rawset(ISVARARG, (LuaValue)ValueFactory.valueOf(c == null || c.getPrototype().is_vararg > 0));
                    continue block9;
                }
                case 'n': {
                    LuaString[] kind = ((DebugFrame)di).getFuncKind();
                    info.rawset(NAME, kind != null ? kind[0] : Constants.NIL);
                    info.rawset(NAMEWHAT, (LuaValue)(kind != null ? kind[1] : Constants.EMPTYSTRING));
                    continue block9;
                }
                case 'f': {
                    info.rawset(FUNC, ((DebugFrame)di).func == null ? Constants.NIL : ((DebugFrame)di).func);
                    continue block9;
                }
                case 'L': {
                    if (((DebugFrame)di).closure == null) continue block9;
                    LuaTable lines = new LuaTable();
                    info.rawset(ACTIVELINES, (LuaValue)lines);
                    int[] lineinfo = ((DebugFrame)di).closure.getPrototype().lineinfo;
                    if (lineinfo == null) continue block9;
                    for (int line : lineinfo) {
                        lines.rawset(line, (LuaValue)Constants.TRUE);
                    }
                    continue block9;
                }
                case 't': {
                    info.rawset(ISTAILCALL, (LuaValue)ValueFactory.valueOf((((DebugFrame)di).flags & 0x2000) != 0));
                    continue block9;
                }
                default: {
                    throw ErrorFactory.argError(arg + 1, "invalid option");
                }
            }
        }
        return info;
    }

    private static Varargs _getlocal(LuaState state, Varargs args) throws LuaError {
        DebugState ds;
        DebugFrame di;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        int local = args.arg(arg + 1).checkInteger();
        if (args.arg(arg).isFunction()) {
            LuaFunction function = args.arg(arg).checkFunction();
            if (!function.isClosure()) {
                return Constants.NIL;
            }
            Prototype proto = function.checkClosure().getPrototype();
            LocalVariable[] variables = proto.locvars;
            return variables != null && local > 0 && local <= variables.length && local <= proto.numparams ? variables[local - 1].name : Constants.NIL;
        }
        int level = args.arg(arg).checkInteger();
        if (thread == state.getCurrentThread()) {
            --level;
        }
        if ((di = (ds = thread.getDebugState()).getFrame(level)) == null) {
            throw new LuaError("bad argument #" + arg + " (level out of range)");
        }
        LuaString name = di.getLocalName(local);
        if (name == null || di.stack == null) {
            return Constants.NIL;
        }
        LuaValue value = di.stack[local - 1];
        return ValueFactory.varargsOf((LuaValue)name, (Varargs)value);
    }

    private static Varargs _setlocal(LuaState state, Varargs args) throws LuaError {
        DebugFrame di;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        int level = args.arg(arg).checkInteger();
        int local = args.arg(arg + 1).checkInteger();
        LuaValue value = args.arg(arg + 2);
        DebugState ds = thread.getDebugState();
        if (thread == state.getCurrentThread()) {
            --level;
        }
        if ((di = ds.getFrame(level)) == null) {
            throw new LuaError("bad argument #" + arg + " (level out of range)");
        }
        LuaString name = di.getLocalName(local);
        if (name == null || di.stack == null) {
            return Constants.NIL;
        }
        di.stack[local - 1] = value;
        return name;
    }

    private static LuaValue _getmetatable(LuaState state, Varargs args) {
        LuaValue object = args.arg(1);
        LuaTable mt = object.getMetatable(state);
        return mt != null ? mt : Constants.NIL;
    }

    private static Varargs _setmetatable(LuaState state, Varargs args) {
        LuaValue object = args.arg(1);
        try {
            LuaTable mt = args.arg(2).optTable(null);
            switch (object.type()) {
                case 0: {
                    state.nilMetatable = mt;
                    break;
                }
                case 3: {
                    state.numberMetatable = mt;
                    break;
                }
                case 1: {
                    state.booleanMetatable = mt;
                    break;
                }
                case 4: {
                    state.stringMetatable = mt;
                    break;
                }
                case 6: {
                    state.functionMetatable = mt;
                    break;
                }
                case 8: {
                    state.threadMetatable = mt;
                    break;
                }
                default: {
                    object.setMetatable(state, mt);
                }
            }
            return Constants.TRUE;
        }
        catch (LuaError e) {
            return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)ValueFactory.valueOf(e.toString()));
        }
    }

    private static Varargs _getregistry(Varargs args) {
        return new LuaTable();
    }

    private static LuaString findupvalue(LuaClosure c, int up) {
        Prototype p = c.getPrototype();
        if (up > 0 && p.upvalues != null && up <= p.upvalues.length) {
            return p.upvalues[up - 1];
        }
        return null;
    }

    private static Varargs _getupvalue(Varargs args) throws LuaError {
        LuaClosure c;
        LuaString name;
        LuaFunction func = args.arg(1).checkFunction();
        int up = args.arg(2).checkInteger();
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            return ValueFactory.varargsOf((LuaValue)name, (Varargs)c.getUpvalue(up - 1).getValue());
        }
        return Constants.NIL;
    }

    private static LuaValue _setupvalue(Varargs args) throws LuaError {
        LuaClosure c;
        LuaString name;
        LuaFunction func = args.arg(1).checkFunction();
        int up = args.arg(2).checkInteger();
        LuaValue value = args.arg(3);
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            c.getUpvalue(up - 1).setValue(value);
            return name;
        }
        return Constants.NIL;
    }

    private static LuaValue _traceback(LuaState state, Varargs args) throws LuaError {
        LuaValue messageValue;
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        if ((messageValue = args.arg(a++)) != Constants.NIL && !messageValue.isString()) {
            return messageValue;
        }
        String message = messageValue.optString(null);
        int level = thread == state.getCurrentThread() ? args.arg(a).optInteger(1) - 1 : args.arg(a).optInteger(0);
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message).append('\n');
        }
        return ValueFactory.valueOf(DebugHelpers.traceback(sb, thread, level).toString());
    }

    private static LuaClosure getClosureForUpvalue(Varargs args, int offset, int upvalue) throws LuaError {
        LuaFunction function = args.arg(offset).checkFunction();
        if (function instanceof LuaClosure) {
            LuaClosure closure = (LuaClosure)function;
            if (upvalue >= 0 && upvalue < closure.getPrototype().nups) {
                return closure;
            }
        }
        throw ErrorFactory.argError(offset, "invalid upvalue index");
    }

    private static Varargs upvalueId(Varargs args) throws LuaError {
        int upvalue = args.arg(2).checkInteger() - 1;
        LuaClosure closure = DebugLib.getClosureForUpvalue(args, 1, upvalue);
        return new LuaUserdata(closure.getUpvalue(upvalue));
    }

    private static Varargs upvalueJoin(Varargs args) throws LuaError {
        int upvalue1 = args.arg(2).checkInteger() - 1;
        LuaClosure closure1 = DebugLib.getClosureForUpvalue(args, 1, upvalue1);
        int upvalue2 = args.arg(4).checkInteger() - 1;
        LuaClosure closure2 = DebugLib.getClosureForUpvalue(args, 3, upvalue2);
        closure1.setUpvalue(upvalue1, closure2.getUpvalue(upvalue2));
        return Constants.NONE;
    }
}

