/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.util;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import shadows.placebo.util.DeadPacketListenerImpl;

public class BlockUtil {
    public static boolean breakExtraBlock(ServerLevel world, BlockPos pos, ItemStack mainhand, @Nullable UUID source) {
        boolean removed;
        FakePlayer player;
        BlockState blockstate = world.m_8055_(pos);
        if (source != null) {
            player = FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(source, UsernameCache.getLastKnownUsername((UUID)source)));
            Player realPlayer = world.m_46003_(source);
            if (realPlayer != null) {
                player.m_146884_(realPlayer.m_20182_());
            }
        } else {
            player = FakePlayerFactory.getMinecraft((ServerLevel)world);
        }
        if (player.f_8906_ == null) {
            player.f_8906_ = new DeadPacketListenerImpl(player);
        }
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)mainhand);
        if (blockstate.m_60800_((BlockGetter)world, pos) < 0.0f || !blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player)) {
            return false;
        }
        GameType type = player.m_150110_().f_35937_ ? GameType.CREATIVE : GameType.SURVIVAL;
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        Block block = blockstate.m_60734_();
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.m_36337_()) {
            world.m_7260_(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.m_21205_().onBlockStartBreak(pos, (Player)player)) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, type)) {
            return false;
        }
        if (player.m_150110_().f_35937_) {
            BlockUtil.removeBlock(world, (ServerPlayer)player, pos, false);
            return true;
        }
        ItemStack itemstack = player.m_21205_();
        ItemStack itemstack1 = itemstack.m_41777_();
        boolean canHarvest = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
        itemstack.m_41686_((Level)world, blockstate, pos, (Player)player);
        if (itemstack.m_41619_() && !itemstack1.m_41619_()) {
            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        if ((removed = BlockUtil.removeBlock(world, (ServerPlayer)player, pos, canHarvest)) && canHarvest) {
            block.m_6240_((Level)world, (Player)player, pos, blockstate, tileentity, itemstack1);
        }
        if (removed && exp > 0) {
            blockstate.m_60734_().m_49805_(world, pos, exp);
        }
        return true;
    }

    public static boolean removeBlock(ServerLevel world, ServerPlayer player, BlockPos pos, boolean canHarvest) {
        BlockState state = world.m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer((Level)world, pos, (Player)player, canHarvest, world.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return removed;
    }
}

