/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.spawn;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.spawn.compat.SpawnerTOPPlugin;
import shadows.apotheosis.spawn.enchantment.CapturingEnchant;
import shadows.apotheosis.spawn.modifiers.SpawnerModifier;
import shadows.apotheosis.spawn.spawner.ApothSpawnerBlock;
import shadows.apotheosis.spawn.spawner.ApothSpawnerItem;
import shadows.apotheosis.spawn.spawner.ApothSpawnerTile;
import shadows.placebo.config.Configuration;
import shadows.placebo.util.PlaceboUtil;

public class SpawnerModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Spawner");
    public static int spawnerSilkLevel = 1;
    public static int spawnerSilkDamage = 100;
    public static Set<ResourceLocation> bannedMobs = new HashSet<ResourceLocation>();

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        BlockEntityType.f_58925_.f_58914_ = ApothSpawnerTile::new;
        BlockEntityType.f_58925_.f_58915_ = ImmutableSet.of((Object)Blocks.f_50085_);
        MinecraftForge.EVENT_BUS.addListener(this::dropsEvent);
        MinecraftForge.EVENT_BUS.addListener(this::handleUseItem);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        MinecraftForge.EVENT_BUS.addListener(this::handleTooltips);
        MinecraftForge.EVENT_BUS.addListener(this::tickDumbMobs);
        this.reload(null);
        ObfuscationReflectionHelper.setPrivateValue(Item.class, (Object)Items.f_42007_, (Object)CreativeModeTab.f_40753_, (String)"f_41377_");
        if (ModList.get().isLoaded("theoneprobe")) {
            SpawnerTOPPlugin.register();
        }
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        ApothSpawnerBlock spawner = new ApothSpawnerBlock();
        PlaceboUtil.overrideStates((Block)Blocks.f_50085_, (Block)spawner);
        e.getRegistry().register((IForgeRegistryEntry)spawner);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)new ApothSpawnerItem());
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)SpawnerModifier.SERIALIZER.setRegistryName("spawner_modifier")));
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Enchantment)new CapturingEnchant().setRegistryName("apotheosis", "capturing")));
    }

    public void dropsEvent(LivingDropsEvent e) {
        Apoth.Enchantments.CAPTURING.handleCapturing(e);
    }

    public void handleUseItem(PlayerInteractEvent.RightClickBlock e) {
        SpawnEggItem egg;
        EntityType type;
        ItemStack s;
        Item item;
        if (e.getWorld().m_7702_(e.getPos()) instanceof ApothSpawnerTile && (item = (s = e.getItemStack()).m_41720_()) instanceof SpawnEggItem && bannedMobs.contains((type = (egg = (SpawnEggItem)item).m_43228_(s.m_41783_())).getRegistryName())) {
            e.setCanceled(true);
        }
    }

    public void handleTooltips(ItemTooltipEvent e) {
        SpawnEggItem egg;
        EntityType type;
        ItemStack s = e.getItemStack();
        Item item = s.m_41720_();
        if (item instanceof SpawnEggItem && bannedMobs.contains((type = (egg = (SpawnEggItem)item).m_43228_(s.m_41783_())).getRegistryName())) {
            e.getToolTip().add(new TranslatableComponent("misc.apotheosis.banned").m_130940_(ChatFormatting.GRAY));
        }
    }

    public void tickDumbMobs(LivingEvent.LivingUpdateEvent e) {
        LivingEntity livingEntity = e.getEntityLiving();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            if (!mob.f_19853_.f_46443_ && mob.m_21525_() && mob.getPersistentData().m_128471_("apotheosis:movable")) {
                mob.m_21557_(false);
                mob.m_7023_(new Vec3((double)mob.f_20900_, (double)mob.f_20902_, (double)mob.f_20901_));
                mob.m_21557_(true);
            }
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        String[] bans;
        Configuration config = new Configuration(new File(Apotheosis.configDir, "spawner.cfg"));
        config.setTitle("Apotheosis Spawner Module Configuration");
        spawnerSilkLevel = config.getInt("Spawner Silk Level", "general", 1, -1, 127, "The level of silk touch needed to harvest a spawner.  Set to -1 to disable, 0 to always drop.  The enchantment module can increase the max level of silk touch.");
        spawnerSilkDamage = config.getInt("Spawner Silk Damage", "general", 100, 0, 100000, "The durability damage dealt to an item that silk touches a spawner.");
        bannedMobs.clear();
        for (String s : bans = config.getStringList("Banned Mobs", "spawn_eggs", new String[0], "A list of entity registry names that cannot be applied to spawners via egg.")) {
            try {
                bannedMobs.add(new ResourceLocation(s));
            }
            catch (ResourceLocationException ex) {
                LOG.error("Invalid entry {} detected in the spawner banned mobs list.", (Object)s);
                ex.printStackTrace();
            }
        }
        if (e == null && config.hasChanged()) {
            config.save();
        }
    }
}

