/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.potion;

import java.io.File;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.potion.LuckyFootItem;
import shadows.apotheosis.potion.PotionCharmItem;
import shadows.apotheosis.potion.PotionCharmRecipe;
import shadows.apotheosis.potion.PotionEnchantingRecipe;
import shadows.apotheosis.potion.PotionModuleClient;
import shadows.apotheosis.potion.compat.CuriosCompat;
import shadows.apotheosis.potion.potions.KnowledgeEffect;
import shadows.apotheosis.potion.potions.SunderingEffect;
import shadows.placebo.config.Configuration;
import top.theillusivec4.curios.api.SlotTypeMessage;

public class PotionModule {
    public static final Logger LOG = LogManager.getLogger((String)"Apotheosis : Potion");
    public static final ResourceLocation POTION_TEX = new ResourceLocation("apotheosis", "textures/potions.png");
    static int knowledgeMult = 4;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        this.reload(null);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().register((Object)new PotionModuleClient()));
        InterModComms.sendTo((String)"curios", (String)"REGISTER_TYPE", () -> new SlotTypeMessage.Builder("charm").size(1).build());
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        e.enqueueWork(() -> {
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42748_, (Potion)Apoth.Potions.RESISTANCE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.RESISTANCE, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_RESISTANCE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.RESISTANCE, (Item)Items.f_42525_, (Potion)Apoth.Potions.STRONG_RESISTANCE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.RESISTANCE, (Item)Items.f_42592_, (Potion)Apoth.Potions.SUNDERING);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.LONG_RESISTANCE, (Item)Items.f_42592_, (Potion)Apoth.Potions.LONG_SUNDERING);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.STRONG_RESISTANCE, (Item)Items.f_42592_, (Potion)Apoth.Potions.STRONG_SUNDERING);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.SUNDERING, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_SUNDERING);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.SUNDERING, (Item)Items.f_42525_, (Potion)Apoth.Potions.STRONG_SUNDERING);
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42436_, (Potion)Apoth.Potions.ABSORPTION);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.ABSORPTION, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_ABSORPTION);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.ABSORPTION, (Item)Items.f_42525_, (Potion)Apoth.Potions.STRONG_ABSORPTION);
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42400_, (Potion)Apoth.Potions.HASTE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.HASTE, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_HASTE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.HASTE, (Item)Items.f_42525_, (Potion)Apoth.Potions.STRONG_HASTE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.HASTE, (Item)Items.f_42592_, (Potion)Apoth.Potions.FATIGUE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.LONG_HASTE, (Item)Items.f_42592_, (Potion)Apoth.Potions.LONG_FATIGUE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.STRONG_HASTE, (Item)Items.f_42592_, (Potion)Apoth.Potions.STRONG_FATIGUE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.FATIGUE, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_FATIGUE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.FATIGUE, (Item)Items.f_42525_, (Potion)Apoth.Potions.STRONG_FATIGUE);
            if (Apoth.Items.SKULL_FRAGMENT != null) {
                PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Apoth.Items.SKULL_FRAGMENT, (Potion)Apoth.Potions.WITHER);
            } else {
                PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42679_, (Potion)Apoth.Potions.WITHER);
            }
            PotionBrewing.m_43513_((Potion)Apoth.Potions.WITHER, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_WITHER);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.WITHER, (Item)Items.f_42525_, (Potion)Apoth.Potions.STRONG_WITHER);
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Items.f_42612_, (Potion)Apoth.Potions.KNOWLEDGE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.KNOWLEDGE, (Item)Items.f_42451_, (Potion)Apoth.Potions.LONG_KNOWLEDGE);
            PotionBrewing.m_43513_((Potion)Apoth.Potions.KNOWLEDGE, (Item)Items.f_42612_, (Potion)Apoth.Potions.STRONG_KNOWLEDGE);
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)Apoth.Items.LUCKY_FOOT, (Potion)Potions.f_43595_);
        });
        Apotheosis.HELPER.registerProvider(factory -> {
            Ingredient fireRes = Apotheosis.potionIngredient(Potions.f_43610_);
            Ingredient abs = Apotheosis.potionIngredient(Apoth.Potions.STRONG_ABSORPTION);
            Ingredient res = Apotheosis.potionIngredient(Apoth.Potions.RESISTANCE);
            Ingredient regen = Apotheosis.potionIngredient(Potions.f_43589_);
            factory.addShaped((Object)Items.f_42437_, 3, 3, new Object[]{fireRes, regen, fireRes, abs, Items.f_42436_, abs, res, abs, res});
        });
        MinecraftForge.EVENT_BUS.addListener(this::drops);
        MinecraftForge.EVENT_BUS.addListener(this::xp);
        MinecraftForge.EVENT_BUS.addListener(this::reload);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new LuckyFootItem().setRegistryName("apotheosis", "lucky_foot"), (Item)new PotionCharmItem().setRegistryName("apotheosis", "potion_charm")});
    }

    @SubscribeEvent
    public void types(RegistryEvent.Register<Potion> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{(Potion)new Potion("resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 3600)}).setRegistryName("apotheosis", "resistance"), (Potion)new Potion("resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 9600)}).setRegistryName("apotheosis", "long_resistance"), (Potion)new Potion("resistance", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19606_, 1800, 1)}).setRegistryName("apotheosis", "strong_resistance"), (Potion)new Potion("absorption", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19617_, 1200, 1)}).setRegistryName("apotheosis", "absorption"), (Potion)new Potion("absorption", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19617_, 3600, 1)}).setRegistryName("apotheosis", "long_absorption"), (Potion)new Potion("absorption", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19617_, 600, 3)}).setRegistryName("apotheosis", "strong_absorption"), (Potion)new Potion("haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 3600)}).setRegistryName("apotheosis", "haste"), (Potion)new Potion("haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 9600)}).setRegistryName("apotheosis", "long_haste"), (Potion)new Potion("haste", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 1800, 1)}).setRegistryName("apotheosis", "strong_haste"), (Potion)new Potion("fatigue", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19599_, 3600)}).setRegistryName("apotheosis", "fatigue"), (Potion)new Potion("fatigue", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19599_, 9600)}).setRegistryName("apotheosis", "long_fatigue"), (Potion)new Potion("fatigue", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19599_, 1800, 1)}).setRegistryName("apotheosis", "strong_fatigue"), (Potion)new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 3600)}).setRegistryName("apotheosis", "wither"), (Potion)new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 9600)}).setRegistryName("apotheosis", "long_wither"), (Potion)new Potion("wither", new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19615_, 1800, 1)}).setRegistryName("apotheosis", "strong_wither"), (Potion)new Potion("sundering", new MobEffectInstance[]{new MobEffectInstance((MobEffect)Apoth.Effects.SUNDERING, 3600)}).setRegistryName("apotheosis", "sundering"), (Potion)new Potion("sundering", new MobEffectInstance[]{new MobEffectInstance((MobEffect)Apoth.Effects.SUNDERING, 9600)}).setRegistryName("apotheosis", "long_sundering"), (Potion)new Potion("sundering", new MobEffectInstance[]{new MobEffectInstance((MobEffect)Apoth.Effects.SUNDERING, 1800, 1)}).setRegistryName("apotheosis", "strong_sundering"), (Potion)new Potion("knowledge", new MobEffectInstance[]{new MobEffectInstance((MobEffect)Apoth.Effects.KNOWLEDGE, 2400)}).setRegistryName("apotheosis", "knowledge"), (Potion)new Potion("knowledge", new MobEffectInstance[]{new MobEffectInstance((MobEffect)Apoth.Effects.KNOWLEDGE, 4800)}).setRegistryName("apotheosis", "long_knowledge"), (Potion)new Potion("knowledge", new MobEffectInstance[]{new MobEffectInstance((MobEffect)Apoth.Effects.KNOWLEDGE, 1200, 1)}).setRegistryName("apotheosis", "strong_knowledge")});
    }

    @SubscribeEvent
    public void potions(RegistryEvent.Register<MobEffect> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MobEffect)new SunderingEffect().setRegistryName("apotheosis", "sundering")));
        e.getRegistry().register((IForgeRegistryEntry)((MobEffect)new KnowledgeEffect().setRegistryName("apotheosis", "knowledge")));
        ObjectHolderRegistry.applyObjectHolders(r -> r.m_135827_().equals("apotheosis") && (r.m_135815_().equals("sundering") || r.m_135815_().equals("knowledge")));
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)PotionCharmRecipe.Serializer.INSTANCE.setRegistryName(Apoth.Items.POTION_CHARM.getRegistryName())));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)PotionEnchantingRecipe.SERIALIZER.setRegistryName("potion_charm_enchanting")));
    }

    @SubscribeEvent
    public void imcEvent(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.sendIMC();
        }
    }

    public void drops(LivingDropsEvent e) {
        if (e.getEntityLiving() instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)e.getEntityLiving();
            if (rabbit.f_19853_.f_46441_.nextFloat() < 0.045f + 0.045f * (float)e.getLootingLevel()) {
                e.getDrops().clear();
                e.getDrops().add(new ItemEntity(rabbit.f_19853_, rabbit.m_20185_(), rabbit.m_20186_(), rabbit.m_20189_(), new ItemStack((ItemLike)Apoth.Items.LUCKY_FOOT)));
            }
        }
    }

    public void xp(LivingExperienceDropEvent e) {
        if (e.getAttackingPlayer() != null && e.getAttackingPlayer().m_21124_((MobEffect)Apoth.Effects.KNOWLEDGE) != null) {
            int level = e.getAttackingPlayer().m_21124_((MobEffect)Apoth.Effects.KNOWLEDGE).m_19564_() + 1;
            int curXp = e.getDroppedExperience();
            int newXp = curXp + e.getOriginalExperience() * level * knowledgeMult;
            e.setDroppedExperience(newXp);
        }
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration config = new Configuration(new File(Apotheosis.configDir, "potion.cfg"));
        knowledgeMult = config.getInt("Knowledge XP Multiplier", "general", knowledgeMult, 1, Integer.MAX_VALUE, "The strength of Ancient Knowledge.  This multiplier determines how much additional xp is granted.");
        String[] defExt = new String[]{MobEffects.f_19611_.getRegistryName().toString(), MobEffects.f_19616_.getRegistryName().toString()};
        String[] names = config.getStringList("Extended Potion Charms", "general", defExt, "A list of effects that, when as charms, will be applied and reapplied at a longer threshold to avoid issues at low durations, like night vision.");
        PotionCharmItem.EXTENDED_POTIONS.clear();
        for (String s : names) {
            try {
                PotionCharmItem.EXTENDED_POTIONS.add(new ResourceLocation(s));
            }
            catch (ResourceLocationException ex) {
                LOG.error("Invalid extended potion charm entry {} will be ignored.", (Object)s);
            }
        }
        if (e == null && config.hasChanged()) {
            config.save();
        }
    }
}

