/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench.library;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.apotheosis.ench.library.EnchLibraryTile;
import shadows.placebo.Placebo;
import shadows.placebo.packets.ButtonClickMessage;

public class EnchLibraryScreen
extends AbstractContainerScreen<EnchLibraryContainer> {
    public static final ResourceLocation TEXTURES = new ResourceLocation("apotheosis", "textures/gui/library.png");
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    protected EditBox filter = null;
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.f_97726_ = 176;
        this.f_96543_ = 176;
        this.f_97727_ = 241;
        this.f_96544_ = 241;
        this.f_97730_ = 7;
        this.f_97728_ = 7;
        this.f_97729_ = 4;
        this.f_97731_ = 149;
        this.containerChanged();
        container.setNotifier(this::containerChanged);
    }

    protected void m_7856_() {
        super.m_7856_();
        int n = this.getGuiLeft() + 91;
        int n2 = this.getGuiTop() + 20;
        Objects.requireNonNull(this.f_96547_);
        int n3 = n2 + 9 + 2;
        Objects.requireNonNull(this.f_96547_);
        this.filter = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, n, n3, 78, 9 + 4, this.filter, (Component)new TextComponent("")));
        this.filter.m_94151_(t -> this.containerChanged());
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (pKeyCode == 256 && this.m_7222_() == this.filter) {
            this.m_7522_(null);
            this.filter.m_94178_(false);
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.m_7222_() == this.filter) {
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7025_(PoseStack stack, int mouseX, int mouseY) {
        super.m_7025_(stack, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(new TranslatableComponent(libSlot.ench.m_44704_()).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFF80)).m_131162_(Boolean.valueOf(true))));
            if (I18n.m_118936_((String)(libSlot.ench.m_44704_() + ".desc"))) {
                MutableComponent txt = new TranslatableComponent(libSlot.ench.m_44704_() + ".desc").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY).m_131155_(Boolean.valueOf(true)));
                list.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)txt, this.getGuiLeft() - 16, txt.m_7383_()));
                list.add(new TextComponent(""));
            }
            list.add(new TranslatableComponent("tooltip.enchlib.max_lvl", new Object[]{new TranslatableComponent("enchantment.level." + libSlot.maxLvl)}).m_130940_(ChatFormatting.GRAY));
            list.add(new TranslatableComponent("tooltip.enchlib.points", new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.f_97732_).getPointCap())}).m_130940_(ChatFormatting.GRAY));
            list.add(new TextComponent(""));
            ItemStack outSlot = ((EnchLibraryContainer)this.f_97732_).ioInv.m_8020_(1);
            int current = EnchantmentHelper.m_44831_((ItemStack)outSlot).getOrDefault(libSlot.ench, 0);
            boolean shift = Screen.m_96638_();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(new TranslatableComponent("tooltip.enchlib.unavailable").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            } else {
                list.add(new TranslatableComponent("tooltip.enchlib.extracting", new Object[]{new TranslatableComponent("enchantment.level." + targetLevel)}).m_130940_(ChatFormatting.BLUE));
                list.add(new TranslatableComponent("tooltip.enchlib.cost", new Object[]{cost}).m_130940_(cost > libSlot.points ? ChatFormatting.RED : ChatFormatting.GOLD));
            }
            this.renderComponentTooltip(stack, list, this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.f_96547_).m_92852_(arg_0)).max(Integer::compare).get(), mouseY, this.f_96547_);
        }
    }

    protected void m_7286_(PoseStack stack, float partial, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        int left = this.f_97735_;
        int top = this.f_97736_;
        this.m_93228_(stack, left, top, 0, 0, this.f_97726_, this.f_97727_);
        int scrollbarPos = (int)(118.0f * this.scrollOffs);
        this.m_93228_(stack, left + 75, top + 14 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 7 && idx < this.data.size(); ++idx) {
            this.renderEntry(stack, this.data.get(idx), this.f_97735_ + 8, this.f_97736_ + 14 + 19 * (idx - this.startIndex), mouseX, mouseY);
        }
        this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("tooltip.enchlib.nfilt"), (float)(this.getGuiLeft() + 91), (float)(this.getGuiTop() + 20), 0x404040);
        this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("tooltip.enchlib.ifilt"), (float)(this.getGuiLeft() + 91), (float)(this.getGuiTop() + 50), 0x404040);
    }

    private void renderEntry(PoseStack stack, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURES);
        boolean hover = this.m_6774_(x - this.f_97735_, y - this.f_97736_, 64, 17, mouseX, mouseY);
        this.m_93228_(stack, x, y, 178, hover ? 19 : 0, 64, 19);
        int progress = (int)Math.round(62.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.f_97732_).getPointCap())));
        this.m_93228_(stack, x + 1, y + 12, 179, 38, progress, 5);
        stack.m_85836_();
        TranslatableComponent txt = new TranslatableComponent(data.ench.m_44704_());
        float scale = 1.0f;
        if (this.f_96547_.m_92852_((FormattedText)txt) > 60) {
            scale = 60.0f / (float)this.f_96547_.m_92852_((FormattedText)txt);
        }
        stack.m_85841_(scale, scale, 1.0f);
        this.f_96547_.m_92889_(stack, (Component)txt, (float)(x + 2) / scale, (float)(y + 2) / scale, 0xFFFF80);
        stack.m_85849_();
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        this.scrolling = false;
        int left = this.f_97735_ + 52;
        int top = this.f_97736_ + 14;
        LibrarySlot libSlot = this.getHoveredSlot((int)pMouseX, (int)pMouseY);
        if (libSlot != null) {
            int id = ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)libSlot.ench);
            if (Screen.m_96638_()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.f_97732_).onButtonClick(id);
            Placebo.CHANNEL.sendToServer((Object)new ButtonClickMessage(id));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
        }
        left = this.f_97735_ + 75;
        top = this.f_97736_ + 9;
        if (pMouseX >= (double)left && pMouseX < (double)(left + 12) && pMouseY >= (double)top && pMouseY < (double)(top + 131)) {
            this.scrolling = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 131;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 7;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 7;
    }

    private void containerChanged() {
        this.data.clear();
        List<Object2IntMap.Entry<Enchantment>> entries = this.filter(((EnchLibraryContainer)this.f_97732_).getPointsForDisplay());
        for (Object2IntMap.Entry<Enchantment> e : entries) {
            this.data.add(new LibrarySlot((Enchantment)e.getKey(), e.getIntValue(), ((EnchLibraryContainer)this.f_97732_).getMaxLevel((Enchantment)e.getKey())));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, (a, b) -> I18n.m_118938_((String)a.ench.m_44704_(), (Object[])new Object[0]).compareTo(I18n.m_118938_((String)b.ench.m_44704_(), (Object[])new Object[0])));
    }

    private List<Object2IntMap.Entry<Enchantment>> filter(List<Object2IntMap.Entry<Enchantment>> list) {
        return list.stream().filter(this::isAllowedByItem).filter(this::isAllowedBySearch).toList();
    }

    private boolean isAllowedByItem(Object2IntMap.Entry<Enchantment> e) {
        ItemStack stack = ((EnchLibraryContainer)this.f_97732_).ioInv.m_8020_(2);
        return stack.m_41619_() || stack.canApplyAtEnchantingTable((Enchantment)e.getKey());
    }

    private boolean isAllowedBySearch(Object2IntMap.Entry<Enchantment> e) {
        String name = I18n.m_118938_((String)((Enchantment)e.getKey()).m_44704_(), (Object[])new Object[0]).toLowerCase(Locale.ROOT);
        String search = this.filter == null ? "" : this.filter.m_94155_().trim().toLowerCase(Locale.ROOT);
        return Strings.isNullOrEmpty((String)search) || ChatFormatting.m_126649_((String)name).contains(search);
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 7; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.m_6774_(8, 14 + 19 * i, 64, 17, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private static class LibrarySlot {
        protected final Enchantment ench;
        protected final int points;
        protected final int maxLvl;

        private LibrarySlot(Enchantment ench, int points, int maxLvl) {
            this.ench = ench;
            this.points = points;
            this.maxLvl = maxLvl;
        }
    }
}

