/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.ench;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.ench.EnchModuleClient;
import shadows.apotheosis.ench.EnchModuleEvents;
import shadows.apotheosis.ench.EnchantmentInfo;
import shadows.apotheosis.ench.anvil.AnvilTile;
import shadows.apotheosis.ench.anvil.ApothAnvilBlock;
import shadows.apotheosis.ench.anvil.ApothAnvilItem;
import shadows.apotheosis.ench.anvil.ObliterationEnchant;
import shadows.apotheosis.ench.anvil.SplittingEnchant;
import shadows.apotheosis.ench.compat.EnchTOPPlugin;
import shadows.apotheosis.ench.enchantments.ChromaticEnchant;
import shadows.apotheosis.ench.enchantments.IcyThornsEnchant;
import shadows.apotheosis.ench.enchantments.InertEnchantment;
import shadows.apotheosis.ench.enchantments.NaturesBlessingEnchant;
import shadows.apotheosis.ench.enchantments.ReboundingEnchant;
import shadows.apotheosis.ench.enchantments.ReflectiveEnchant;
import shadows.apotheosis.ench.enchantments.ShieldBashEnchant;
import shadows.apotheosis.ench.enchantments.SpearfishingEnchant;
import shadows.apotheosis.ench.enchantments.StableFootingEnchant;
import shadows.apotheosis.ench.enchantments.TemptingEnchant;
import shadows.apotheosis.ench.enchantments.corrupted.BerserkersFuryEnchant;
import shadows.apotheosis.ench.enchantments.corrupted.LifeMendingEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.ChainsawEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.CrescendoEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.EarthsBoonEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.EndlessQuiverEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.GrowthSerumEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.KnowledgeEnchant;
import shadows.apotheosis.ench.enchantments.masterwork.ScavengerEnchant;
import shadows.apotheosis.ench.enchantments.twisted.ExploitationEnchant;
import shadows.apotheosis.ench.enchantments.twisted.MinersFervorEnchant;
import shadows.apotheosis.ench.library.EnchLibraryBlock;
import shadows.apotheosis.ench.library.EnchLibraryContainer;
import shadows.apotheosis.ench.library.EnchLibraryTile;
import shadows.apotheosis.ench.objects.GlowyItem;
import shadows.apotheosis.ench.objects.ScrappingTomeItem;
import shadows.apotheosis.ench.objects.TomeItem;
import shadows.apotheosis.ench.replacements.BaneEnchant;
import shadows.apotheosis.ench.replacements.DefenseEnchant;
import shadows.apotheosis.ench.table.ApothEnchantBlock;
import shadows.apotheosis.ench.table.ApothEnchantContainer;
import shadows.apotheosis.ench.table.ApothEnchantTile;
import shadows.apotheosis.ench.table.EnchantingRecipe;
import shadows.apotheosis.ench.table.EnchantingStatManager;
import shadows.apotheosis.ench.table.KeepNBTEnchantingRecipe;
import shadows.placebo.config.Configuration;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.PlaceboUtil;

public class EnchModule {
    public static final Map<Enchantment, EnchantmentInfo> ENCHANTMENT_INFO = new HashMap<Enchantment, EnchantmentInfo>();
    public static final Object2IntMap<Enchantment> ENCH_HARD_CAPS = new Object2IntOpenHashMap();
    public static final String ENCH_HARD_CAP_IMC = "set_ench_hard_cap";
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Enchantment");
    public static final List<TomeItem> TYPED_BOOKS = new ArrayList<TomeItem>();
    public static final DamageSource CORRUPTED = new DamageSource("apoth_corrupted").m_19380_().m_19382_();
    public static final EquipmentSlot[] ARMOR = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final EnchantmentCategory HOE = EnchantmentCategory.create((String)"HOE", i -> i instanceof HoeItem);
    public static final EnchantmentCategory SHIELD = EnchantmentCategory.create((String)"SHIELD", i -> i instanceof ShieldItem);
    public static final EnchantmentCategory ANVIL = EnchantmentCategory.create((String)"ANVIL", i -> i instanceof BlockItem && ((BlockItem)i).m_40614_() instanceof AnvilBlock);
    public static final EnchantmentCategory SHEARS = EnchantmentCategory.create((String)"SHEARS", i -> i instanceof ShearsItem);
    public static final EnchantmentCategory PICKAXE = EnchantmentCategory.create((String)"PICKAXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.PICKAXE_DIG));
    public static final EnchantmentCategory AXE = EnchantmentCategory.create((String)"AXE", i -> i.canPerformAction(new ItemStack((ItemLike)i), ToolActions.AXE_DIG));
    public static final EnchantmentCategory ARMOR_CHEST_LEGS = EnchantmentCategory.create((String)"ARMOR_CHEST_LEGS", i -> EnchantmentCategory.ARMOR_CHEST.m_7454_(i) || EnchantmentCategory.ARMOR_LEGS.m_7454_(i));
    static Configuration enchInfoConfig;

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        Apotheosis.HELPER.registerProvider(factory -> {
            Ingredient pot = Apotheosis.potionIngredient(Potions.f_43587_);
            factory.addShaped((Object)Apoth.Blocks.HELLSHELF, 3, 3, new Object[]{Blocks.f_50197_, Blocks.f_50197_, Blocks.f_50197_, Items.f_42585_, "forge:bookshelves", pot, Blocks.f_50197_, Blocks.f_50197_, Blocks.f_50197_});
            factory.addShaped((Object)Apoth.Items.PRISMATIC_WEB, 3, 3, new Object[]{null, Items.f_42695_, null, Items.f_42695_, Blocks.f_50033_, Items.f_42695_, null, Items.f_42695_, null});
            ItemStack book = new ItemStack((ItemLike)Items.f_42517_);
            ItemStack stick = new ItemStack((ItemLike)Items.f_42398_);
            ItemStack blaze = new ItemStack((ItemLike)Items.f_42585_);
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.HELMET_TOME, 5), 3, 2, new Object[]{book, book, book, book, blaze, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.CHESTPLATE_TOME, 8), 3, 3, new Object[]{book, blaze, book, book, book, book, book, book, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.LEGGINGS_TOME, 7), 3, 3, new Object[]{book, null, book, book, blaze, book, book, book, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.BOOTS_TOME, 4), 3, 2, new Object[]{book, null, book, book, blaze, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.WEAPON_TOME, 2), 1, 3, new Object[]{book, book, new ItemStack((ItemLike)Items.f_42593_)});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.PICKAXE_TOME, 3), 3, 3, new Object[]{book, book, book, null, blaze, null, null, stick, null});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.FISHING_TOME, 2), 3, 3, new Object[]{null, null, blaze, null, stick, book, stick, null, book});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.BOW_TOME, 3), 3, 3, new Object[]{null, stick, book, blaze, null, book, null, stick, book});
            factory.addShapeless((Object)new ItemStack((ItemLike)Apoth.Items.OTHER_TOME, 6), new Object[]{book, book, book, book, book, book, blaze});
            factory.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.SCRAP_TOME, 8), 3, 3, new Object[]{book, book, book, book, Blocks.f_50322_, book, book, book, book});
            Ingredient maxHellshelf = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Apoth.Blocks.INFUSED_HELLSHELF});
            factory.addShaped((Object)Apoth.Blocks.BLAZING_HELLSHELF, 3, 3, new Object[]{null, Items.f_42613_, null, Items.f_42613_, maxHellshelf, Items.f_42613_, Items.f_42593_, Items.f_42593_, Items.f_42593_});
            factory.addShaped((Object)Apoth.Blocks.GLOWING_HELLSHELF, 3, 3, new Object[]{null, Blocks.f_50141_, null, null, maxHellshelf, null, Blocks.f_50141_, null, Blocks.f_50141_});
            factory.addShaped((Object)Apoth.Blocks.SEASHELF, 3, 3, new Object[]{Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50378_, Apotheosis.potionIngredient(Potions.f_43599_), "forge:bookshelves", Items.f_42529_, Blocks.f_50378_, Blocks.f_50378_, Blocks.f_50378_});
            Ingredient maxSeashelf = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Apoth.Blocks.INFUSED_SEASHELF});
            factory.addShaped((Object)Apoth.Blocks.CRYSTAL_SEASHELF, 3, 3, new Object[]{null, Items.f_42696_, null, null, maxSeashelf, null, Items.f_42696_, null, Items.f_42696_});
            factory.addShaped((Object)Apoth.Blocks.HEART_SEASHELF, 3, 3, new Object[]{null, Items.f_42716_, null, Items.f_42695_, maxSeashelf, Items.f_42695_, Items.f_42695_, Items.f_42695_, Items.f_42695_});
            factory.addShaped((Object)Apoth.Blocks.ENDSHELF, 3, 3, new Object[]{Blocks.f_50443_, Blocks.f_50443_, Blocks.f_50443_, Items.f_42735_, "forge:bookshelves", Items.f_42584_, Blocks.f_50443_, Blocks.f_50443_, Blocks.f_50443_});
            factory.addShaped((Object)Apoth.Blocks.PEARL_ENDSHELF, 3, 3, new Object[]{Items.f_42001_, null, Items.f_42001_, Items.f_42584_, Apoth.Blocks.ENDSHELF, Items.f_42584_, Items.f_42001_, null, Items.f_42001_});
            factory.addShaped((Object)Apoth.Blocks.DRACONIC_ENDSHELF, 3, 3, new Object[]{null, Items.f_42683_, null, Items.f_42584_, Apoth.Blocks.ENDSHELF, Items.f_42584_, Items.f_42584_, Items.f_42584_, Items.f_42584_});
            factory.addShaped((Object)Apoth.Blocks.BEESHELF, 3, 3, new Object[]{Items.f_42784_, Items.f_42786_, Items.f_42784_, Items.f_42788_, "forge:bookshelves", Items.f_42788_, Items.f_42784_, Items.f_42786_, Items.f_42784_});
            factory.addShaped((Object)Apoth.Blocks.MELONSHELF, 3, 3, new Object[]{Items.f_42028_, Items.f_42028_, Items.f_42028_, Items.f_42546_, "forge:bookshelves", Items.f_42546_, Items.f_42028_, Items.f_42028_, Items.f_42028_});
            factory.addShaped((Object)Apoth.Blocks.LIBRARY, 3, 3, new Object[]{Blocks.f_50265_, Apoth.Blocks.INFUSED_HELLSHELF, Blocks.f_50265_, Apoth.Blocks.INFUSED_HELLSHELF, Blocks.f_50201_, Apoth.Blocks.INFUSED_HELLSHELF, Blocks.f_50265_, Apoth.Blocks.INFUSED_HELLSHELF, Blocks.f_50265_});
        });
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.HELLSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.INFUSED_HELLSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.BLAZING_HELLSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.GLOWING_HELLSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.SEASHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.INFUSED_SEASHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.CRYSTAL_SEASHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.HEART_SEASHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.ENDSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.PEARL_ENDSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.DRACONIC_ENDSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.BEESHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.MELONSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.LIBRARY);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.RECTIFIER);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.RECTIFIER_T2);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.RECTIFIER_T3);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.SIGHTSHELF);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.SIGHTSHELF_T2);
        LootSystem.defaultBlockTable((Block)Apoth.Blocks.ENDER_LIBRARY);
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        e.enqueueWork(() -> DispenserBlock.m_52672_((ItemLike)Items.f_42574_, (DispenseItemBehavior)new ShearsDispenseItemBehavior()));
        if (ModList.get().isLoaded("theoneprobe")) {
            EnchTOPPlugin.register();
        }
        EnchantingStatManager.INSTANCE.registerToBus();
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new EnchModuleClient());
        e.enqueueWork(EnchModuleClient::init);
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(AnvilTile::new, (Set)ImmutableSet.of((Object)Blocks.f_50322_, (Object)Blocks.f_50323_, (Object)Blocks.f_50324_), null).setRegistryName("anvil")));
        BlockEntityType.f_58928_.f_58914_ = ApothEnchantTile::new;
        BlockEntityType.f_58928_.f_58915_ = ImmutableSet.of((Object)Blocks.f_50201_);
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(EnchLibraryTile.BasicLibraryTile::new, (Set)ImmutableSet.of((Object)((Object)Apoth.Blocks.LIBRARY)), null).setRegistryName("library")));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new BlockEntityType(EnchLibraryTile.EnderLibraryTile::new, (Set)ImmutableSet.of((Object)((Object)Apoth.Blocks.ENDER_LIBRARY)), null).setRegistryName("ender_library")));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(ApothEnchantContainer::new).setRegistryName("enchanting_table")));
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)ContainerUtil.makeType(EnchLibraryContainer::new).setRegistryName("library")));
    }

    @SubscribeEvent
    public void recipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)EnchantingRecipe.SERIALIZER.setRegistryName("enchanting")));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)KeepNBTEnchantingRecipe.SERIALIZER.setRegistryName("keep_nbt_enchanting")));
    }

    @SubscribeEvent
    public void handleIMC(InterModProcessEvent e) {
        e.getIMCStream(ENCH_HARD_CAP_IMC::equals).forEach(msg -> {
            try {
                EnchantmentInstance data = (EnchantmentInstance)msg.messageSupplier().get();
                if (data != null && data.f_44947_ != null && data.f_44948_ > 0) {
                    ENCH_HARD_CAPS.put((Object)data.f_44947_, data.f_44948_);
                } else {
                    LOGGER.error("Failed to process IMC message with method {} from {} (invalid values passed).", (Object)msg.method(), (Object)msg.senderModId());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception thrown during IMC message with method {} from {}.", (Object)msg.method(), (Object)msg.senderModId());
                ex.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new ApothAnvilBlock().setRegistryName("minecraft", "anvil"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "chipped_anvil"), (Block)new ApothAnvilBlock().setRegistryName("minecraft", "damaged_anvil"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("hellshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("infused_hellshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("blazing_hellshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("glowing_hellshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("seashelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("infused_seashelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("crystal_seashelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("heart_seashelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("endshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("pearl_endshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("draconic_endshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(1.5f).m_60918_(SoundType.f_56736_)).setRegistryName("beeshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76285_).m_60978_(1.5f).m_60918_(SoundType.f_56736_)).setRegistryName("melonshelf"), (Block)new EnchLibraryBlock((BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile>)((BlockEntityType.BlockEntitySupplier)EnchLibraryTile.BasicLibraryTile::new), 16).setRegistryName("library"), (Block)new EnchLibraryBlock((BlockEntityType.BlockEntitySupplier<? extends EnchLibraryTile>)((BlockEntityType.BlockEntitySupplier)EnchLibraryTile.EnderLibraryTile::new), 31).setRegistryName("ender_library"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("rectifier"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("rectifier_t2"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("rectifier_t3"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("sightshelf"), (Block)new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1.5f).m_60918_(SoundType.f_56742_)).setRegistryName("sightshelf_t2")});
        PlaceboUtil.registerOverride((Block)new ApothEnchantBlock(), (String)"apotheosis");
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("apotheosis", "prismatic_web"), new ApothAnvilItem(Blocks.f_50322_), new ApothAnvilItem(Blocks.f_50323_), new ApothAnvilItem(Blocks.f_50324_), (Item)new TomeItem(Items.f_41852_, null).setRegistryName("other_tome"), (Item)new TomeItem(Items.f_42472_, EnchantmentCategory.ARMOR_HEAD).setRegistryName("helmet_tome"), (Item)new TomeItem(Items.f_42473_, EnchantmentCategory.ARMOR_CHEST).setRegistryName("chestplate_tome"), (Item)new TomeItem(Items.f_42474_, EnchantmentCategory.ARMOR_LEGS).setRegistryName("leggings_tome"), (Item)new TomeItem(Items.f_42475_, EnchantmentCategory.ARMOR_FEET).setRegistryName("boots_tome"), (Item)new TomeItem(Items.f_42388_, EnchantmentCategory.WEAPON).setRegistryName("weapon_tome"), (Item)new TomeItem(Items.f_42390_, EnchantmentCategory.DIGGER).setRegistryName("pickaxe_tome"), (Item)new TomeItem(Items.f_42523_, EnchantmentCategory.FISHING_ROD).setRegistryName("fishing_tome"), (Item)new TomeItem(Items.f_42411_, EnchantmentCategory.BOW).setRegistryName("bow_tome"), new ScrappingTomeItem(), (Item)new BlockItem(Apoth.Blocks.HELLSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("hellshelf"), (Item)new GlowyItem(Apoth.Blocks.INFUSED_HELLSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("infused_hellshelf"), (Item)new BlockItem(Apoth.Blocks.BLAZING_HELLSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("blazing_hellshelf"), (Item)new BlockItem(Apoth.Blocks.GLOWING_HELLSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("glowing_hellshelf"), (Item)new BlockItem(Apoth.Blocks.SEASHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("seashelf"), (Item)new GlowyItem(Apoth.Blocks.INFUSED_SEASHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("infused_seashelf"), (Item)new BlockItem(Apoth.Blocks.CRYSTAL_SEASHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("crystal_seashelf"), (Item)new BlockItem(Apoth.Blocks.HEART_SEASHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("heart_seashelf"), (Item)new BlockItem(Apoth.Blocks.ENDSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("endshelf"), (Item)new BlockItem(Apoth.Blocks.DRACONIC_ENDSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("draconic_endshelf"), (Item)new BlockItem(Apoth.Blocks.PEARL_ENDSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("pearl_endshelf"), (Item)new BlockItem(Apoth.Blocks.BEESHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("beeshelf"), (Item)new BlockItem(Apoth.Blocks.MELONSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("melonshelf"), (Item)new BlockItem((Block)Apoth.Blocks.LIBRARY, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("library"), (Item)new BlockItem(Apoth.Blocks.RECTIFIER, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("rectifier"), (Item)new BlockItem(Apoth.Blocks.RECTIFIER_T2, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("rectifier_t2"), (Item)new BlockItem(Apoth.Blocks.RECTIFIER_T3, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("rectifier_t3"), (Item)new BlockItem(Apoth.Blocks.SIGHTSHELF, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("sightshelf"), (Item)new BlockItem(Apoth.Blocks.SIGHTSHELF_T2, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("sightshelf_t2"), (Item)new Item(new Item.Properties().m_41487_(1).m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("apotheosis", "inert_trident"), (Item)new BlockItem((Block)Apoth.Blocks.ENDER_LIBRARY, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("ender_library")});
    }

    @SubscribeEvent
    public void enchants(RegistryEvent.Register<Enchantment> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{(Enchantment)new MinersFervorEnchant().setRegistryName("miners_fervor"), (Enchantment)new StableFootingEnchant().setRegistryName("stable_footing"), (Enchantment)new ScavengerEnchant().setRegistryName("scavenger"), (Enchantment)new LifeMendingEnchant().setRegistryName("life_mending"), (Enchantment)new IcyThornsEnchant().setRegistryName("icy_thorns"), (Enchantment)new TemptingEnchant().setRegistryName("tempting"), (Enchantment)new ShieldBashEnchant().setRegistryName("shield_bash"), (Enchantment)new ReflectiveEnchant().setRegistryName("reflective"), (Enchantment)new BerserkersFuryEnchant().setRegistryName("berserkers_fury"), (Enchantment)new KnowledgeEnchant().setRegistryName("knowledge"), (Enchantment)new SplittingEnchant().setRegistryName("splitting"), (Enchantment)new NaturesBlessingEnchant().setRegistryName("natures_blessing"), (Enchantment)new ReboundingEnchant().setRegistryName("rebounding"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21642_, EquipmentSlot.MAINHAND).setRegistryName("minecraft", "bane_of_arthropods"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21641_, EquipmentSlot.MAINHAND).setRegistryName("minecraft", "smite"), (Enchantment)new BaneEnchant(Enchantment.Rarity.COMMON, MobType.f_21640_, EquipmentSlot.MAINHAND).setRegistryName("minecraft", "sharpness"), (Enchantment)new BaneEnchant(Enchantment.Rarity.UNCOMMON, MobType.f_21643_, EquipmentSlot.MAINHAND).setRegistryName("bane_of_illagers"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.COMMON, ProtectionEnchantment.Type.ALL, ARMOR).setRegistryName("minecraft", "protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.FIRE, ARMOR).setRegistryName("minecraft", "fire_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.RARE, ProtectionEnchantment.Type.EXPLOSION, ARMOR).setRegistryName("minecraft", "blast_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.PROJECTILE, ARMOR).setRegistryName("minecraft", "projectile_protection"), (Enchantment)new DefenseEnchant(Enchantment.Rarity.UNCOMMON, ProtectionEnchantment.Type.FALL, EquipmentSlot.FEET).setRegistryName("minecraft", "feather_falling"), (Enchantment)new ObliterationEnchant().setRegistryName("obliteration"), (Enchantment)new CrescendoEnchant().setRegistryName("crescendo"), (Enchantment)new InertEnchantment().setRegistryName("infusion"), (Enchantment)new EndlessQuiverEnchant().setRegistryName("endless_quiver"), (Enchantment)new ChromaticEnchant().setRegistryName("chromatic"), (Enchantment)new ExploitationEnchant().setRegistryName("exploitation"), (Enchantment)new GrowthSerumEnchant().setRegistryName("growth_serum"), (Enchantment)new EarthsBoonEnchant().setRegistryName("earths_boon"), (Enchantment)new ChainsawEnchant().setRegistryName("chainsaw"), (Enchantment)new SpearfishingEnchant().setRegistryName("spearfishing")});
    }

    @SubscribeEvent
    public void sounds(RegistryEvent.Register<SoundEvent> e) {
        e.getRegistry().register((IForgeRegistryEntry)((SoundEvent)new SoundEvent(new ResourceLocation("apotheosis", "altar")).setRegistryName("apotheosis", "altar_sound")));
    }

    public static EnchantmentInfo getEnchInfo(Enchantment ench) {
        if (!Apotheosis.enableEnch) {
            return ENCHANTMENT_INFO.computeIfAbsent(ench, EnchantmentInfo::new);
        }
        EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
        if (enchInfoConfig == null) {
            return new EnchantmentInfo(ench);
        }
        if (info == null) {
            info = EnchantmentInfo.load(ench, enchInfoConfig);
            ENCHANTMENT_INFO.put(ench, info);
            if (enchInfoConfig.hasChanged()) {
                enchInfoConfig.save();
            }
            LOGGER.error("Had to late load enchantment info for {}, this is a bug in the mod {} as they are registering late!", (Object)ench.getRegistryName(), (Object)ench.getRegistryName().m_135827_());
        }
        return info;
    }

    public static int getDefaultMax(Enchantment ench) {
        int level = ench.m_6586_();
        if (level == 1) {
            return 1;
        }
        EnchantmentInfo.PowerFunc minFunc = EnchantmentInfo.defaultMin(ench);
        int max = (int)(EnchantingStatManager.getAbsoluteMaxEterna() * 4.0f);
        int minPower = minFunc.getPower(level);
        if (minPower >= max) {
            return level;
        }
        int lastPower = minPower;
        while (minPower < max) {
            if (lastPower == (minPower = minFunc.getPower(++level))) {
                return level;
            }
            if (minPower > max) {
                return level - 1;
            }
            lastPower = minPower;
        }
        return level;
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        enchInfoConfig = new Configuration(new File(Apotheosis.configDir, "enchantments.cfg"));
        enchInfoConfig.setTitle("Apotheosis Enchantment Information");
        enchInfoConfig.setComment("This file contains configurable data for each enchantment.\nThe names of each category correspond to the registry names of every loaded enchantment.");
        ENCHANTMENT_INFO.clear();
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            ENCHANTMENT_INFO.put(ench, EnchantmentInfo.load(ench, enchInfoConfig));
        }
        for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
            EnchantmentInfo info = ENCHANTMENT_INFO.get(ench);
            for (int i = 1; i <= info.getMaxLevel(); ++i) {
                if (info.getMinPower(i) <= info.getMaxPower(i)) continue;
                LOGGER.warn("Enchantment {} has min/max power {}/{} at level {}, making this level unobtainable.", (Object)ench.getRegistryName(), (Object)info.getMinPower(i), (Object)info.getMaxPower(i), (Object)i);
            }
        }
        if (e == null && enchInfoConfig.hasChanged()) {
            enchInfoConfig.save();
        }
    }
}

