/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.socket.GemManager;

public class GemLootModifier
extends LootModifier {
    protected GemLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_ITEM_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            if (!(context.m_78933_().nextFloat() <= m.chance())) break;
            float luck = context.m_78945_();
            ItemStack gem = GemManager.getRandomGemStack(context.m_78933_(), luck, (ServerLevelAccessor)context.m_78952_());
            generatedLoot.add(gem);
            break;
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<GemLootModifier> {
        public GemLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new GemLootModifier(conditions);
        }

        public JsonObject write(GemLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

