/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.loot.LootController;

public class AffixLootModifier
extends LootModifier {
    protected AffixLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_ITEM_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            if (!(context.m_78933_().nextFloat() <= m.chance())) break;
            float luck = context.m_78945_();
            ItemStack affixItem = LootController.createRandomLootItem(context.m_78933_(), null, luck, (ServerLevelAccessor)context.m_78952_());
            if (affixItem.m_41619_()) break;
            affixItem.m_41783_().m_128379_("apoth_rchest", true);
            generatedLoot.add(affixItem);
            break;
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AffixLootModifier> {
        public AffixLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            return new AffixLootModifier(conditions);
        }

        public JsonObject write(AffixLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

