/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.loot.AffixLootEntry;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.DimWeightedJsonReloadListener;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.SerializerBuilder;

public class AffixLootManager
extends DimWeightedJsonReloadListener<AffixLootEntry> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)ItemAdapter.INSTANCE).registerTypeAdapter(CompoundTag.class, (Object)NBTAdapter.INSTANCE).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(LootRarity.class, (Object)new LootRarity.Serializer()).setPrettyPrinting().create();
    public static final AffixLootManager INSTANCE = new AffixLootManager();

    private AffixLootManager() {
        super(AdventureModule.LOGGER, "affix_loot_entries", false, false);
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, new SerializerBuilder("Affix Loot Entry").json(obj -> (AffixLootEntry)GSON.fromJson((JsonElement)obj, AffixLootEntry.class), e -> GSON.toJsonTree(e).getAsJsonObject()));
    }

    protected void validateItem(AffixLootEntry item) {
        super.validateItem((PlaceboJsonReloadListener.TypeKeyed)item);
        Preconditions.checkArgument((!item.stack.m_41619_() ? 1 : 0) != 0);
        Preconditions.checkArgument((item.type != null ? 1 : 0) != 0);
        Preconditions.checkArgument((item.type != LootCategory.NONE ? 1 : 0) != 0);
    }
}

