/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.reforging.ReforgingScreen;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTileRenderer;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingScreen;
import shadows.apotheosis.adventure.affix.socket.GemItem;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.client.BossSpawnMessage;
import shadows.apotheosis.adventure.client.SocketTooltipRenderer;
import shadows.apotheosis.adventure.client.from_mantle.ColoredBlockModel;
import shadows.apotheosis.adventure.client.from_mantle.ColoredItemModel;
import shadows.apotheosis.util.ItemAccess;

public class AdventureModuleClient {
    public static List<BossSpawnMessage.BossSpawnData> BOSS_SPAWNS = new ArrayList<BossSpawnMessage.BossSpawnData>();

    public static void init() {
        MinecraftForge.EVENT_BUS.register(AdventureModuleClient.class);
        MinecraftForgeClient.registerTooltipComponentFactory(SocketTooltipRenderer.SocketComponent.class, SocketTooltipRenderer::new);
        ItemProperties.register((Item)Apoth.Items.GEM, (ResourceLocation)new ResourceLocation("apotheosis", "gem_variant"), (stack, level, entity, seed) -> GemItem.getVariant(stack));
        ItemBlockRenderTypes.setRenderLayer((Block)Apoth.Blocks.BOSS_SPAWNER, (RenderType)RenderType.m_110463_());
        MenuScreens.m_96206_(Apoth.Menus.REFORGING, ReforgingScreen::new);
        MenuScreens.m_96206_(Apoth.Menus.SALVAGE, SalvagingScreen::new);
        BlockEntityRenderers.m_173590_(Apoth.Tiles.REFORGING_TABLE, k -> new ReforgingTableTileRenderer());
        ItemBlockRenderTypes.setRenderLayer((Block)Apoth.Blocks.REFORGING_TABLE, (RenderType)RenderType.m_110463_());
    }

    public static void onBossSpawn(BlockPos pos, float[] color) {
        BOSS_SPAWNS.add(new BossSpawnMessage.BossSpawnData(pos, color, new MutableInt()));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_11860_, SoundSource.HOSTILE, AdventureConfig.bossAnnounceVolume, 1.25f, Minecraft.m_91087_().f_91074_.m_142538_()));
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent e) {
        if (e.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        PoseStack stack = e.getPoseStack();
        MultiBufferSource.BufferSource buf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            stack.m_85836_();
            float partials = e.getPartialTick();
            Vec3 vec = Minecraft.m_91087_().m_91288_().m_20299_(partials);
            stack.m_85837_(-vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            stack.m_85837_((double)data.pos().m_123341_(), (double)data.pos().m_123342_(), (double)data.pos().m_123343_());
            BeaconRenderer.m_112184_((PoseStack)stack, (MultiBufferSource)buf, (ResourceLocation)BeaconRenderer.f_112102_, (float)partials, (float)1.0f, (long)p.f_19853_.m_46467_(), (int)0, (int)64, (float[])data.color(), (float)0.166f, (float)0.33f);
            stack.m_85849_();
        }
        buf.m_109911_();
    }

    @SubscribeEvent
    public static void time(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        for (int i = 0; i < BOSS_SPAWNS.size(); ++i) {
            BossSpawnMessage.BossSpawnData data = BOSS_SPAWNS.get(i);
            if (data.ticks().getAndIncrement() <= 400) continue;
            BOSS_SPAWNS.remove(i--);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void tooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        List list = e.getToolTip();
        int rmvIdx = -1;
        int rmvIdx2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            Object e2 = list.get(i);
            if (!(e2 instanceof TextComponent)) continue;
            TextComponent tc = (TextComponent)e2;
            if (tc.m_131292_().equals("APOTH_REMOVE_MARKER")) {
                rmvIdx = i;
            }
            if (!tc.m_131292_().equals("APOTH_REMOVE_MARKER_2")) continue;
            rmvIdx2 = i;
            break;
        }
        if (rmvIdx == -1 || rmvIdx2 == -1) {
            return;
        }
        list.removeAll(list.subList(rmvIdx, rmvIdx2 + 1));
        int flags = AdventureModuleClient.getHideFlags(stack);
        int fRmvIdx = rmvIdx;
        int oldSize = list.size();
        if (AdventureModuleClient.shouldShowInTooltip(flags, ItemStack.TooltipPart.MODIFIERS)) {
            AdventureModuleClient.applyModifierTooltips(e.getPlayer(), stack, c -> list.add(Math.min(fRmvIdx, list.size()), c));
            Collections.reverse(list.subList(rmvIdx, Math.min(list.size(), rmvIdx + list.size() - oldSize)));
        }
        if (AffixHelper.getAffixes(stack).containsKey(Apoth.Affixes.SOCKET)) {
            list.add(Math.min(list.size(), rmvIdx + list.size() - oldSize), new TextComponent("APOTH_REMOVE_MARKER"));
        }
    }

    @SubscribeEvent
    public static void comps(RenderTooltipEvent.GatherComponents e) {
        AffixInstance socket = AffixHelper.getAffixes(e.getItemStack()).get(Apoth.Affixes.SOCKET);
        if (socket == null) {
            return;
        }
        List list = e.getTooltipElements();
        int rmvIdx = -1;
        for (int i = 0; i < list.size(); ++i) {
            TextComponent tc;
            Object t;
            Optional o = ((Either)list.get(i)).left();
            if (!o.isPresent() || !((t = o.get()) instanceof TextComponent) || !(tc = (TextComponent)t).m_131292_().equals("APOTH_REMOVE_MARKER")) continue;
            rmvIdx = i;
            list.remove(i);
            break;
        }
        if (rmvIdx == -1) {
            return;
        }
        int size = (int)socket.level();
        e.getTooltipElements().add(rmvIdx, Either.right((Object)new SocketTooltipRenderer.SocketComponent(SocketHelper.getGems(e.getItemStack(), size))));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void affixTooltips(ItemTooltipEvent e) {
        ItemStack stack = e.getItemStack();
        if (stack.m_41782_()) {
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
            ArrayList components = new ArrayList();
            affixes.values().stream().sorted(Comparator.comparingInt(a -> a.affix().getType().ordinal())).forEach(inst -> inst.addInformation(components::add));
            e.getToolTip().addAll(1, components);
        }
    }

    public static Multimap<Attribute, AttributeModifier> sortedMap() {
        return TreeMultimap.create((k1, k2) -> k1.getRegistryName().compareTo(k2.getRegistryName()), (v1, v2) -> {
            int compOp = Integer.compare(v1.m_22217_().ordinal(), v2.m_22217_().ordinal());
            int compValue = Double.compare(v2.m_22218_(), v1.m_22218_());
            return compOp == 0 ? (compValue == 0 ? v1.m_22209_().compareTo(v2.m_22209_()) : compValue) : compOp;
        });
    }

    public static Multimap<Attribute, AttributeModifier> getSortedModifiers(ItemStack stack, EquipmentSlot slot) {
        Multimap unsorted = stack.m_41638_(slot);
        Multimap<Attribute, AttributeModifier> map = AdventureModuleClient.sortedMap();
        for (Map.Entry ent : unsorted.entries()) {
            if (ent.getKey() != null && ent.getValue() != null) {
                map.put((Object)((Attribute)ent.getKey()), (Object)((AttributeModifier)ent.getValue()));
                continue;
            }
            AdventureModule.LOGGER.debug("Detected broken attribute modifier entry on item {}.  Attr={}, Modif={}", (Object)stack, ent.getKey(), ent.getValue());
        }
        return map;
    }

    private static boolean shouldShowInTooltip(int pHideFlags, ItemStack.TooltipPart pPart) {
        return (pHideFlags & pPart.m_41809_()) == 0;
    }

    private static int getHideFlags(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_("HideFlags", 99) ? stack.m_41783_().m_128451_("HideFlags") : stack.m_41720_().getDefaultTooltipHideFlags(stack);
    }

    private static void applyModifierTooltips(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip) {
        Multimap<Attribute, AttributeModifier> mainhand = AdventureModuleClient.getSortedModifiers(stack, EquipmentSlot.MAINHAND);
        Multimap<Attribute, AttributeModifier> offhand = AdventureModuleClient.getSortedModifiers(stack, EquipmentSlot.OFFHAND);
        Multimap<Attribute, AttributeModifier> dualHand = AdventureModuleClient.sortedMap();
        for (Attribute atr : mainhand.keys()) {
            Collection modifMh = mainhand.get((Object)atr);
            Collection modifOh = offhand.get((Object)atr);
            modifMh.stream().filter(a1 -> modifOh.stream().anyMatch(a2 -> a1.m_22214_().equals(a2.m_22214_()))).forEach(modif -> dualHand.put((Object)atr, modif));
        }
        dualHand.values().forEach(m -> {
            mainhand.values().remove(m);
            offhand.values().removeIf(m1 -> m1.m_22214_().equals(m.m_22214_()));
        });
        int sockets = SocketHelper.getSockets(stack);
        HashSet<UUID> skips = new HashSet<UUID>();
        if (sockets > 0) {
            for (ItemStack gem : SocketHelper.getGems(stack, sockets)) {
                Pair<Attribute, AttributeModifier> modif2 = GemItem.getStoredBonus(gem);
                if (modif2 == null) continue;
                skips.add(((AttributeModifier)modif2.getValue()).m_22209_());
            }
        }
        AdventureModuleClient.applyTextFor(player, stack, tooltip, dualHand, "both_hands", skips);
        AdventureModuleClient.applyTextFor(player, stack, tooltip, mainhand, EquipmentSlot.MAINHAND.m_20751_(), skips);
        AdventureModuleClient.applyTextFor(player, stack, tooltip, offhand, EquipmentSlot.OFFHAND.m_20751_(), skips);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.ordinal() < 2) continue;
            Multimap<Attribute, AttributeModifier> modifiers = AdventureModuleClient.getSortedModifiers(stack, slot);
            AdventureModuleClient.applyTextFor(player, stack, tooltip, modifiers, slot.m_20751_(), skips);
        }
    }

    private static MutableComponent padded(String padding, Component comp) {
        return new TextComponent(padding).m_7220_(comp);
    }

    private static MutableComponent list() {
        return new TextComponent(" \u2507 ").m_130940_(ChatFormatting.GRAY);
    }

    /*
     * WARNING - void declaration
     */
    private static void applyTextFor(@Nullable Player player, ItemStack stack, Consumer<Component> tooltip, Multimap<Attribute, AttributeModifier> modifierMap, String group, Set<UUID> skips) {
        if (!modifierMap.isEmpty()) {
            TranslatableComponent text;
            double amt;
            double rawBase;
            modifierMap.values().removeIf(m -> skips.contains(m.m_22209_()));
            tooltip.accept(TextComponent.f_131282_);
            tooltip.accept((Component)new TranslatableComponent("item.modifiers." + group).m_130940_(ChatFormatting.GRAY));
            if (modifierMap.isEmpty()) {
                return;
            }
            AttributeModifier baseAD = null;
            AttributeModifier baseAS = null;
            ArrayList<AttributeModifier> dmgModifs = new ArrayList<AttributeModifier>();
            ArrayList<AttributeModifier> spdModifs = new ArrayList<AttributeModifier>();
            for (AttributeModifier modif2 : modifierMap.get((Object)Attributes.f_22281_)) {
                if (modif2.m_22209_() == ItemAccess.getBaseAD()) {
                    baseAD = modif2;
                    continue;
                }
                dmgModifs.add(modif2);
            }
            for (AttributeModifier modif2 : modifierMap.get((Object)Attributes.f_22283_)) {
                if (modif2.m_22209_() == ItemAccess.getBaseAS()) {
                    baseAS = modif2;
                    continue;
                }
                spdModifs.add(modif2);
            }
            if (baseAD != null) {
                double base;
                rawBase = base = baseAD.m_22218_() + (player == null ? 0.0 : player.m_21172_(Attributes.f_22281_));
                amt = base;
                for (AttributeModifier attributeModifier : dmgModifs) {
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        base = amt += attributeModifier.m_22218_();
                        continue;
                    }
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                        amt += attributeModifier.m_22218_() * base;
                        continue;
                    }
                    amt *= 1.0 + attributeModifier.m_22218_();
                }
                text = new TranslatableComponent("attribute.modifier.equals.0", new Object[]{ItemStack.f_41584_.format(amt += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_)), new TranslatableComponent(Attributes.f_22281_.m_22087_())});
                tooltip.accept((Component)AdventureModuleClient.padded(" ", (Component)text).m_130940_(dmgModifs.isEmpty() ? ChatFormatting.DARK_GREEN : ChatFormatting.GOLD));
                if (Screen.m_96638_() && !dmgModifs.isEmpty()) {
                    text = new TranslatableComponent("attribute.modifier.equals.0", new Object[]{ItemStack.f_41584_.format(rawBase), new TranslatableComponent(Attributes.f_22281_.m_22087_())});
                    tooltip.accept((Component)AdventureModuleClient.list().m_7220_((Component)text.m_130940_(ChatFormatting.DARK_GREEN)));
                    for (AttributeModifier modifier : dmgModifs) {
                        tooltip.accept((Component)AdventureModuleClient.list().m_7220_(GemItem.toComponent(Attributes.f_22281_, modifier)));
                    }
                    float f = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                    if (f > 0.0f) {
                        tooltip.accept((Component)AdventureModuleClient.list().m_7220_((Component)new TranslatableComponent("attribute.modifier.plus.0", new Object[]{ItemStack.f_41584_.format(f), new TranslatableComponent(Attributes.f_22281_.m_22087_())}).m_130940_(ChatFormatting.BLUE)));
                    }
                }
            }
            if (baseAS != null) {
                double base;
                rawBase = base = baseAS.m_22218_() + (player == null ? 0.0 : player.m_21172_(Attributes.f_22283_));
                amt = base;
                for (AttributeModifier attributeModifier : spdModifs) {
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.ADDITION) {
                        base = amt += attributeModifier.m_22218_();
                        continue;
                    }
                    if (attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE) {
                        amt += attributeModifier.m_22218_() * base;
                        continue;
                    }
                    amt *= 1.0 + attributeModifier.m_22218_();
                }
                text = new TranslatableComponent("attribute.modifier.equals.0", new Object[]{ItemStack.f_41584_.format(amt), new TranslatableComponent(Attributes.f_22283_.m_22087_())});
                tooltip.accept((Component)new TextComponent(" ").m_7220_((Component)text).m_130940_(spdModifs.isEmpty() ? ChatFormatting.DARK_GREEN : ChatFormatting.GOLD));
                if (Screen.m_96638_() && !spdModifs.isEmpty()) {
                    text = new TranslatableComponent("attribute.modifier.equals.0", new Object[]{ItemStack.f_41584_.format(rawBase), new TranslatableComponent(Attributes.f_22283_.m_22087_())});
                    tooltip.accept((Component)AdventureModuleClient.list().m_7220_((Component)text.m_130940_(ChatFormatting.DARK_GREEN)));
                    for (AttributeModifier modifier : spdModifs) {
                        tooltip.accept((Component)AdventureModuleClient.list().m_7220_(GemItem.toComponent(Attributes.f_22283_, modifier)));
                    }
                }
            }
            for (Attribute attr : modifierMap.keySet()) {
                if (baseAD != null && attr == Attributes.f_22281_ || baseAS != null && attr == Attributes.f_22283_) continue;
                Collection modifs = modifierMap.get((Object)attr);
                if (modifs.size() > 1) {
                    double[] sums = new double[3];
                    boolean[] merged = new boolean[3];
                    HashMap<AttributeModifier.Operation, List> shiftExpands = new HashMap<AttributeModifier.Operation, List>();
                    for (AttributeModifier attributeModifier : modifs) {
                        if (attributeModifier.m_22218_() == 0.0) continue;
                        if (sums[attributeModifier.m_22217_().ordinal()] != 0.0) {
                            merged[attributeModifier.m_22217_().ordinal()] = true;
                        }
                        int n = attributeModifier.m_22217_().ordinal();
                        sums[n] = sums[n] + attributeModifier.m_22218_();
                        shiftExpands.computeIfAbsent(attributeModifier.m_22217_(), k -> new LinkedList()).add(attributeModifier);
                    }
                    for (int i = 0; i < 3; ++i) {
                        void var17_29;
                        Style style;
                        if (sums[i] == 0.0) continue;
                        String string = "attribute.modifier." + (sums[i] < 0.0 ? "take." : "plus.") + i;
                        if (i != 0) {
                            String string2 = "attribute.modifier.apotheosis" + (sums[i] < 0.0 ? "take." : "plus.") + i;
                        }
                        if (merged[i]) {
                            style = sums[i] < 0.0 ? Style.f_131099_.m_131148_(TextColor.m_131266_((int)16331057)) : Style.f_131099_.m_131148_(TextColor.m_131266_((int)8026873));
                        } else {
                            Style style2 = style = sums[i] < 0.0 ? Style.f_131099_.m_131140_(ChatFormatting.RED) : Style.f_131099_.m_131140_(ChatFormatting.BLUE);
                        }
                        if (sums[i] < 0.0) {
                            int n = i;
                            sums[n] = sums[n] * -1.0;
                        }
                        if (attr == Attributes.f_22278_) {
                            int n = i;
                            sums[n] = sums[n] * 10.0;
                        }
                        tooltip.accept((Component)new TranslatableComponent((String)var17_29, new Object[]{ItemStack.f_41584_.format(sums[i]), new TranslatableComponent(attr.m_22087_())}).m_130948_(style));
                        if (!merged[i] || !Screen.m_96638_()) continue;
                        ((List)shiftExpands.get(AttributeModifier.Operation.m_22236_((int)i))).forEach(modif -> tooltip.accept((Component)AdventureModuleClient.list().m_7220_(GemItem.toComponent(attr, modif))));
                    }
                    continue;
                }
                modifs.forEach(m -> {
                    if (m.m_22218_() != 0.0) {
                        tooltip.accept(GemItem.toComponent(attr, m));
                    }
                });
            }
        }
    }

    static final RenderType beaconBeam(ResourceLocation tex, boolean color) {
        return CustomBeacon.BEACON_BEAM.apply(tex, color);
    }

    public static void renderBeaconBeam(PoseStack pPoseStack, MultiBufferSource pBufferSource, ResourceLocation pBeamLocation, float pPartialTick, float pTextureScale, long pGameTime, int pYOffset, int pHeight, float[] pColors, float pBeamRadius, float pGlowRadius) {
        int i = pYOffset + pHeight;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.0, 0.5);
        float f = (float)Math.floorMod(pGameTime, 40) + pPartialTick;
        float f1 = pHeight < 0 ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        float f3 = pColors[0];
        float f4 = pColors[1];
        float f5 = pColors[2];
        pPoseStack.m_85836_();
        pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f * 2.25f - 45.0f));
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = -pBeamRadius;
        float f12 = -pBeamRadius;
        float f15 = -1.0f + f2;
        float f16 = (float)pHeight * pTextureScale * (0.5f / pBeamRadius) + f15;
        BeaconRenderer.m_112155_((PoseStack)pPoseStack, (VertexConsumer)pBufferSource.m_6299_(AdventureModuleClient.beaconBeam(pBeamLocation, false)), (float)f3, (float)f4, (float)f5, (float)1.0f, (int)pYOffset, (int)i, (float)0.0f, (float)pBeamRadius, (float)pBeamRadius, (float)0.0f, (float)f9, (float)0.0f, (float)0.0f, (float)f12, (float)0.0f, (float)1.0f, (float)f16, (float)f15);
        pPoseStack.m_85849_();
        f6 = -pGlowRadius;
        float f7 = -pGlowRadius;
        f8 = -pGlowRadius;
        f9 = -pGlowRadius;
        f15 = -1.0f + f2;
        f16 = (float)pHeight * pTextureScale + f15;
        BeaconRenderer.m_112155_((PoseStack)pPoseStack, (VertexConsumer)pBufferSource.m_6299_(AdventureModuleClient.beaconBeam(pBeamLocation, true)), (float)f3, (float)f4, (float)f5, (float)0.125f, (int)pYOffset, (int)i, (float)f6, (float)f7, (float)pGlowRadius, (float)f8, (float)f9, (float)pGlowRadius, (float)pGlowRadius, (float)pGlowRadius, (float)0.0f, (float)1.0f, (float)f16, (float)f15);
        pPoseStack.m_85849_();
    }

    private static abstract class CustomBeacon
    extends RenderStateShard {
        static final BiFunction<ResourceLocation, Boolean, RenderType> BEACON_BEAM = Util.m_143821_((p_173224_, p_173225_) -> {
            RenderType.CompositeState rendertype$compositestate = RenderType.CompositeState.m_110628_().m_173292_(f_173068_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173224_, false, false)).m_110685_(p_173225_ != false ? f_110139_ : f_110134_).m_110687_(p_173225_ != false ? f_110115_ : f_110115_).m_110663_(f_110111_).m_110661_(f_110110_).m_110691_(false);
            return RenderType.m_173215_((String)"custom_beacon_beam", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)rendertype$compositestate);
        });

        public CustomBeacon(String pName, Runnable pSetupState, Runnable pClearState) {
            super(pName, pSetupState, pClearState);
        }
    }

    @Mod.EventBusSubscriber(modid="apotheosis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModelSubscriber {
        @SubscribeEvent
        public static void models(ModelRegistryEvent e) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)new ResourceLocation("apotheosis", "item/hammer"));
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("apotheosis", "lit"), (IModelLoader)ColoredBlockModel.LOADER);
            ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("apotheosis", "lit_item"), (IModelLoader)ColoredItemModel.LOADER);
        }
    }
}

