/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossStats;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootController;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.ench.asm.EnchHooks;
import shadows.apotheosis.util.ChancedEffectInstance;
import shadows.apotheosis.util.GearSet;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.json.DimWeightedJsonReloadListener;
import shadows.placebo.json.PlaceboJsonReloadListener;
import shadows.placebo.json.RandomAttributeModifier;

public final class BossItem
extends PlaceboJsonReloadListener.TypeKeyedBase<BossItem>
implements DimWeightedJsonReloadListener.IDimWeighted,
LootRarity.Clamped {
    public static final Predicate<Goal> IS_VILLAGER_ATTACK = a -> a instanceof NearestAttackableTargetGoal && ((NearestAttackableTargetGoal)a).f_26048_ == Villager.class;
    protected int weight;
    protected float quality;
    protected EntityType<?> entity;
    protected AABB size;
    protected Map<LootRarity, BossStats> stats;
    @SerializedName(value="valid_gear_sets")
    protected List<GearSet.SetPredicate> armorSets;
    @SerializedName(value="nbt")
    protected CompoundTag customNbt;
    protected Set<ResourceLocation> dimensions;
    @SerializedName(value="min_rarity")
    protected LootRarity minRarity;
    @SerializedName(value="max_rarity")
    protected LootRarity maxRarity;

    public int getWeight() {
        return this.weight;
    }

    public float getQuality() {
        return this.quality;
    }

    @Override
    public LootRarity getMinRarity() {
        return this.minRarity;
    }

    @Override
    public LootRarity getMaxRarity() {
        return this.maxRarity;
    }

    public AABB getSize() {
        return this.size;
    }

    public EntityType<?> getEntity() {
        return this.entity;
    }

    public Mob createBoss(ServerLevelAccessor world, BlockPos pos, Random rand, float luck) {
        Mob entity = (Mob)this.entity.m_20615_((Level)world.m_6018_());
        if (this.customNbt != null) {
            entity.m_20258_(this.customNbt);
        }
        this.initBoss(rand, entity, luck);
        if (this.customNbt != null) {
            entity.m_7378_(this.customNbt);
        }
        entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        return entity;
    }

    public void initBoss(Random rand, Mob entity, float luck) {
        LootRarity rarity = LootRarity.random(rand, luck, this);
        BossStats stats = this.stats.get(rarity);
        int duration = entity instanceof Creeper ? 6000 : Integer.MAX_VALUE;
        for (ChancedEffectInstance inst : stats.effects) {
            if (!(rand.nextFloat() <= inst.getChance())) continue;
            entity.m_7292_(inst.createInstance(rand, duration));
        }
        for (RandomAttributeModifier modif : stats.modifiers) {
            modif.apply(rand, (LivingEntity)entity);
        }
        entity.f_21345_.f_25345_.removeIf(IS_VILLAGER_ATTACK);
        String name = NameHelper.setEntityName(rand, entity);
        GearSet set = BossArmorManager.INSTANCE.getRandomSet(rand, luck, this.armorSets);
        set.apply((LivingEntity)entity);
        boolean anyValid = false;
        for (EquipmentSlot t : EquipmentSlot.values()) {
            ItemStack s = entity.m_6844_(t);
            if (s.m_41619_() || LootCategory.forItem(s) == LootCategory.NONE) continue;
            anyValid = true;
            break;
        }
        if (!anyValid) {
            throw new RuntimeException("Attempted to apply boss gear set " + set.getId() + " but it had no valid affix loot items generated.");
        }
        int guaranteed = rand.nextInt(6);
        ItemStack temp = entity.m_6844_(EquipmentSlot.values()[guaranteed]);
        while (temp.m_41619_() || LootCategory.forItem(temp) == LootCategory.NONE) {
            guaranteed = rand.nextInt(6);
            temp = entity.m_6844_(EquipmentSlot.values()[guaranteed]);
        }
        for (EquipmentSlot s : EquipmentSlot.values()) {
            ItemStack stack = entity.m_6844_(s);
            if (s.ordinal() == guaranteed) {
                entity.m_21409_(s, 2.0f);
            } else {
                entity.m_21409_(s, 0.03f);
            }
            if (s.ordinal() == guaranteed) {
                entity.m_8061_(s, this.modifyBossItem(stack, rand, name, luck, rarity));
                entity.m_6593_((Component)((MutableComponent)entity.m_7770_()).m_130948_(Style.f_131099_.m_131148_(rarity.color())));
                continue;
            }
            if (!(rand.nextFloat() < stats.enchantChance)) continue;
            List ench = EnchantmentHelper.m_44909_((Random)rand, (ItemStack)stack, (int)(Apotheosis.enableEnch ? stats.enchLevels[0] : stats.enchLevels[1]), (boolean)true);
            EnchantmentHelper.m_44865_((Map)ench.stream().filter(d -> !d.f_44947_.m_6589_()).collect(Collectors.toMap(d -> d.f_44947_, d -> d.f_44948_, Math::max, HashMap::new)), (ItemStack)stack);
            entity.m_8061_(s, stack);
        }
        entity.getPersistentData().m_128379_("apoth.boss", true);
        entity.getPersistentData().m_128359_("apoth.rarity", rarity.id());
        entity.m_21153_(entity.m_21233_());
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 2400));
    }

    public ItemStack modifyBossItem(ItemStack stack, Random random, String bossName, float luck, LootRarity rarity) {
        BossStats stats = this.stats.get(rarity);
        List ench = EnchantmentHelper.m_44909_((Random)random, (ItemStack)stack, (int)(Apotheosis.enableEnch ? stats.enchLevels[2] : stats.enchLevels[3]), (boolean)true);
        EnchantmentHelper.m_44865_(ench.stream().filter(d -> !d.f_44947_.m_6589_()).collect(Collectors.toMap(d -> d.f_44947_, d -> d.f_44948_, Math::max)), (ItemStack)stack);
        NameHelper.setItemName(random, stack);
        stack = LootController.createLootItem(stack, LootCategory.forItem(stack), rarity, random);
        String bossOwnerName = String.format(NameHelper.ownershipFormat, bossName) + " ";
        Component name = AffixHelper.getName(stack);
        if (name instanceof TranslatableComponent) {
            TranslatableComponent tc = (TranslatableComponent)name;
            MutableComponent copy = new TranslatableComponent(bossOwnerName + tc.m_131328_(), tc.m_131329_()).m_130948_(tc.m_7383_());
            AffixHelper.setName(stack, (Component)copy);
        }
        HashMap<Enchantment, Integer> enchMap = new HashMap<Enchantment, Integer>();
        for (Map.Entry e2 : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            if (e2.getKey() == null) continue;
            enchMap.put((Enchantment)e2.getKey(), Math.min(EnchHooks.getMaxLevel((Enchantment)e2.getKey()), (Integer)e2.getValue() + random.nextInt(2)));
        }
        if (AdventureConfig.curseBossItems) {
            ItemStack stk = stack;
            List curses = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(e -> e.canApplyAtEnchantingTable(stk) && e.m_6589_()).collect(Collectors.toList());
            if (!curses.isEmpty()) {
                Enchantment curse = (Enchantment)curses.get(random.nextInt(curses.size()));
                enchMap.put(curse, Mth.m_14072_((Random)random, (int)1, (int)EnchHooks.getMaxLevel(curse)));
            }
        }
        EnchantmentHelper.m_44865_(enchMap, (ItemStack)stack);
        stack.m_41783_().m_128379_("apoth_boss", true);
        return stack;
    }

    public BossItem validate() {
        Preconditions.checkArgument((this.weight >= 0 ? 1 : 0) != 0, (Object)("Boss Item " + this.id + " has a negative weight!"));
        Preconditions.checkArgument((this.quality >= 0.0f ? 1 : 0) != 0, (Object)("Boss Item " + this.id + " has a negative quality!"));
        Preconditions.checkNotNull(this.entity, (Object)("Boss Item " + this.id + " has null entity type!"));
        Preconditions.checkNotNull((Object)this.size, (Object)("Boss Item " + this.id + " has no size!"));
        if (this.minRarity != null) {
            Preconditions.checkArgument((this.maxRarity == null || this.maxRarity.isAtLeast(this.minRarity) ? 1 : 0) != 0);
        }
        if (this.maxRarity != null) {
            Preconditions.checkArgument((this.minRarity == null || this.maxRarity.isAtLeast(this.minRarity) ? 1 : 0) != 0);
        }
        LootRarity r = LootRarity.COMMON.max(this.minRarity);
        while (r != LootRarity.ANCIENT) {
            Preconditions.checkNotNull((Object)this.stats.get(r));
            if (r == this.maxRarity) break;
            r = LootRarity.LIST.get(r.ordinal() + 1);
        }
        return this;
    }

    public Set<ResourceLocation> getDimensions() {
        return this.dimensions;
    }
}

