/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.boss;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.server.ServerLifecycleHooks;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.boss.BossItem;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.boss.BossSpawnerBlock;

public class BossDungeonFeature2
extends Feature<NoneFeatureConfiguration> {
    public static final ResourceLocation TEMPLATE_ID = new ResourceLocation("apotheosis", "boss_1");
    public static final BossDungeonFeature2 INSTANCE = new BossDungeonFeature2();
    protected static int xRadius = 4;
    protected static int floor = -1;
    protected static int roof = 3;
    protected static int roofTop = 6;
    protected static int zRadius = 4;

    public BossDungeonFeature2() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        if (!AdventureConfig.canGenerateIn(world)) {
            return false;
        }
        BlockPos pos = ctx.m_159777_();
        Random rand = ctx.m_159776_();
        BlockState[][][] states = new BlockState[9][8][9];
        int doors = 0;
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int y = floor; y <= roofTop; ++y) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    BlockPos blockpos = pos.m_142082_(x, y, z);
                    BlockState state = world.m_8055_(blockpos);
                    Material material = state.m_60767_();
                    boolean flag = material.m_76333_();
                    if (y == floor && !flag || y == roof && !flag) {
                        return false;
                    }
                    if (y == roof + 1 && Math.abs(x) < xRadius && Math.abs(z) < zRadius && !flag) {
                        return false;
                    }
                    if (BossDungeonFeature2.isDoorSpace(x, z) && y == 1 && state.m_60795_() && states[x + xRadius][y - 1 + 1][z + zRadius].m_60795_()) {
                        ++doors;
                    }
                    states[x + BossDungeonFeature2.xRadius][y + 1][z + BossDungeonFeature2.zRadius] = state;
                }
            }
        }
        if (doors >= 3) {
            StructureTemplate template = (StructureTemplate)ServerLifecycleHooks.getCurrentServer().m_129909_().m_163774_(TEMPLATE_ID).get();
            template.m_74536_((ServerLevelAccessor)world, pos.m_142082_(-4, -1, -4), pos.m_142082_(-4, -1, -4), new StructurePlaceSettings(), rand, 4);
            boolean rand1 = rand.nextBoolean();
            boolean rand2 = rand.nextBoolean();
            BlockPos chest1 = pos.m_142082_(rand1 ? xRadius - 1 : -xRadius + 1, 0, rand2 ? zRadius - 1 : -zRadius + 1);
            BlockPos chest2 = pos.m_142082_(!rand1 ? xRadius - 1 : -xRadius + 1, 0, !rand2 ? zRadius - 1 : -zRadius + 1);
            world.m_7731_(chest1, StructurePiece.m_73407_((BlockGetter)world, (BlockPos)chest1, (BlockState)Blocks.f_50087_.m_49966_()), 2);
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)rand, (BlockPos)chest1, (ResourceLocation)BuiltInLootTables.f_78742_);
            world.m_7731_(chest2, StructurePiece.m_73407_((BlockGetter)world, (BlockPos)chest2, (BlockState)Blocks.f_50087_.m_49966_()), 2);
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)rand, (BlockPos)chest2, (ResourceLocation)BuiltInLootTables.f_78742_);
            world.m_7731_(pos, Apoth.Blocks.BOSS_SPAWNER.m_49966_(), 2);
            BlockEntity tileentity = world.m_7702_(pos);
            if (tileentity instanceof BossSpawnerBlock.BossSpawnerTile) {
                ((BossSpawnerBlock.BossSpawnerTile)tileentity).setBossItem((BossItem)BossItemManager.INSTANCE.getRandomItem(rand, (ServerLevelAccessor)world));
            } else {
                AdventureModule.LOGGER.error("Failed to fetch boss spawner entity at ({}, {}, {})", (Object)pos.m_123341_(), (Object)pos.m_123342_(), (Object)pos.m_123343_());
            }
            AdventureModule.debugLog(pos, "Boss Dungeon (Variant 2)");
            return true;
        }
        return false;
    }

    static boolean isDoorSpace(int x, int z) {
        return Math.abs(z) == zRadius && x >= -1 && x <= 1 || Math.abs(x) == xRadius && z >= -1 && z <= 1;
    }
}

