/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;

public class SocketHelper {
    public static final String GEMS = "gems";

    public static List<ItemStack> getGems(ItemStack stack) {
        return SocketHelper.getGems(stack, SocketHelper.getSockets(stack));
    }

    public static List<ItemStack> getGems(ItemStack stack, int size) {
        NonNullList gems = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        if (size == 0) {
            return gems;
        }
        int i = 0;
        CompoundTag afxData = stack.m_41737_("affix_data");
        if (afxData != null && afxData.m_128441_(GEMS)) {
            ListTag gemData = afxData.m_128437_(GEMS, 10);
            for (Tag tag : gemData) {
                gems.set(i++, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag)));
                if (i < size) continue;
                break;
            }
        }
        return gems;
    }

    public static void setGems(ItemStack stack, List<ItemStack> gems) {
        CompoundTag afxData = stack.m_41698_("affix_data");
        ListTag gemData = new ListTag();
        for (ItemStack s : gems) {
            gemData.add((Object)s.m_41739_(new CompoundTag()));
        }
        afxData.m_128365_(GEMS, (Tag)gemData);
    }

    public static int getSockets(ItemStack stack) {
        AffixInstance inst = AffixHelper.getAffixes(stack).get(Apoth.Affixes.SOCKET);
        if (inst == null) {
            return 0;
        }
        return (int)inst.level();
    }

    public static int getEmptySockets(ItemStack stack) {
        return (int)SocketHelper.getGems(stack).stream().filter(ItemStack::m_41619_).count();
    }
}

