/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.effect.CleavingAffix;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class ThunderstruckAffix
extends Affix {
    protected static final StepFunction LEVEL_FUNC = AffixHelper.step(2.0f, 6, 1.0f);

    public ThunderstruckAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{(int)ThunderstruckAffix.getTrueLevel(rarity, level)}).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack).isLightWeapon() && rarity.isAtLeast(LootRarity.RARE);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if (user.f_19853_.f_46443_) {
            return;
        }
        if ((double)Apotheosis.localAtkStrength >= 0.98) {
            List nearby = target.f_19853_.m_6249_(target, new AABB(target.m_142538_()).m_82400_(6.0), CleavingAffix.cleavePredicate((Entity)user, target));
            for (Entity e : nearby) {
                e.m_6469_(DamageSource.f_19306_, ThunderstruckAffix.getTrueLevel(rarity, level));
            }
        }
    }

    private static float getTrueLevel(LootRarity rarity, float level) {
        return (rarity.ordinal() - LootRarity.RARE.ordinal()) * 2 + LEVEL_FUNC.getInt(level);
    }
}

