/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

public class TelepathicAffix
extends Affix {
    public static Vec3 blockDropTargetPos = null;

    public TelepathicAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat == LootCategory.NONE) {
            return false;
        }
        return (cat.isRanged() || cat.isLightWeapon() || cat == LootCategory.BREAKER) && rarity.isAtLeast(LootRarity.EPIC);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        LootCategory cat = LootCategory.forItem(stack);
        String type = cat.isRanged() || cat.isWeapon() ? "weapon" : "tool";
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc." + type).m_130940_(ChatFormatting.YELLOW));
    }

    public void drops(LivingDropsEvent e) {
        AbstractArrow arrow;
        DamageSource src = e.getSource();
        boolean canTeleport = false;
        Vec3 targetPos = null;
        Entity entity = src.m_7640_();
        if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).m_37282_() != null) {
            affixes = src.m_7640_().getPersistentData().m_128469_("apoth.affixes");
            canTeleport = affixes.m_128441_(Apoth.Affixes.TELEPATHIC.getRegistryName().toString());
            targetPos = arrow.m_37282_().m_20182_();
        } else {
            affixes = src.m_7640_();
            if (affixes instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)affixes;
                ItemStack weapon = living.m_21205_();
                canTeleport = AffixHelper.getAffixes(weapon).containsKey(Apoth.Affixes.TELEPATHIC);
                targetPos = living.m_20182_();
            }
        }
        if (canTeleport) {
            for (ItemEntity item : e.getDrops()) {
                item.m_6034_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
                item.m_32010_(0);
            }
        }
    }
}

