/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class SpectralShotAffix
extends Affix {
    protected static final StepFunction LEVEL_FUNC = AffixHelper.step(0.2f, 8, 0.05f);

    public SpectralShotAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack).isRanged() && rarity.isAtLeast(LootRarity.EPIC);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{ItemStack.f_41584_.format(100.0f * SpectralShotAffix.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public void onArrowFired(ItemStack stack, LootRarity rarity, float level, LivingEntity user, AbstractArrow arrow) {
        if (user.f_19853_.f_46441_.nextFloat() <= SpectralShotAffix.getTrueLevel(rarity, level) && !user.f_19853_.f_46443_) {
            ArrowItem arrowitem = (ArrowItem)Items.f_42737_;
            AbstractArrow spectralArrow = arrowitem.m_6394_(user.f_19853_, ItemStack.f_41583_, user);
            spectralArrow.m_6686_((double)user.m_146909_(), (double)user.m_146908_(), 0.0, 2.0f, 1.0f);
            this.cloneMotion(arrow, spectralArrow);
            spectralArrow.m_36762_(arrow.m_36792_());
            spectralArrow.m_36781_(arrow.m_36789_());
            spectralArrow.m_36735_(arrow.f_36699_);
            spectralArrow.m_7311_(arrow.m_20094_());
            spectralArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            spectralArrow.getPersistentData().m_128379_("apoth.attrib.done", true);
            arrow.f_19853_.m_7967_((Entity)spectralArrow);
        }
    }

    private void cloneMotion(AbstractArrow src, AbstractArrow dest) {
        dest.m_20256_(src.m_20184_().m_82490_(1.0));
        dest.m_146922_(src.m_146908_());
        dest.m_146926_(src.m_146909_());
        dest.f_19859_ = dest.f_19859_;
        dest.f_19860_ = dest.f_19860_;
    }

    private static float getTrueLevel(LootRarity rarity, float level) {
        return (float)(rarity.ordinal() - LootRarity.EPIC.ordinal()) * 0.2f + LEVEL_FUNC.get(level);
    }
}

