/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class PsychicAffix
extends Affix {
    protected static final StepFunction LEVEL_FUNC = AffixHelper.step(0.2f, 40, 0.01f);

    public PsychicAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{PsychicAffix.fmt(100.0f * PsychicAffix.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.SHIELD;
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Projectile arrow;
        Entity owner;
        Entity entity2 = source.m_7640_();
        if (entity2 instanceof Projectile && (owner = (arrow = (Projectile)entity2).m_37282_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.m_6469_(new EntityDamageSource("player", (Entity)entity).m_19389_(), amount * PsychicAffix.getTrueLevel(rarity, level));
        }
        return super.onShieldBlock(stack, rarity, level, entity, source, amount);
    }

    private static float getTrueLevel(LootRarity rarity, float level) {
        return (float)(rarity.ordinal() - LootRarity.RARE.ordinal()) * 0.125f + LEVEL_FUNC.get(level);
    }
}

