/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class PotionAffix
extends Affix {
    protected final Map<LootRarity, EffectInst> effects;
    @Nullable
    protected final Predicate<LootCategory> types;
    @Nullable
    protected final Predicate<ItemStack> items;
    protected final Target target;
    protected final int instantCooldown;

    public PotionAffix(AffixType type, Map<LootRarity, EffectInst> effects, @Nullable Predicate<LootCategory> types, @Nullable Predicate<ItemStack> items, Target target, int instantCooldown) {
        super(type);
        this.effects = effects;
        this.types = types;
        this.items = items;
        this.target = target;
        this.instantCooldown = instantCooldown;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        MobEffectInstance inst = this.effects.get(rarity).build(level);
        list.accept((Component)this.target.toComponent(PotionAffix.toComponent(inst)).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat == LootCategory.NONE) {
            return false;
        }
        return !(this.types != null && !this.types.test(cat) || this.items != null && !this.items.test(stack) || !this.effects.containsKey(rarity));
    }

    @Override
    public void doPostHurt(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity attacker) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.HURT_SELF) {
            user.m_7292_(inst.build(level));
        } else if (this.target == Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffect(tLiving, inst, level);
        }
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.ATTACK_SELF) {
            user.m_7292_(inst.build(level));
        } else if (this.target == Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(tLiving, inst, level);
        }
    }

    @Override
    public void onBlockBreak(ItemStack stack, LootRarity rarity, float level, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.BREAK_SELF) {
            this.applyEffect((LivingEntity)player, inst, level);
        }
    }

    @Override
    public void onArrowImpact(LootRarity rarity, float level, AbstractArrow arrow, HitResult res, HitResult.Type type) {
        Entity entity;
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.ARROW_SELF) {
            Entity entity2 = arrow.m_37282_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                this.applyEffect(owner, inst, level);
            }
        } else if (this.target == Target.ARROW_TARGET && type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffect(target, inst, level);
        }
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.BLOCK_SELF) {
            this.applyEffect(entity, inst, level);
        } else if (this.target == Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(target, inst, level);
        }
        return amount;
    }

    private void applyEffect(LivingEntity target, EffectInst inst, float level) {
        long lastApplied;
        MobEffectInstance mei = inst.build(level);
        if (mei.m_19544_().m_8093_() && (lastApplied = target.getPersistentData().m_128454_("apoth.affix_cooldown." + this.getRegistryName().toString())) != 0L && lastApplied + 30L >= target.f_19853_.m_46467_()) {
            return;
        }
        target.m_7292_(mei);
        target.getPersistentData().m_128356_("apoth.affix_cooldown." + this.getRegistryName().toString(), target.f_19853_.m_46467_());
    }

    public static Component toComponent(MobEffectInstance inst) {
        TranslatableComponent mutablecomponent = new TranslatableComponent(inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = new TranslatableComponent("potion.withAmplifier", new Object[]{mutablecomponent, new TranslatableComponent("potion.potency." + inst.m_19564_())});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = new TranslatableComponent("potion.withDuration", new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static enum Target {
        ATTACK_SELF("attack_self"),
        ATTACK_TARGET("attack_target"),
        HURT_SELF("hurt_self"),
        HURT_ATTACKER("hurt_attacker"),
        BREAK_SELF("break_self"),
        ARROW_SELF("arrow_self"),
        ARROW_TARGET("arrow_target"),
        BLOCK_SELF("block_self"),
        BLOCK_ATTACKER("block_attacker");

        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Object ... args) {
            return new TranslatableComponent("affix.apotheosis.target." + this.id, args);
        }
    }

    public record EffectInst(Supplier<MobEffect> effect, StepFunction time, @Nullable StepFunction amp) {
        public MobEffectInstance build(float level) {
            return new MobEffectInstance(this.effect.get(), this.time.getInt(level), this.amp == null ? 0 : this.amp.getInt(level));
        }
    }

    public static class Builder {
        private final Supplier<MobEffect> effect;
        private final Map<LootRarity, EffectInst> effects = new HashMap<LootRarity, EffectInst>();
        private Predicate<LootCategory> types;
        private Predicate<ItemStack> items;
        private int instantCooldown = 30;

        public Builder(Supplier<MobEffect> effect) {
            this.effect = effect;
        }

        public Builder cooldown(int instantCooldown) {
            this.instantCooldown = instantCooldown;
            return this;
        }

        public Builder types(Predicate<LootCategory> types) {
            this.types = types;
            return this;
        }

        public Builder items(Predicate<ItemStack> items) {
            this.items = items;
            return this;
        }

        public Builder with(LootRarity rarity, StepFunction timeFunc, @Nullable StepFunction ampFunc) {
            this.effects.put(rarity, new EffectInst(this.effect, timeFunc, ampFunc));
            return this;
        }

        public PotionAffix build(AffixType type, Target target, String id) {
            return (PotionAffix)new PotionAffix(type, this.effects, this.types, this.items, target, this.instantCooldown).setRegistryName(id);
        }
    }
}

