/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.IRegistryDelegate;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;

public class OmneticAffix
extends Affix {
    private static final List<IRegistryDelegate<Item>> TIERS = OmneticAffix.buildTierArray();
    private static String[] descs = new String[]{"misc.apotheosis.iron", "misc.apotheosis.diamond", "misc.apotheosis.netherite"};

    public OmneticAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.BREAKER;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{new TranslatableComponent(descs[OmneticAffix.getListOffset(rarity) / 3])}).m_130940_(ChatFormatting.YELLOW));
    }

    private static List<IRegistryDelegate<Item>> buildTierArray() {
        ArrayList<IRegistryDelegate> items = new ArrayList<IRegistryDelegate>();
        items.add(Items.f_42385_.delegate);
        items.add(Items.f_42386_.delegate);
        items.add(Items.f_42384_.delegate);
        items.add(Items.f_42390_.delegate);
        items.add(Items.f_42391_.delegate);
        items.add(Items.f_42389_.delegate);
        items.add(Items.f_42395_.delegate);
        items.add(Items.f_42396_.delegate);
        items.add(Items.f_42394_.delegate);
        return ImmutableList.copyOf(items);
    }

    public void harvest(PlayerEvent.HarvestCheck e) {
        AffixInstance inst;
        ItemStack stack = e.getPlayer().m_21205_();
        if (!stack.m_41619_() && (inst = AffixHelper.getAffixes(stack).get(Apoth.Affixes.OMNETIC)) != null) {
            for (int i = 0; i < 3; ++i) {
                Item item = (Item)TIERS.get(OmneticAffix.getListOffset(inst.rarity()) + i).get();
                if (!item.m_8096_(e.getTargetBlock())) continue;
                e.setCanHarvest(true);
                return;
            }
        }
    }

    public void speed(PlayerEvent.BreakSpeed e) {
        AffixInstance inst;
        ItemStack stack = e.getPlayer().m_21205_();
        if (!stack.m_41619_() && (inst = AffixHelper.getAffixes(stack).get(Apoth.Affixes.OMNETIC)) != null) {
            float speed = e.getOriginalSpeed();
            for (int i = 0; i < 3; ++i) {
                Item item = (Item)TIERS.get(OmneticAffix.getListOffset(inst.rarity()) + i).get();
                speed = Math.max(OmneticAffix.getBaseSpeed(e.getPlayer(), item, e.getState(), e.getPos()), speed);
            }
            e.setNewSpeed(speed);
        }
    }

    private static int getListOffset(LootRarity rarity) {
        return 3 * Mth.m_14045_((int)(rarity.ordinal() - LootRarity.RARE.ordinal()), (int)0, (int)2);
    }

    static float getBaseSpeed(Player player, Item tool, BlockState state, BlockPos pos) {
        float f = tool.m_8102_(ItemStack.f_41583_, state);
        if (f > 1.0f) {
            int i = EnchantmentHelper.m_44926_((LivingEntity)player);
            ItemStack itemstack = player.m_21205_();
            if (i > 0 && !itemstack.m_41619_()) {
                f += (float)(i * i + 1);
            }
        }
        if (MobEffectUtil.m_19584_((LivingEntity)player)) {
            f *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)player) + 1) * 0.2f;
        }
        if (player.m_21023_(MobEffects.f_19599_)) {
            f *= (switch (player.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        if (player.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            f /= 5.0f;
        }
        if (!player.m_20096_()) {
            f /= 5.0f;
        }
        return f;
    }
}

