/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class FestiveAffix
extends Affix {
    protected static final StepFunction LEVEL_FUNC = AffixHelper.step(0.03f, 6, 0.005f);

    public FestiveAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{ItemStack.f_41584_.format(100.0f * FestiveAffix.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack).isLightWeapon() && rarity.isAtLeast(LootRarity.EPIC);
    }

    private static float getTrueLevel(LootRarity rarity, float level) {
        return (float)(rarity.ordinal() - LootRarity.EPIC.ordinal()) * 0.04f + LEVEL_FUNC.get(level);
    }

    public void drops(LivingDropsEvent e) {
        LivingEntity dead = e.getEntityLiving();
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!e.getDrops().isEmpty() && !(e.getEntityLiving() instanceof Player)) {
                AffixInstance inst = AffixHelper.getAffixes(player.m_21205_()).get(this);
                if (inst == null) {
                    return;
                }
                if (player.f_19853_.f_46441_.nextFloat() < FestiveAffix.getTrueLevel(inst.rarity(), inst.level())) {
                    player.f_19853_.m_6263_(null, dead.m_20185_(), dead.m_20186_(), dead.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (player.f_19853_.f_46441_.nextFloat() - player.f_19853_.f_46441_.nextFloat()) * 0.2f) * 0.7f);
                    ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123812_, dead.m_20185_(), dead.m_20186_(), dead.m_20189_(), 2, 1.0, 0.0, 0.0, 0.0);
                    ArrayList drops = new ArrayList(e.getDrops());
                    for (int i = 0; i < 20; ++i) {
                        for (ItemEntity item : drops) {
                            e.getDrops().add(new ItemEntity(player.f_19853_, item.m_20185_(), item.m_20186_(), item.m_20189_(), item.m_32055_().m_41777_()));
                        }
                    }
                    for (ItemEntity item : e.getDrops()) {
                        if (item.m_32055_().m_41720_().m_41465_()) continue;
                        item.m_6034_(dead.m_20185_(), dead.m_20186_(), dead.m_20189_());
                        item.m_20334_(-0.3 + dead.f_19853_.f_46441_.nextDouble() * 0.6, 0.3 + dead.f_19853_.f_46441_.nextDouble() * 0.3, -0.3 + dead.f_19853_.f_46441_.nextDouble() * 0.6);
                    }
                }
            }
        }
    }
}

