/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.mixin.LivingEntityInvoker;
import shadows.placebo.util.StepFunction;

public class ExecutingAffix
extends Affix {
    protected static final StepFunction LEVEL_FUNC = AffixHelper.step(0.05f, 5, 0.01f);

    public ExecutingAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && rarity.isAtLeast(LootRarity.EPIC);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{ItemStack.f_41584_.format(100.0f * ExecutingAffix.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    private static float getTrueLevel(LootRarity rarity, float level) {
        return (float)(rarity.ordinal() - LootRarity.EPIC.ordinal()) * 0.05f + LEVEL_FUNC.get(level);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        float threshold = ExecutingAffix.getTrueLevel(rarity, level);
        if ((double)Apotheosis.localAtkStrength >= 0.98 && target instanceof LivingEntity) {
            DamageSource src;
            LivingEntity living = (LivingEntity)target;
            if (!living.f_19853_.f_46443_ && living.m_21223_() / living.m_21233_() < threshold && !((LivingEntityInvoker)living).callCheckTotemDeathProtection(src = new EntityDamageSource("apotheosis.execute", (Entity)user).m_19380_().m_19382_())) {
                SoundEvent soundevent = ((LivingEntityInvoker)living).callGetDeathSound();
                if (soundevent != null) {
                    living.m_5496_(soundevent, ((LivingEntityInvoker)living).callGetSoundVolume(), living.m_6100_());
                }
                living.m_21153_(0.0f);
                living.m_6667_(src);
            }
        }
    }
}

