/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class DamageReductionAffix
extends Affix {
    private final DamageType type;
    private final Map<LootRarity, StepFunction> levelFuncs;

    public DamageReductionAffix(DamageType type, Map<LootRarity, StepFunction> levelFuncs) {
        super(AffixType.EFFECT);
        this.type = type;
        this.levelFuncs = levelFuncs;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.ARMOR && this.levelFuncs.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix.apotheosis:damage_reduction.desc", new Object[]{new TranslatableComponent("misc.apotheosis." + this.type.id), DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    public static void onHurt(LivingHurtEvent e) {
        DamageSource src = e.getSource();
        if (src.m_19378_() || src.m_19379_()) {
            return;
        }
        LivingEntity ent = e.getEntityLiving();
        float amount = e.getAmount();
        for (ItemStack s : ent.m_6168_()) {
            Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                Affix affix = inst.affix();
                if (!(affix instanceof DamageReductionAffix)) continue;
                DamageReductionAffix dmg = (DamageReductionAffix)affix;
                if (!dmg.type.test(src)) continue;
                amount *= 1.0f - dmg.getTrueLevel(inst.rarity(), inst.level());
            }
        }
        e.setAmount(amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.levelFuncs.get(rarity).get(level);
    }

    public static enum DamageType implements Predicate<DamageSource>
    {
        PHYSICAL("physical", d -> !d.m_19387_() && !d.m_19384_() && !d.m_19372_()),
        MAGIC("magic", DamageSource::m_19387_),
        FIRE("fire", DamageSource::m_19384_),
        FALL("fall", DamageSource::m_146707_),
        EXPLOSION("explosion", DamageSource::m_19372_);

        private final String id;
        private final Predicate<DamageSource> predicate;

        private DamageType(String id, Predicate<DamageSource> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public boolean test(DamageSource t) {
            return this.predicate.test(t);
        }
    }

    public static class Builder {
        private final DamageType type;
        private final Map<LootRarity, StepFunction> levels = new HashMap<LootRarity, StepFunction>();

        public Builder(DamageType type) {
            this.type = type;
        }

        public Builder with(LootRarity rarity, StepFunction levelFunc) {
            this.levels.put(rarity, levelFunc);
            return this;
        }

        public DamageReductionAffix build(String id) {
            return (DamageReductionAffix)new DamageReductionAffix(this.type, this.levels).setRegistryName(id);
        }
    }
}

