/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class CleavingAffix
extends Affix {
    protected static final StepFunction CHANCE_FUNC = AffixHelper.step(0.3f, 4, 0.05f);
    protected static final StepFunction TARGETS_FUNC = AffixHelper.step(2.0f, 5, 1.0f);
    private static boolean cleaving = false;

    public CleavingAffix() {
        super(AffixType.EFFECT);
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.HEAVY_WEAPON && rarity.isAtLeast(LootRarity.RARE);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{ItemStack.f_41584_.format(100.0f * CleavingAffix.getChance(rarity, level)), CleavingAffix.getTargets(rarity, level)}).m_130940_(ChatFormatting.YELLOW));
    }

    private static float getChance(LootRarity rarity, float level) {
        return (float)(rarity.ordinal() - LootRarity.RARE.ordinal()) * 0.2f + CHANCE_FUNC.get(level);
    }

    private static int getTargets(LootRarity rarity, float level) {
        level %= 0.5f;
        return (rarity.ordinal() - LootRarity.RARE.ordinal()) * 2 + TARGETS_FUNC.getInt(level *= 2.0f);
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        if ((double)Apotheosis.localAtkStrength >= 0.98 && !cleaving && !user.f_19853_.f_46443_) {
            cleaving = true;
            float chance = CleavingAffix.getChance(rarity, level);
            int targets = CleavingAffix.getTargets(rarity, level);
            if (user.f_19853_.f_46441_.nextFloat() < chance && user instanceof Player) {
                Player player = (Player)user;
                List nearby = target.f_19853_.m_6249_(target, new AABB(target.m_142538_()).m_82400_(6.0), CleavingAffix.cleavePredicate((Entity)user, target));
                for (Entity e : nearby) {
                    if (targets <= 0) continue;
                    user.f_20922_ = 300;
                    player.m_5706_(e);
                    --targets;
                }
            }
            cleaving = false;
        }
    }

    public static Predicate<Entity> cleavePredicate(Entity user, Entity target) {
        return e -> {
            if (e instanceof Animal && !(target instanceof Animal) || e instanceof AbstractVillager && !(target instanceof AbstractVillager)) {
                return false;
            }
            if (!AdventureConfig.cleaveHitsPlayers && e instanceof Player) {
                return false;
            }
            if (target instanceof Enemy && !(e instanceof Enemy)) {
                return false;
            }
            return e != user && e instanceof LivingEntity;
        };
    }
}

