/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixInstance;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class AffixHelper {
    public static final String DISPLAY = "display";
    public static final String LORE = "Lore";
    public static final String AFFIX_DATA = "affix_data";
    public static final String AFFIXES = "affixes";
    public static final String RARITY = "rarity";
    public static final String NAME = "name";
    private static final Multimap<AffixType, Affix> BY_TYPE = HashMultimap.create();

    public static void applyAffix(ItemStack stack, AffixInstance affix) {
        Map<Affix, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        affixes.put(affix.affix(), affix);
        AffixHelper.setAffixes(stack, affixes);
    }

    public static void setAffixes(ItemStack stack, Map<Affix, AffixInstance> affixes) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        CompoundTag affixesTag = new CompoundTag();
        for (AffixInstance inst : affixes.values()) {
            affixesTag.m_128350_(inst.affix().getRegistryName().toString(), inst.level());
        }
        afxData.m_128365_(AFFIXES, (Tag)affixesTag);
    }

    public static void setName(ItemStack stack, Component name) {
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_(NAME, Component.Serializer.m_130703_((Component)name));
    }

    @Nullable
    public static Component getName(ItemStack stack) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData == null) {
            return null;
        }
        return Component.Serializer.m_130701_((String)afxData.m_128461_(NAME));
    }

    public static Map<Affix, AffixInstance> getAffixes(ItemStack stack) {
        HashMap<Affix, AffixInstance> map = new HashMap<Affix, AffixInstance>();
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        if (afxData != null && afxData.m_128441_(AFFIXES)) {
            CompoundTag affixes = afxData.m_128469_(AFFIXES);
            LootRarity rarity = AffixHelper.getRarity(stack);
            if (rarity == null) {
                rarity = LootRarity.COMMON;
            }
            for (String key : affixes.m_128431_()) {
                Affix affix = (Affix)Affix.REGISTRY.getValue(new ResourceLocation(key));
                if (affix == null) continue;
                float lvl = affixes.m_128457_(key);
                map.put(affix, new AffixInstance(affix, stack, rarity, lvl));
            }
        }
        return map;
    }

    public static boolean hasAffixes(ItemStack stack) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        return afxData != null && !afxData.m_128469_(AFFIXES).m_128456_();
    }

    public static void addLore(ItemStack stack, Component lore) {
        CompoundTag display = stack.m_41698_(DISPLAY);
        ListTag tag = display.m_128437_(LORE, 8);
        tag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)lore)));
        display.m_128365_(LORE, (Tag)tag);
    }

    public static void setRarity(ItemStack stack, LootRarity rarity) {
        MutableComponent comp = new TranslatableComponent("%s", new Object[]{new TextComponent("")}).m_130948_(Style.f_131099_.m_131148_(rarity.color()));
        CompoundTag afxData = stack.m_41698_(AFFIX_DATA);
        afxData.m_128359_(NAME, Component.Serializer.m_130703_((Component)comp));
        afxData.m_128359_(RARITY, rarity.id());
    }

    @Nullable
    public static LootRarity getRarity(ItemStack stack) {
        CompoundTag afxData = stack.m_41737_(AFFIX_DATA);
        return AffixHelper.getRarity(afxData);
    }

    @Nullable
    public static LootRarity getRarity(@Nullable CompoundTag afxData) {
        if (afxData != null) {
            try {
                return LootRarity.byId(afxData.m_128461_(RARITY));
            }
            catch (IllegalArgumentException e) {
                afxData.m_128473_(RARITY);
                return null;
            }
        }
        return null;
    }

    public static Collection<Affix> byType(AffixType type) {
        return BY_TYPE.get((Object)type);
    }

    public static void recomputeMaps(IForgeRegistry<Affix> reg, RegistryManager stage) {
        BY_TYPE.clear();
        reg.forEach(a -> BY_TYPE.put((Object)a.getType(), a));
    }

    public static StepFunction step(float min, int steps, float step) {
        return new StepFunction(min, steps, step);
    }
}

