/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.config.Configuration;

public abstract class Affix
implements IForgeRegistryEntry<Affix> {
    public static ForgeRegistry<Affix> REGISTRY;
    public static Configuration config;
    protected ResourceLocation name;
    protected final AffixType type;

    public Affix(AffixType type) {
        this.type = type;
    }

    public void addModifiers(ItemStack stack, LootRarity rarity, float level, EquipmentSlot type, BiConsumer<Attribute, AttributeModifier> map) {
    }

    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)new TranslatableComponent("affix." + this.getRegistryName() + ".desc", new Object[]{Affix.fmt(level)}).m_130940_(ChatFormatting.YELLOW));
    }

    public Component getName(ItemStack stack, LootRarity rarity, float level, boolean prefix) {
        if (prefix) {
            return new TranslatableComponent("affix." + this.name);
        }
        return new TranslatableComponent("affix." + this.name + ".suffix");
    }

    public int getDamageProtection(ItemStack stack, LootRarity rarity, float level, DamageSource source) {
        return 0;
    }

    public float getDamageBonus(ItemStack stack, LootRarity rarity, float level, MobType creatureType) {
        return 0.0f;
    }

    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, @Nullable Entity target) {
    }

    public void doPostHurt(ItemStack stack, LootRarity rarity, float level, LivingEntity user, @Nullable Entity attacker) {
    }

    public void onArrowFired(ItemStack stack, LootRarity rarity, float level, LivingEntity user, AbstractArrow arrow) {
    }

    @Nullable
    public InteractionResult onItemUse(ItemStack stack, LootRarity rarity, float level, UseOnContext ctx) {
        return null;
    }

    public void onArrowImpact(LootRarity rarity, float level, AbstractArrow arrow, HitResult res, HitResult.Type type) {
    }

    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        return amount;
    }

    public void onBlockBreak(ItemStack stack, LootRarity rarity, float level, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
    }

    public Affix setRegistryName(ResourceLocation name) {
        if (this.name == null) {
            this.name = name;
        }
        return this;
    }

    public Affix setRegistryName(String name) {
        return this.setRegistryName(GameData.checkPrefix((String)name, (boolean)false));
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<Affix> getRegistryType() {
        return Affix.class;
    }

    public String toString() {
        return String.format("Affix: %s", this.name);
    }

    public AffixType getType() {
        return this.type;
    }

    public abstract boolean canApplyTo(ItemStack var1, LootRarity var2);

    public static MutableComponent loreComponent(String text, Object ... args) {
        return new TranslatableComponent(text, args).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_PURPLE});
    }

    public static String fmt(float f) {
        if (f == (float)((long)f)) {
            return String.format("%d", (long)f);
        }
        return ItemStack.f_41584_.format(f);
    }

    public boolean equals(Object obj) {
        Affix afx;
        return obj instanceof Affix && (afx = (Affix)obj).getRegistryName().equals((Object)this.getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }
}

