/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.io.File;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureEvents;
import shadows.apotheosis.adventure.AdventureGeneration;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.affix.AttributeAffix;
import shadows.apotheosis.adventure.affix.effect.CatalyzingAffix;
import shadows.apotheosis.adventure.affix.effect.CleavingAffix;
import shadows.apotheosis.adventure.affix.effect.DamageReductionAffix;
import shadows.apotheosis.adventure.affix.effect.DurableAffix;
import shadows.apotheosis.adventure.affix.effect.EnlightenedAffix;
import shadows.apotheosis.adventure.affix.effect.ExecutingAffix;
import shadows.apotheosis.adventure.affix.effect.FestiveAffix;
import shadows.apotheosis.adventure.affix.effect.MagicalArrowAffix;
import shadows.apotheosis.adventure.affix.effect.OmneticAffix;
import shadows.apotheosis.adventure.affix.effect.PotionAffix;
import shadows.apotheosis.adventure.affix.effect.PsychicAffix;
import shadows.apotheosis.adventure.affix.effect.RadialAffix;
import shadows.apotheosis.adventure.affix.effect.RetreatingAffix;
import shadows.apotheosis.adventure.affix.effect.SpectralShotAffix;
import shadows.apotheosis.adventure.affix.effect.TelepathicAffix;
import shadows.apotheosis.adventure.affix.effect.ThunderstruckAffix;
import shadows.apotheosis.adventure.affix.reforging.ReforgingMenu;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableBlock;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import shadows.apotheosis.adventure.affix.salvaging.SalvageItem;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingTableBlock;
import shadows.apotheosis.adventure.affix.socket.ExpulsionRecipe;
import shadows.apotheosis.adventure.affix.socket.ExtractionRecipe;
import shadows.apotheosis.adventure.affix.socket.GemItem;
import shadows.apotheosis.adventure.affix.socket.GemManager;
import shadows.apotheosis.adventure.affix.socket.SocketAffix;
import shadows.apotheosis.adventure.affix.socket.SocketingRecipe;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossDungeonFeature;
import shadows.apotheosis.adventure.boss.BossDungeonFeature2;
import shadows.apotheosis.adventure.boss.BossEvents;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.boss.BossSpawnerBlock;
import shadows.apotheosis.adventure.boss.BossSummonerItem;
import shadows.apotheosis.adventure.client.AdventureModuleClient;
import shadows.apotheosis.adventure.compat.AdventureTOPPlugin;
import shadows.apotheosis.adventure.compat.GatewaysCompat;
import shadows.apotheosis.adventure.loot.AffixConvertLootModifier;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.AffixLootModifier;
import shadows.apotheosis.adventure.loot.GemLootModifier;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.adventure.spawner.RandomSpawnerManager;
import shadows.apotheosis.adventure.spawner.RogueSpawnerFeature;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.block_entity.TickingBlockEntityType;
import shadows.placebo.config.Configuration;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.util.StepFunction;

public class AdventureModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Adventure");
    public static final BiMap<LootRarity, IRegistryDelegate<Item>> RARITY_MATERIALS = HashBiMap.create();
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22284_), (Object)40.0, (String)"f_22308_");
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22285_), (Object)30.0, (String)"f_22308_");
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        MinecraftForge.EVENT_BUS.register((Object)new AdventureEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BossEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        GemManager.INSTANCE.registerToBus();
        AffixLootManager.INSTANCE.registerToBus();
        BossArmorManager.INSTANCE.registerToBus();
        BossItemManager.INSTANCE.registerToBus();
        RandomSpawnerManager.INSTANCE.registerToBus();
        Apotheosis.HELPER.registerProvider(f -> {
            f.addRecipe((Recipe)new SocketingRecipe());
            f.addRecipe((Recipe)new ExpulsionRecipe());
            f.addRecipe((Recipe)new ExtractionRecipe());
            Item g = Apoth.Items.GEM_DUST;
            f.addShaped((Object)Apoth.Items.VIAL_OF_EXPULSION, 3, 3, new Object[]{g, Items.f_42542_, g, Items.f_42585_, Apotheosis.potionIngredient(Potions.f_43601_), Items.f_42585_, g, Items.f_42448_, g});
            f.addShaped((Object)Apoth.Items.VIAL_OF_EXTRACTION, 3, 3, new Object[]{g, Items.f_151049_, g, Items.f_42584_, Apotheosis.potionIngredient(Potions.f_43601_), Items.f_42584_, g, Items.f_42447_, g});
        });
        e.enqueueWork(() -> {
            if (ModList.get().isLoaded("gateways")) {
                GatewaysCompat.register();
            }
            if (ModList.get().isLoaded("theoneprobe")) {
                AdventureTOPPlugin.register();
            }
            LootSystem.defaultBlockTable((Block)Apoth.Blocks.REFORGING_TABLE);
            LootSystem.defaultBlockTable((Block)Apoth.Blocks.SALVAGING_TABLE);
        });
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Feature)BossDungeonFeature.INSTANCE.setRegistryName("boss_dng")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)BossDungeonFeature2.INSTANCE.setRegistryName("boss_dng_2")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)RogueSpawnerFeature.INSTANCE.setRegistryName("rogue_spawner")));
        MinecraftForge.EVENT_BUS.register(AdventureGeneration.class);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Item)new GemItem(new Item.Properties().m_41487_(1)).setRegistryName("gem")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BossSummonerItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("boss_summoner")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("gem_dust")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("vial_of_extraction")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("vial_of_expulsion")));
        for (LootRarity r : LootRarity.values()) {
            if (r == LootRarity.ANCIENT) continue;
            Item material = (Item)new SalvageItem(r, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName(r.id() + "_material");
            e.getRegistry().register((IForgeRegistryEntry)material);
            RARITY_MATERIALS.put((Object)r, (Object)material.delegate);
        }
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)Apoth.Blocks.REFORGING_TABLE, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("reforging_table")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)Apoth.Blocks.SALVAGING_TABLE, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("salvaging_table")));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Block)new BossSpawnerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_60993_()).setRegistryName("boss_spawner")));
        e.getRegistry().register((IForgeRegistryEntry)((Block)new ReforgingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(5.0f, 1000.0f)).setRegistryName("reforging_table")));
        e.getRegistry().register((IForgeRegistryEntry)((Block)new SalvagingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.5f)).setRegistryName("salvaging_table")));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(BossSpawnerBlock.BossSpawnerTile::new, (Set)ImmutableSet.of((Object)((Object)Apoth.Blocks.BOSS_SPAWNER)), false, true).setRegistryName("boss_spawner")));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(ReforgingTableTile::new, (Set)ImmutableSet.of((Object)((Object)Apoth.Blocks.REFORGING_TABLE)), true, false).setRegistryName("reforging_table")));
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)SocketingRecipe.Serializer.INSTANCE.setRegistryName("socketing")));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)ExpulsionRecipe.Serializer.INSTANCE.setRegistryName("expulsion")));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)ExtractionRecipe.Serializer.INSTANCE.setRegistryName("extraction")));
    }

    @SubscribeEvent
    public void lootSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)new GemLootModifier.Serializer().setRegistryName("gems"));
        e.getRegistry().register((IForgeRegistryEntry)new AffixLootModifier.Serializer().setRegistryName("affix_loot"));
        e.getRegistry().register((IForgeRegistryEntry)new AffixConvertLootModifier.Serializer().setRegistryName("affix_conversion"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)ContainerUtil.makeType(ReforgingMenu::new).setRegistryName("reforging")));
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(SalvagingMenu::new).setRegistryName("salvage")));
    }

    @SubscribeEvent
    public void attribs(RegistryEvent.Register<Attribute> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Attribute[]{(Attribute)new RangedAttribute("apotheosis:draw_speed", 1.0, 1.0, 4.0).m_22084_(true).setRegistryName("draw_speed"), (Attribute)new RangedAttribute("apotheosis:crit_chance", 1.0, 1.0, 5.0).m_22084_(true).setRegistryName("crit_chance"), (Attribute)new RangedAttribute("apotheosis:crit_damage", 1.0, 1.0, 1024.0).m_22084_(true).setRegistryName("crit_damage"), (Attribute)new RangedAttribute("apotheosis:cold_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("cold_damage"), (Attribute)new RangedAttribute("apotheosis:fire_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("fire_damage"), (Attribute)new RangedAttribute("apotheosis:life_steal", 1.0, 1.0, 1024.0).m_22084_(true).setRegistryName("life_steal"), (Attribute)new RangedAttribute("apotheosis:piercing", 1.0, 1.0, 2.0).m_22084_(true).setRegistryName("piercing"), (Attribute)new RangedAttribute("apotheosis:current_hp_damage", 1.0, 1.0, 2.0).m_22084_(true).setRegistryName("current_hp_damage"), (Attribute)new RangedAttribute("apotheosis:overheal", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("overheal"), (Attribute)new RangedAttribute("apotheosis:ghost_health", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("ghost_health"), (Attribute)new RangedAttribute("apotheosis:mining_speed", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("mining_speed"), (Attribute)new RangedAttribute("apotheosis:arrow_damage", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("arrow_damage"), (Attribute)new RangedAttribute("apotheosis:arrow_velocity", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("arrow_velocity")});
    }

    @SubscribeEvent
    public void applyAttribs(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(type -> AdventureModule.addAll((EntityType<? extends LivingEntity>)type, (arg_0, arg_1) -> ((EntityAttributeModificationEvent)e).add(arg_0, arg_1), Apoth.Attributes.DRAW_SPEED, Apoth.Attributes.CRIT_CHANCE, Apoth.Attributes.CRIT_DAMAGE, Apoth.Attributes.COLD_DAMAGE, Apoth.Attributes.FIRE_DAMAGE, Apoth.Attributes.LIFE_STEAL, Apoth.Attributes.PIERCING, Apoth.Attributes.CURRENT_HP_DAMAGE, Apoth.Attributes.OVERHEAL, Apoth.Attributes.GHOST_HEALTH, Apoth.Attributes.MINING_SPEED, Apoth.Attributes.ARROW_DAMAGE, Apoth.Attributes.ARROW_VELOCITY));
    }

    private static void addAll(EntityType<? extends LivingEntity> type, BiConsumer<EntityType<? extends LivingEntity>, Attribute> add, Attribute ... attribs) {
        for (Attribute a : attribs) {
            add.accept(type, a);
        }
    }

    @SubscribeEvent
    public void affixes(RegistryEvent.Register<Affix> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Affix[]{new AttributeAffix.Builder(() -> Attributes.f_22276_, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.5f, 3, 0.5f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(1.5f, 5, 0.5f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(3.0f, 8, 0.5f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(5.0f, 10, 0.5f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(8.0f, 14, 0.5f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(12.0f, 20, 0.5f)).types(LootCategory::isDefensive).build("blessed"), new AttributeAffix.Builder(() -> Attributes.f_22284_, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.25f, 3, 0.25f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(1.0f, 8, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(3.0f, 10, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(5.0f, 16, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(7.0f, 24, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(9.0f, 30, 0.25f)).types(LootCategory::isDefensive).build("ironforged"), new AttributeAffix.Builder((Supplier<Attribute>)ForgeMod.SWIM_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 10, 0.02f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.08f, 10, 0.02f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.12f, 10, 0.02f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.15f, 12, 0.02f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.18f, 14, 0.02f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.25f, 10, 0.02f)).types(l -> l == LootCategory.ARMOR).items((ItemStack s) -> ((ArmorItem)s.m_41720_()).m_40402_() == EquipmentSlot.FEET).build("aquatic"), new AttributeAffix.Builder((Supplier<Attribute>)ForgeMod.ENTITY_GRAVITY, AttributeModifier.Operation.MULTIPLY_TOTAL).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(-0.05f, 2, -0.02f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(-0.05f, 4, -0.02f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(-0.05f, 6, -0.02f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(-0.05f, 8, -0.02f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(-0.05f, 10, -0.02f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(-0.05f, 10, -0.02f)).types(l -> l == LootCategory.ARMOR).items((ItemStack s) -> ((ArmorItem)s.m_41720_()).m_40402_() == EquipmentSlot.CHEST).build("gravitational"), new AttributeAffix.Builder(() -> Attributes.f_22285_, AttributeModifier.Operation.ADDITION).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.25f, 2, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(1.0f, 4, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(2.0f, 7, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(4.0f, 12, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(6.0f, 18, 0.25f)).types(LootCategory::isDefensive).build("steel_touched"), new AttributeAffix.Builder(() -> Attributes.f_22278_, AttributeModifier.Operation.ADDITION).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.04f, 5, 0.02f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.06f, 6, 0.02f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.1f, 10, 0.02f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.2f, 14, 0.02f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.4f, 16, 0.02f)).types(LootCategory::isDefensive).build("stalwart"), new PotionAffix.Builder(() -> MobEffects.f_19606_).with(LootRarity.RARE, AdventureModule.step(20.0f, 30, 2.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(40.0f, 50, 2.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(60.0f, 70, 2.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(100.0f, 100, 4.0f), AdventureModule.step(1.0f, 2, 1.0f)).types(l -> l == LootCategory.ARMOR).build(AffixType.EFFECT, PotionAffix.Target.HURT_SELF, "bolstering"), new PotionAffix.Builder(() -> MobEffects.f_19601_).with(LootRarity.EPIC, AdventureModule.step(1.0f, 1, 0.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(1.0f, 1, 0.0f), AdventureModule.step(0.0f, 2, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(1.0f, 1, 0.0f), AdventureModule.step(1.0f, 3, 1.0f)).types(l -> l == LootCategory.ARMOR).build(AffixType.EFFECT, PotionAffix.Target.HURT_SELF, "revitalizing"), new AttributeAffix.Builder(() -> Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 10, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.08f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.12f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.15f, 12, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.18f, 14, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.25f, 10, 0.01f)).types(l -> l.isRanged() || l == LootCategory.ARMOR).build("windswept"), new AttributeAffix.Builder((Supplier<Attribute>)ForgeMod.STEP_HEIGHT_ADDITION, AttributeModifier.Operation.ADDITION).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.25f, 1, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.5f, 3, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.5f, 4, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(1.0f, 6, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(1.5f, 7, 0.25f)).types(l -> l == LootCategory.ARMOR).items((ItemStack s) -> ((ArmorItem)s.m_41720_()).m_40402_() == EquipmentSlot.FEET).build("elastic"), new AttributeAffix.Builder(() -> Attributes.f_22286_, AttributeModifier.Operation.ADDITION).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(1.5f, 8, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(2.5f, 10, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(4.5f, 12, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(8.0f, 16, 0.25f)).types(l -> l == LootCategory.ARMOR).build("fortunate"), new AttributeAffix.Builder(() -> Attributes.f_22281_, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.5f, 4, 0.25f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(1.0f, 10, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(2.0f, 16, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(6.0f, 18, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(8.0f, 24, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(12.0f, 30, 0.25f)).types(LootCategory::isLightWeapon).build("violent"), new AttributeAffix.Builder(() -> Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.2f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.35f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.5f, 12, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.6f, 14, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.8f, 10, 0.01f)).types(LootCategory::isLightWeapon).build("graceful"), new AttributeAffix.Builder((Supplier<Attribute>)ForgeMod.ATTACK_RANGE, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.5f, 4, 0.25f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.75f, 5, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(1.0f, 6, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(1.5f, 8, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(2.0f, 10, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(2.5f, 16, 0.25f)).types(LootCategory::isLightWeapon).build("elongated"), new AttributeAffix.Builder(() -> Attributes.f_22281_, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(2.0f, 8, 0.25f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(4.0f, 12, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(5.5f, 20, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(7.0f, 24, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(10.0f, 30, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(16.0f, 36, 0.25f)).types(l -> l == LootCategory.HEAVY_WEAPON).build("murderous"), new AttributeAffix.Builder(() -> Attributes.f_22282_, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.25f, 10, 0.025f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.75f, 20, 0.025f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(1.5f, 30, 0.025f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(2.0f, 30, 0.025f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(3.5f, 30, 0.025f)).with(LootRarity.ANCIENT, l -> 5.0f).types(l -> l == LootCategory.HEAVY_WEAPON).build("forceful"), new AttributeAffix.Builder(() -> Apoth.Attributes.PIERCING, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.25f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.4f, 7, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.5f, 8, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.7f, 10, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.85f, 15, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.9f, 20, 0.01f)).types(l -> l == LootCategory.HEAVY_WEAPON).build("shredding"), new AttributeAffix.Builder(() -> Apoth.Attributes.CURRENT_HP_DAMAGE, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.01f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.04f, 6, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.1f, 8, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.14f, 10, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.18f, 16, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.25f, 20, 0.01f)).types(l -> l == LootCategory.HEAVY_WEAPON).build("giant_slaying"), new AttributeAffix.Builder(() -> Apoth.Attributes.OVERHEAL, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.15f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.25f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.4f, 12, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.5f, 14, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.65f, 20, 0.01f)).types(l -> l == LootCategory.HEAVY_WEAPON).build("berserking"), new AttributeAffix.Builder(() -> Apoth.Attributes.CRIT_CHANCE, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 15, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.2f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.35f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.4f, 10, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.65f, 15, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.85f, 20, 0.01f)).types(l -> l == LootCategory.HEAVY_WEAPON).build("annihilating"), new AttributeAffix.Builder(() -> Apoth.Attributes.CRIT_DAMAGE, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 8, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.15f, 15, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.25f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.4f, 10, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.55f, 10, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.75f, 15, 0.01f)).types(l -> l == LootCategory.HEAVY_WEAPON).build("decimating"), new AttributeAffix.Builder((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, AttributeModifier.Operation.ADDITION).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.5f, 6, 0.25f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.75f, 8, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(1.0f, 10, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(1.5f, 12, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(2.0f, 14, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(2.5f, 20, 0.25f)).types(l -> l == LootCategory.BREAKER).build("lengthy"), new AttributeAffix.Builder(() -> Apoth.Attributes.DRAW_SPEED, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, l -> l > 0.5f ? 0.2f : 0.1f).with(LootRarity.UNCOMMON, l -> l > 0.5f ? 0.33f : 0.25f).with(LootRarity.RARE, l -> l > 0.5f ? 1.0f : 0.5f).with(LootRarity.EPIC, l -> l > 0.5f ? 1.2f : 1.1f).with(LootRarity.MYTHIC, l -> l > 0.5f ? 1.5f : 1.33f).with(LootRarity.ANCIENT, l -> l > 0.5f ? 2.5f : 2.0f).types(LootCategory::isRanged).build("agile"), new AttributeAffix.Builder(() -> Apoth.Attributes.CRIT_CHANCE, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.01f, 10, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.1f, 8, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.2f, 7, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.3f, 5, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.45f, 10, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.65f, 20, 0.01f)).types(LootCategory::isLightWeapon).build("intricate"), new AttributeAffix.Builder(() -> Apoth.Attributes.CRIT_DAMAGE, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.01f, 9, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.1f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.2f, 10, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.3f, 10, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.5f, 15, 0.01f)).types(LootCategory::isLightWeapon).build("lacerating"), new AttributeAffix.Builder(() -> Apoth.Attributes.COLD_DAMAGE, AttributeModifier.Operation.ADDITION).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(1.0f, 6, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(2.0f, 10, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(4.0f, 14, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(5.0f, 17, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(7.0f, 20, 0.25f)).types(LootCategory::isLightWeapon).build("glacial"), new AttributeAffix.Builder(() -> Apoth.Attributes.FIRE_DAMAGE, AttributeModifier.Operation.ADDITION).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(1.0f, 6, 0.25f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(2.0f, 10, 0.25f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(4.0f, 14, 0.25f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(5.0f, 17, 0.25f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(7.0f, 20, 0.25f)).types(LootCategory::isLightWeapon).build("infernal"), new AttributeAffix.Builder(() -> Apoth.Attributes.LIFE_STEAL, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.1f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.15f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.2f, 12, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.3f, 14, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.4f, 10, 0.01f)).types(LootCategory::isLightWeapon).build("vampiric"), new AttributeAffix.Builder(() -> Apoth.Attributes.MINING_SPEED, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.2f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.35f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.5f, 12, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.65f, 14, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.9f, 10, 0.01f)).types(l -> l == LootCategory.BREAKER).build("destructive"), new AttributeAffix.Builder(() -> Apoth.Attributes.ARROW_DAMAGE, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.2f, 15, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.3f, 20, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.45f, 30, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.6f, 40, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.75f, 50, 0.01f)).types(LootCategory::isRanged).build("elven"), new AttributeAffix.Builder(() -> Apoth.Attributes.ARROW_VELOCITY, AttributeModifier.Operation.MULTIPLY_BASE).with(LootRarity.COMMON, (Float2FloatFunction)AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.UNCOMMON, (Float2FloatFunction)AdventureModule.step(0.1f, 10, 0.01f)).with(LootRarity.RARE, (Float2FloatFunction)AdventureModule.step(0.15f, 10, 0.01f)).with(LootRarity.EPIC, (Float2FloatFunction)AdventureModule.step(0.2f, 12, 0.01f)).with(LootRarity.MYTHIC, (Float2FloatFunction)AdventureModule.step(0.3f, 14, 0.01f)).with(LootRarity.ANCIENT, (Float2FloatFunction)AdventureModule.step(0.4f, 10, 0.01f)).types(LootCategory::isRanged).build("streamlined"), new SocketAffix().setRegistryName("socket"), new DurableAffix().setRegistryName("durable"), new PotionAffix.Builder(() -> MobEffects.f_19596_).with(LootRarity.RARE, AdventureModule.step(100.0f, 5, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(140.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.MYTHIC, AdventureModule.step(180.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(240.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(LootCategory::isWeapon).build(AffixType.EFFECT, PotionAffix.Target.ATTACK_SELF, "elusive"), new PotionAffix.Builder(() -> MobEffects.f_19598_).with(LootRarity.RARE, AdventureModule.step(100.0f, 5, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(140.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(180.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 2.0f)).with(LootRarity.ANCIENT, AdventureModule.step(240.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(l -> l == LootCategory.BREAKER).build(AffixType.EFFECT, PotionAffix.Target.BREAK_SELF, "swift"), new PotionAffix.Builder(() -> MobEffects.f_19597_).with(LootRarity.RARE, AdventureModule.step(20.0f, 2, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(60.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(80.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 2.0f)).with(LootRarity.ANCIENT, AdventureModule.step(120.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(LootCategory::isRanged).build(AffixType.EFFECT, PotionAffix.Target.ARROW_TARGET, "ensnaring"), new PotionAffix.Builder(() -> MobEffects.f_19614_).with(LootRarity.RARE, AdventureModule.step(60.0f, 5, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(100.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(120.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 2.0f)).with(LootRarity.ANCIENT, AdventureModule.step(160.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(l -> l == LootCategory.SHIELD).build(AffixType.EFFECT, PotionAffix.Target.BLOCK_ATTACKER, "venomous"), new PotionAffix.Builder(() -> MobEffects.f_19596_).with(LootRarity.RARE, AdventureModule.step(60.0f, 5, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(80.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.MYTHIC, AdventureModule.step(100.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(120.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(LootCategory::isRanged).build(AffixType.EFFECT, PotionAffix.Target.ARROW_SELF, "fleeting"), new PotionAffix.Builder(() -> MobEffects.f_19613_).with(LootRarity.RARE, AdventureModule.step(40.0f, 5, 20.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(60.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(80.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(120.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(LootCategory::isWeapon).build(AffixType.EFFECT, PotionAffix.Target.ATTACK_TARGET, "weakening"), new PotionAffix.Builder(() -> MobEffects.f_19620_).with(LootRarity.EPIC, AdventureModule.step(10.0f, 3, 10.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(10.0f, 4, 10.0f), AdventureModule.step(0.0f, 2, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(20.0f, 5, 10.0f), AdventureModule.step(1.0f, 3, 1.0f)).types(LootCategory::isRanged).build(AffixType.EFFECT, PotionAffix.Target.ARROW_TARGET, "shulkers"), new PotionAffix.Builder(() -> MobEffects.f_19615_).with(LootRarity.EPIC, AdventureModule.step(40.0f, 8, 20.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(60.0f, 10, 20.0f), AdventureModule.step(0.0f, 1, 2.0f)).with(LootRarity.ANCIENT, AdventureModule.step(100.0f, 10, 40.0f), AdventureModule.step(2.0f, 1, 0.0f)).types(l -> l == LootCategory.SHIELD).build(AffixType.EFFECT, PotionAffix.Target.BLOCK_ATTACKER, "withering"), new PotionAffix.Builder(() -> MobEffects.f_19614_).with(LootRarity.EPIC, AdventureModule.step(20.0f, 7, 10.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(20.0f, 9, 10.0f), AdventureModule.step(0.0f, 2, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(40.0f, 13, 10.0f), AdventureModule.step(1.0f, 3, 1.0f)).types(LootCategory::isRanged).build(AffixType.EFFECT, PotionAffix.Target.ARROW_TARGET, "ivy_laced"), new PotionAffix.Builder(() -> MobEffects.f_19615_).with(LootRarity.MYTHIC, AdventureModule.step(140.0f, 3, 20.0f), AdventureModule.step(1.0f, 3, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(180.0f, 5, 20.0f), AdventureModule.step(1.0f, 3, 1.0f)).types(LootCategory::isRanged).build(AffixType.EFFECT, PotionAffix.Target.ARROW_TARGET, "satanic"), new DamageReductionAffix.Builder(DamageReductionAffix.DamageType.PHYSICAL).with(LootRarity.EPIC, AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.MYTHIC, AdventureModule.step(0.05f, 10, 0.01f)).with(LootRarity.ANCIENT, AdventureModule.step(0.05f, 20, 0.01f)).build("blockading"), new DamageReductionAffix.Builder(DamageReductionAffix.DamageType.MAGIC).with(LootRarity.EPIC, AdventureModule.step(0.05f, 5, 0.01f)).with(LootRarity.MYTHIC, AdventureModule.step(0.05f, 10, 0.01f)).with(LootRarity.ANCIENT, AdventureModule.step(0.05f, 20, 0.01f)).build("runed"), new DamageReductionAffix.Builder(DamageReductionAffix.DamageType.EXPLOSION).with(LootRarity.EPIC, AdventureModule.step(0.15f, 5, 0.01f)).with(LootRarity.MYTHIC, AdventureModule.step(0.35f, 10, 0.01f)).with(LootRarity.ANCIENT, AdventureModule.step(0.55f, 20, 0.01f)).build("blast_forged"), new DamageReductionAffix.Builder(DamageReductionAffix.DamageType.FIRE).with(LootRarity.EPIC, AdventureModule.step(0.25f, 5, 0.01f)).with(LootRarity.MYTHIC, AdventureModule.step(0.4f, 10, 0.01f)).with(LootRarity.ANCIENT, AdventureModule.step(0.6f, 20, 0.01f)).build("dwarven"), new DamageReductionAffix.Builder(DamageReductionAffix.DamageType.FALL).with(LootRarity.RARE, AdventureModule.step(0.15f, 10, 0.01f)).with(LootRarity.EPIC, AdventureModule.step(0.4f, 15, 0.01f)).with(LootRarity.MYTHIC, AdventureModule.step(0.55f, 25, 0.01f)).with(LootRarity.ANCIENT, AdventureModule.step(1.0f, 1, 0.0f)).build("feathery"), new SpectralShotAffix().setRegistryName("spectral"), new MagicalArrowAffix().setRegistryName("magical"), new FestiveAffix().setRegistryName("festive"), new ThunderstruckAffix().setRegistryName("thunderstruck"), new RetreatingAffix().setRegistryName("retreating"), new TelepathicAffix().setRegistryName("telepathic"), new ExecutingAffix().setRegistryName("executing"), new CleavingAffix().setRegistryName("cleaving"), new OmneticAffix().setRegistryName("omnetic"), new RadialAffix().setRegistryName("radial"), new EnlightenedAffix().setRegistryName("enlightened"), new PsychicAffix().setRegistryName("psychic"), new CatalyzingAffix().setRegistryName("catalyzing")});
        if (Apotheosis.enablePotion) {
            e.getRegistry().registerAll((IForgeRegistryEntry[])new Affix[]{new PotionAffix.Builder(() -> Apoth.Effects.SUNDERING).with(LootRarity.MYTHIC, AdventureModule.step(60.0f, 10, 5.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(100.0f, 20, 5.0f), AdventureModule.step(1.0f, 1, 1.0f)).types(LootCategory::isRanged).build(AffixType.EFFECT, PotionAffix.Target.ARROW_TARGET, "acidic"), new PotionAffix.Builder(() -> Apoth.Effects.SUNDERING).with(LootRarity.RARE, AdventureModule.step(30.0f, 15, 5.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(40.0f, 15, 5.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(60.0f, 20, 5.0f), AdventureModule.step(1.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(100.0f, 20, 5.0f), AdventureModule.step(2.0f, 1, 1.0f)).types(l -> l == LootCategory.HEAVY_WEAPON).build(AffixType.EFFECT, PotionAffix.Target.ATTACK_TARGET, "caustic"), new PotionAffix.Builder(() -> Apoth.Effects.KNOWLEDGE).with(LootRarity.RARE, AdventureModule.step(30.0f, 15, 5.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(40.0f, 15, 5.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(60.0f, 20, 5.0f), AdventureModule.step(1.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(100.0f, 20, 5.0f), AdventureModule.step(2.0f, 1, 1.0f)).types(LootCategory::isLightWeapon).build(AffixType.EFFECT, PotionAffix.Target.ATTACK_SELF, "sophisticated"), new PotionAffix.Builder(() -> Apoth.Effects.BLEEDING).with(LootRarity.RARE, AdventureModule.step(60.0f, 15, 5.0f), AdventureModule.step(0.0f, 1, 0.0f)).with(LootRarity.EPIC, AdventureModule.step(90.0f, 15, 5.0f), AdventureModule.step(0.0f, 1, 1.0f)).with(LootRarity.MYTHIC, AdventureModule.step(120.0f, 20, 5.0f), AdventureModule.step(1.0f, 1, 1.0f)).with(LootRarity.ANCIENT, AdventureModule.step(200.0f, 20, 5.0f), AdventureModule.step(2.0f, 1, 1.0f)).types(l -> l == LootCategory.SHIELD).build(AffixType.EFFECT, PotionAffix.Target.BLOCK_ATTACKER, "devilish")});
        }
    }

    private static StepFunction step(float min, int steps, float step) {
        return AffixHelper.step(min, steps, step);
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(AdventureModuleClient::init);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new AdventureModuleClient());
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration mainConfig = new Configuration(new File(Apotheosis.configDir, "adventure.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        AdventureConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (e == null && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }
}

