/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.common.world.feature.config.BigFungyssFeatureConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.common.Tags;

public class MegaFungyssFeature
extends Feature<BigFungyssFeatureConfig> {
    public MegaFungyssFeature(Codec<BigFungyssFeatureConfig> codec) {
        super(codec);
    }

    private int getRandomHeight(Random random) {
        return random.nextInt(4) + 11;
    }

    private boolean canGenerate(LevelAccessor world, ChunkGenerator generator, BlockPos pos, int height, BlockPos.MutableBlockPos mutable) {
        if (pos.m_123342_() < 1 || pos.m_123342_() + height + 1 >= generator.m_6331_()) {
            return false;
        }
        if (!world.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.STONE)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockState state = world.m_8055_((BlockPos)mutable.m_122154_((Vec3i)pos, 0, i, 0));
            if (state.m_60795_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_142674_(@Nonnull FeaturePlaceContext<BigFungyssFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        int height = this.getRandomHeight(context.m_159776_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (!this.canGenerate((LevelAccessor)level, context.m_159775_(), pos, height, mutable)) {
            return false;
        }
        this.placeStem((LevelAccessor)level, rand, pos, height, mutable, (BigFungyssFeatureConfig)context.m_159778_());
        this.placeCap((LevelAccessor)level, rand, pos, height, mutable, (BigFungyssFeatureConfig)context.m_159778_());
        return true;
    }

    private void placeStem(LevelAccessor world, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        for (int i = 0; i < height; ++i) {
            this.placeStemBlock(world, config.stemProvider.m_7112_(random, pos), mutable, pos, 0, i, 0);
            this.placeStemBlock(world, config.stemProvider.m_7112_(random, pos), mutable, pos, 1, i, 0);
            this.placeStemBlock(world, config.stemProvider.m_7112_(random, pos), mutable, pos, 1, i, 1);
            this.placeStemBlock(world, config.stemProvider.m_7112_(random, pos), mutable, pos, 0, i, 1);
        }
    }

    private void placeStemBlock(LevelAccessor world, BlockState state, BlockPos.MutableBlockPos mutable, BlockPos pos, int xOffset, int yOffset, int zOffset) {
        mutable.m_122190_((Vec3i)pos).m_122184_(xOffset, yOffset, zOffset);
        if (!world.m_8055_((BlockPos)mutable).m_60804_((BlockGetter)world, (BlockPos)mutable)) {
            this.m_5974_((LevelWriter)world, (BlockPos)mutable, state);
        }
    }

    private void placeCap(LevelAccessor world, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        for (int i = height - 3; i <= height; ++i) {
            int zOffset;
            int xOffset;
            int distanceToStem = 2;
            for (xOffset = -distanceToStem; xOffset <= distanceToStem + 1; ++xOffset) {
                for (zOffset = -distanceToStem; zOffset <= distanceToStem + 1; ++zOffset) {
                    boolean moveDown;
                    boolean flag2;
                    boolean flag1 = i >= height && xOffset != -distanceToStem && xOffset != distanceToStem + 1 && zOffset != -distanceToStem && zOffset != distanceToStem + 1;
                    boolean bl = flag2 = i < height && (xOffset == -distanceToStem || xOffset == distanceToStem + 1 || zOffset == -distanceToStem || zOffset == distanceToStem + 1) && (xOffset != -distanceToStem && xOffset != distanceToStem + 1 || zOffset != -distanceToStem && zOffset != distanceToStem + 1);
                    if (!flag1 && !flag2) continue;
                    mutable.m_122154_((Vec3i)pos, xOffset, i, zOffset);
                    boolean bl2 = moveDown = xOffset == -1 && zOffset == -1 || xOffset == -1 && zOffset == 2 || xOffset == 2 && zOffset == -1 || xOffset == 2 && zOffset == 2;
                    if (moveDown) {
                        mutable.m_122173_(Direction.DOWN);
                    }
                    BlockState state = i == height && !moveDown ? config.capProvider.m_7112_(random, pos) : (BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.m_7112_(random, pos).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(xOffset < 0))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(xOffset > 0))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(zOffset < 0))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(zOffset > 0));
                    this.m_5974_((LevelWriter)world, (BlockPos)mutable, state);
                }
            }
            for (xOffset = 0; xOffset <= 1; ++xOffset) {
                for (zOffset = 0; zOffset <= 1; ++zOffset) {
                    for (Direction direction : Direction.values()) {
                        if (direction.m_122434_() == Direction.Axis.Y) continue;
                        mutable.m_122154_((Vec3i)pos, xOffset, height - 5, zOffset);
                        mutable.m_122173_(direction);
                        if (!world.m_8055_((BlockPos)mutable).m_60795_()) continue;
                        this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.m_7112_(random, pos).m_61124_((Property)PipeBlock.f_55154_.get(direction.m_122424_()), (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
        }
        int xOffset = random.nextInt(2);
        int zOffset = random.nextInt(2);
        if (config.variant == 0) {
            this.placeSmallCap(world, random, pos, height, mutable, xOffset, zOffset, config);
            this.placeSmallCap(world, random, pos, height - 2, mutable, xOffset == 0 ? 1 : 0, zOffset == 0 ? 1 : 0, config);
        } else {
            this.placeSmallFungyss(world, random, pos, height - 1, mutable, xOffset, zOffset, config);
            this.placeSmallFungyss(world, random, pos, height - 2, mutable, xOffset == 0 ? 1 : 0, zOffset == 0 ? 1 : 0, config);
        }
    }

    private void placeSmallCap(LevelAccessor world, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, int xOffset, int zOffset, BigFungyssFeatureConfig config) {
        Direction direction = this.getDirectionFromOffset(xOffset, zOffset);
        mutable.m_122154_((Vec3i)pos, xOffset, height - 8, zOffset);
        mutable.m_122173_(direction);
        this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.m_7112_(random, pos).m_61124_((Property)PipeBlock.f_55154_.get(direction.m_122424_()), (Comparable)Boolean.valueOf(false)));
        for (int i = 0; i <= 1; ++i) {
            direction = direction == Direction.SOUTH ? Direction.EAST : Direction.m_122407_((int)(direction.m_122416_() - 1));
            mutable.m_122173_(direction);
            this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.m_7112_(random, pos).m_61124_((Property)PipeBlock.f_55154_.get(direction.m_122424_().m_122427_()), (Comparable)Boolean.valueOf(false)));
        }
    }

    private void placeSmallFungyss(LevelAccessor world, Random random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, int xOffset, int zOffset, BigFungyssFeatureConfig config) {
        Direction direction = this.getDirectionFromOffset(xOffset, zOffset);
        int stemHeight = world.m_5822_().nextInt(2) + 2;
        mutable.m_122154_((Vec3i)pos, xOffset, height - 8, zOffset);
        mutable.m_122173_(direction);
        if (stemHeight == 3) {
            mutable.m_122173_(Direction.DOWN);
        }
        this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.stemProvider.m_7112_(random, pos).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)direction.m_122434_()));
        mutable.m_122173_(direction);
        this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.hyphaeProvider.m_7112_(random, pos).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)direction.m_122434_()));
        for (int i = 0; i < stemHeight; ++i) {
            mutable.m_122173_(Direction.UP);
            this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.stemProvider.m_7112_(random, pos).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y));
        }
        pos = mutable.m_7949_();
        int distanceToStem = 1;
        for (int i = stemHeight; i <= stemHeight + 1; ++i) {
            for (int xPos = -distanceToStem; xPos <= distanceToStem; ++xPos) {
                for (int zPos = -distanceToStem; zPos <= distanceToStem; ++zPos) {
                    if ((i >= stemHeight + 1 || xPos == 0 && zPos == 0) && this.isCorner(xPos, zPos, distanceToStem)) continue;
                    mutable.m_122154_((Vec3i)pos, xPos, i - stemHeight, zPos);
                    this.m_5974_((LevelWriter)world, (BlockPos)mutable, config.capProvider.m_7112_(random, pos));
                }
            }
        }
        this.m_5974_((LevelWriter)world, pos.m_7494_(), config.capProvider.m_7112_(random, pos));
    }

    private Direction getDirectionFromOffset(int xOffset, int zOffset) {
        if (xOffset == 0 && zOffset == 0) {
            return Direction.NORTH;
        }
        if (xOffset == 0 && zOffset == 1) {
            return Direction.WEST;
        }
        if (xOffset == 1 && zOffset == 0) {
            return Direction.EAST;
        }
        return Direction.SOUTH;
    }

    private boolean isCorner(int xOffset, int zOffset, int distanceToStem) {
        return (xOffset == -distanceToStem || xOffset == distanceToStem) == (zOffset == -distanceToStem || zOffset == distanceToStem);
    }
}

