/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.core.init.ModRecipes;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ClibanoRecipe
extends AbstractCookingRecipe {
    public static final int DEFAULT_COOKING_TIME = 100;
    private final Map<ClibanoFireType, Integer> cookingTimes = new EnumMap<ClibanoFireType, Integer>(ClibanoFireType.class);

    public ClibanoRecipe(ResourceLocation id, String group, Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        super((RecipeType)ModRecipes.CLIBANO_COMBUSTION.get(), id, group, ingredient, result, experience, cookingTime);
        for (ClibanoFireType fireType : ClibanoFireType.values()) {
            this.cookingTimes.put(fireType, (int)((double)cookingTime / fireType.getCookingSpeedMultiplier()));
        }
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        return this.f_43729_.test(inv.m_8020_(0));
    }

    public int getCookingTime(ClibanoFireType fireType) {
        return this.cookingTimes.get((Object)fireType);
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CLIBANO_SERIALIZER.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ClibanoRecipe> {
        @Nonnull
        public ClibanoRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject jsonObject) {
            ItemStack itemstack;
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonelement);
            if (!jsonObject.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (jsonObject.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            } else {
                String s1 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            float f = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"experience", (float)0.0f);
            int i = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"cooking_time", (int)100);
            return new ClibanoRecipe(recipeId, s, ingredient, itemstack, f, i);
        }

        @Nullable
        public ClibanoRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            String s = buffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack itemstack = buffer.m_130267_();
            float f = buffer.readFloat();
            int i = buffer.m_130242_();
            return new ClibanoRecipe(recipeId, s, ingredient, itemstack, f, i);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ClibanoRecipe recipe) {
            buffer.m_130070_(recipe.f_43728_);
            recipe.f_43729_.m_43923_(buffer);
            buffer.m_130055_(recipe.f_43730_);
            buffer.writeFloat(recipe.f_43731_);
            buffer.m_130130_(recipe.f_43732_);
        }
    }
}

