/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.client.renderer.item.ObsidianSkullShieldItemRenderer;
import com.stal111.forbidden_arcanus.common.item.ObsidianSkullItem;
import com.stal111.forbidden_arcanus.common.item.counter.ObsidianSkullCounter;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.NonNullLazy;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCapability;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCreator;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterImpl;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.common.capability.counter.SimpleCounter;

public class ObsidianSkullShieldItem
extends Item {
    private static final ResourceLocation COUNTER = new ResourceLocation("forbidden_arcanus", "tick_counter");
    private static final int USE_DURATION = 72000;

    public ObsidianSkullShieldItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            stack.getCapability(CounterProvider.CAPABILITY).ifPresent(counterCapability -> {
                CompoundTag tag = new CompoundTag();
                if (livingEntity.m_21225_() != null) {
                    tag.m_128359_("DamageSource", livingEntity.m_21225_().m_19385_());
                }
                this.getCounter((CounterCapability)counterCapability).tick(tag);
            });
        }
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
    }

    public static boolean shouldProtectFromDamage(DamageSource damageSource, Inventory inventory) {
        if (!ObsidianSkullItem.DAMAGE_SOURCES.contains(damageSource)) {
            return false;
        }
        if (inventory.m_36063_(ModItems.Stacks.ETERNAL_OBSIDIAN_SKULL)) {
            return true;
        }
        ItemStack stack = ObsidianSkullShieldItem.getSkullWithLowestCounter(inventory);
        if (stack.m_41619_()) {
            return false;
        }
        return ObsidianSkullShieldItem.getCounterValue(stack) < 600;
    }

    public static ItemStack getSkullWithLowestCounter(Inventory inventory) {
        ItemStack skull = ItemStack.f_41583_;
        for (NonNullList nonNullList : inventory.f_35979_) {
            for (ItemStack stack : nonNullList) {
                if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.OBSIDIAN_SKULL_SHIELD.get()) || !skull.m_41619_() && ObsidianSkullShieldItem.getCounterValue(skull) <= ObsidianSkullShieldItem.getCounterValue(stack)) continue;
                skull = stack;
            }
        }
        return skull;
    }

    public static int getCounterValue(ItemStack stack) {
        return ((CounterCapability)stack.getCapability(CounterProvider.CAPABILITY).orElse((Object)new CounterImpl())).getCounter(COUNTER).getValue();
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, ItemStack repair) {
        return repair.m_150930_((Item)ModItems.OBSIDIAN_INGOT.get()) || super.m_6832_(toRepair, repair);
    }

    public void m_7373_(@Nonnull ItemStack stack, Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("tooltip.forbidden_arcanus.obsidian_skull_shield").m_130940_(ChatFormatting.GRAY));
    }

    public void initializeClient(@Nonnull Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> new ObsidianSkullShieldItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag tag) {
        return new CounterProvider(CounterCreator.of(ObsidianSkullCounter::new, (ResourceLocation)COUNTER));
    }

    private SimpleCounter getCounter(CounterCapability counterCapability) {
        return counterCapability.getCounter(COUNTER);
    }
}

