/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.item.EdelwoodBucketItem;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class EdelwoodMobBucketItem
extends EdelwoodBucketItem {
    private final Supplier<? extends EntityType<?>> entityType;
    private final Supplier<? extends SoundEvent> emptySound;

    public EdelwoodMobBucketItem(Supplier<EntityType<?>> entityType, Supplier<Fluid> fluid, Item.Properties properties) {
        this(entityType, fluid, null, properties);
    }

    public EdelwoodMobBucketItem(Supplier<EntityType<?>> entityType, Supplier<Fluid> fluid, Supplier<SoundEvent> emptySound, Item.Properties properties) {
        super(fluid, properties);
        this.entityType = entityType;
        this.emptySound = emptySound;
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        BlockHitResult hitResult;
        ItemStack stack = player.m_21120_(hand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)player, (Level)level, (ItemStack)stack, (HitResult)(hitResult = EdelwoodMobBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.getFluid() == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        BlockPos pos = hitResult.m_82425_();
        Direction direction = hitResult.m_82434_();
        BlockPos relativePos = pos.m_142300_(direction);
        if (!level.m_7966_(player, pos) || !player.m_36204_(relativePos, direction, stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (this.getFluid() == Fluids.f_76191_) {
            this.m_142131_(player, level, stack, pos);
            return InteractionResultHolder.m_19092_((Object)this.getEmptyBucket(), (boolean)level.m_5776_());
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_142131_(@Nullable Player player, @Nonnull Level level, @Nonnull ItemStack stack, @Nonnull BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawn(serverLevel, stack, pos);
            level.m_142346_((Entity)player, GameEvent.f_157810_, pos);
        }
    }

    protected void m_7718_(@Nullable Player player, @Nonnull LevelAccessor level, @Nonnull BlockPos pos) {
        if (this.emptySound != null) {
            level.m_5594_(player, pos, this.emptySound.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    protected void spawn(ServerLevel level, ItemStack stack, BlockPos pos) {
        Entity entity = this.entityType.get().m_20592_(level, stack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.m_142278_(stack.m_41784_());
            bucketable.m_142139_(true);
        }
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> components, @Nonnull TooltipFlag isAdvanced) {
        CompoundTag tag;
        if (this.entityType.get() == EntityType.f_20489_ && (tag = stack.m_41783_()) != null && tag.m_128425_("BucketVariantTag", 3)) {
            int i = tag.m_128451_("BucketVariantTag");
            ChatFormatting[] chatFormatting = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            String s = "color.minecraft." + TropicalFish.m_30050_((int)i);
            String s1 = "color.minecraft." + TropicalFish.m_30052_((int)i);
            for (int j = 0; j < TropicalFish.f_30007_.length; ++j) {
                if (i != TropicalFish.f_30007_[j]) continue;
                components.add((Component)new TranslatableComponent(TropicalFish.m_30030_((int)j)).m_130944_(chatFormatting));
                return;
            }
            components.add((Component)new TranslatableComponent(TropicalFish.m_30054_((int)i)).m_130944_(chatFormatting));
            TranslatableComponent component = new TranslatableComponent(s);
            if (!s.equals(s1)) {
                component.m_130946_(", ").m_7220_((Component)new TranslatableComponent(s1));
            }
            component.m_130944_(chatFormatting);
            components.add((Component)component);
        }
    }

    public ItemStack getFluidBucket() {
        if (this.getFluid() == Fluids.f_76193_) {
            return new ItemStack((ItemLike)ModItems.EDELWOOD_WATER_BUCKET.get());
        }
        return new ItemStack((ItemLike)ModItems.EDELWOOD_LAVA_BUCKET.get());
    }

    @Override
    protected boolean canBurn(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.EDELWOOD_MAGMA_CUBE_BUCKET.get());
    }
}

