/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.inventory.clibano;

import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.common.inventory.EnhancerSlot;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoFuelSlot;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoResultSlot;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoSoulSlot;
import com.stal111.forbidden_arcanus.core.init.other.ModContainers;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class ClibanoMenu
extends AbstractContainerMenu {
    public static final int SLOT_COUNT = 7;
    public static final int DATA_COUNT = 8;
    public static final int ENHANCER_SLOT = 0;
    public static final int SOUL_SLOT = 1;
    public static final int FUEL_SLOT = 2;
    public static final Pair<Integer, Integer> INPUT_SLOTS = Pair.of((Object)3, (Object)4);
    public static final Pair<Integer, Integer> RESULT_SLOTS = Pair.of((Object)5, (Object)6);
    private final Container container;
    private final ContainerData containerData;
    private final Level level;

    public ClibanoMenu(int id, Inventory inventory) {
        this(id, (Container)new SimpleContainer(7), inventory, (ContainerData)new SimpleContainerData(8));
    }

    public ClibanoMenu(int containerId, Container container, Inventory inventory, ContainerData containerData) {
        super((MenuType)ModContainers.CLIBANO.get(), containerId);
        this.container = container;
        this.containerData = containerData;
        this.level = inventory.f_35978_.m_183503_();
        this.m_38884_(this.containerData);
        ClibanoMenu.m_38869_((Container)container, (int)7);
        ClibanoMenu.m_38886_((ContainerData)containerData, (int)8);
        this.m_38897_(new EnhancerSlot(container, 0, 18, 20));
        this.m_38897_(new ClibanoSoulSlot(container, 1, 18, 56));
        this.m_38897_(new ClibanoFuelSlot(this, container, 2, 53, 56));
        this.m_38897_(new Slot(container, ((Integer)INPUT_SLOTS.getFirst()).intValue(), 44, 20));
        this.m_38897_(new Slot(container, ((Integer)INPUT_SLOTS.getSecond()).intValue(), 62, 20));
        this.m_38897_(new ClibanoResultSlot(inventory.f_35978_, container, (Integer)RESULT_SLOTS.getFirst(), 116, 32));
        this.m_38897_(new ClibanoResultSlot(inventory.f_35978_, container, (Integer)RESULT_SLOTS.getSecond(), 142, 28));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 91 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 149));
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return result;
        }
        ItemStack stack = slot.m_7993_();
        result = stack.m_41777_();
        if (index == (Integer)RESULT_SLOTS.getFirst() || index == (Integer)RESULT_SLOTS.getSecond()) {
            if (!this.m_38903_(stack, 7, 43, true)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stack, result);
        } else if (index < 7 ? !this.m_38903_(stack, 7, 43, false) : (this.canSmelt(stack) ? !this.m_38903_(stack, (Integer)INPUT_SLOTS.getFirst(), (Integer)INPUT_SLOTS.getSecond() + 1, false) : (this.isFuel(stack) ? !this.m_38903_(stack, 2, 3, false) : (this.isSoul(stack) ? !this.m_38903_(stack, 1, 2, false) : (index < 34 ? !this.m_38903_(stack, 34, 43, false) : index < 43 && !this.m_38903_(stack, 7, 34, false)))))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == result.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return result;
    }

    protected boolean canSmelt(ItemStack stack) {
        return this.level.m_7465_().m_44015_(ClibanoMainBlockEntity.RECIPE_TYPE, (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    protected boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44109_) > 0;
    }

    protected boolean isSoul(ItemStack stack) {
        return ClibanoMainBlockEntity.ITEM_TO_FIRE_TYPE.apply(stack).isPresent();
    }

    public boolean isSoulActive() {
        return this.getSoulDuration() > 0;
    }

    public int getSoulDuration() {
        return this.containerData.m_6413_(0);
    }

    public int getBurnTime() {
        return this.containerData.m_6413_(1);
    }

    public int getBurnDuration() {
        return this.containerData.m_6413_(2);
    }

    public Pair<Integer, Integer> getCookingProgress() {
        return Pair.of((Object)this.containerData.m_6413_(3), (Object)this.containerData.m_6413_(4));
    }

    public Pair<Integer, Integer> getCookingDuration() {
        return Pair.of((Object)this.containerData.m_6413_(5), (Object)this.containerData.m_6413_(6));
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.container.m_6542_(player);
    }

    public int getFireType() {
        return this.containerData.m_6413_(7);
    }
}

