/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.aureal.AurealHelper;
import com.stal111.forbidden_arcanus.common.aureal.capability.AurealProvider;
import com.stal111.forbidden_arcanus.common.aureal.capability.IAureal;
import com.stal111.forbidden_arcanus.common.aureal.consequence.Consequence;
import com.stal111.forbidden_arcanus.common.item.CapacityBucket;
import com.stal111.forbidden_arcanus.common.item.EdelwoodBucketItem;
import com.stal111.forbidden_arcanus.common.item.EdelwoodMobBucketItem;
import com.stal111.forbidden_arcanus.common.item.EdelwoodSuspiciousStewBucketItem;
import com.stal111.forbidden_arcanus.common.item.QuantumCatcherItem;
import com.stal111.forbidden_arcanus.core.config.BlockConfig;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.common.util.ItemStackUtils;

@Mod.EventBusSubscriber
public class PlayerEvents {
    private static final Map<Fluid, List<EntityType<?>>> FLUID_TO_ENTITY = ImmutableMap.of((Object)Fluids.f_76191_, (Object)ImmutableList.of((Object)EntityType.f_20549_, (Object)EntityType.f_20526_, (Object)EntityType.f_20468_, (Object)EntityType.f_20555_), (Object)Fluids.f_76193_, (Object)ImmutableList.of((Object)EntityType.f_20516_, (Object)EntityType.f_20519_, (Object)EntityType.f_20556_, (Object)EntityType.f_20489_, (Object)EntityType.f_20480_, (Object)EntityType.f_147034_, (Object)EntityType.f_147039_));

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.START && (player = event.player).m_6147_() && !player.m_6047_() && player.m_146900_().m_60713_((Block)ModBlocks.EDELWOOD_LADDER.get())) {
            if (player.f_20902_ > 0.0f) {
                player.m_6478_(MoverType.SELF, new Vec3(0.0, ((Double)BlockConfig.EDELWOOD_LADDER_SPEED.get()).doubleValue(), 0.0));
            } else {
                player.m_6478_(MoverType.SELF, new Vec3(0.0, -((Double)BlockConfig.EDELWOOD_LADDER_SPEED.get()).doubleValue(), 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        CapacityBucket capacityBucket;
        Item item;
        Cow cow;
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        InteractionHand hand = event.getHand();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (livingEntity instanceof Cow && !(cow = (Cow)livingEntity).m_6162_() && (item = stack.m_41720_()) instanceof CapacityBucket && PlayerEvents.milkCow(cow, stack, capacityBucket = (CapacityBucket)item, player, hand)) {
            return;
        }
        if (PlayerEvents.tryPickupMob(player, hand, livingEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player player = event.getPlayer();
            Player original = event.getOriginal();
            original.reviveCaps();
            IAureal capability = AurealHelper.getCapability(original);
            player.getCapability(AurealProvider.CAPABILITY).ifPresent(aureal -> {
                aureal.setAureal(capability.getAureal());
                aureal.setCorruption(capability.getCorruption());
                aureal.setCorruptionTimer(capability.getCorruptionTimer());
                for (Consequence consequence : capability.getActiveConsequences()) {
                    aureal.addActiveConsequence(consequence);
                }
            });
        }
    }

    private static boolean milkCow(Cow cow, ItemStack stack, CapacityBucket capacityBucket, Player player, InteractionHand hand) {
        ItemStack copy = stack.m_41777_();
        ItemStack result = null;
        SoundEvent soundEvent = SoundEvents.f_11833_;
        if (cow instanceof MushroomCow) {
            Pair<Boolean, ItemStack> pair;
            MushroomCow mushroomCow = (MushroomCow)cow;
            if (stack.m_150930_((Item)ModItems.EDELWOOD_BUCKET.get())) {
                boolean flag = mushroomCow.f_28909_ != null;
                result = ItemUtils.m_41813_((ItemStack)copy, (Player)player, (ItemStack)ItemStackUtils.transferEnchantments((ItemStack)copy, (ItemStack)new ItemStack(flag ? (ItemLike)ModItems.EDELWOOD_SUSPICIOUS_STEW_BUCKET.get() : (ItemLike)ModItems.EDELWOOD_MUSHROOM_STEW_BUCKET.get())));
                if (flag) {
                    soundEvent = SoundEvents.f_12074_;
                    EdelwoodSuspiciousStewBucketItem.m_43258_((ItemStack)result, (MobEffect)mushroomCow.f_28909_, (int)mushroomCow.f_28910_);
                    mushroomCow.f_28909_ = null;
                    mushroomCow.f_28910_ = 0;
                } else {
                    soundEvent = SoundEvents.f_12073_;
                }
            } else if (stack.m_150930_((Item)ModItems.EDELWOOD_MUSHROOM_STEW_BUCKET.get()) && ((Boolean)(pair = capacityBucket.tryFill(stack)).getFirst()).booleanValue()) {
                result = (ItemStack)pair.getSecond();
            }
        } else if (stack.m_150930_((Item)ModItems.EDELWOOD_MILK_BUCKET.get()) && !capacityBucket.isFull(stack)) {
            result = (ItemStack)capacityBucket.tryFill(ItemUtils.m_41813_((ItemStack)copy, (Player)player, (ItemStack)stack)).getSecond();
        } else if (stack.m_150930_(capacityBucket.getEmptyBucket().m_41720_())) {
            result = ItemUtils.m_41813_((ItemStack)copy, (Player)player, (ItemStack)ItemStackUtils.transferEnchantments((ItemStack)copy, (ItemStack)new ItemStack((ItemLike)ModItems.EDELWOOD_MILK_BUCKET.get())));
        }
        if (result != null) {
            player.m_5496_(soundEvent, 1.0f, 1.0f);
            player.m_21008_(hand, result);
            player.m_6674_(hand);
            return true;
        }
        return false;
    }

    private static boolean tryPickupMob(Player player, InteractionHand hand, LivingEntity entity) {
        Slime slime;
        EdelwoodBucketItem edelwoodBucketItem;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.QUANTUM_CATCHER.get())) {
            return ((QuantumCatcherItem)stack.m_41720_()).onEntityInteract(stack, player, entity, hand).m_19077_();
        }
        Item item = stack.m_41720_();
        if (!(item instanceof EdelwoodBucketItem) || (edelwoodBucketItem = (EdelwoodBucketItem)item) instanceof EdelwoodMobBucketItem || !((List)FLUID_TO_ENTITY.getOrDefault(edelwoodBucketItem.getFluid(), new ArrayList())).contains(entity.m_6095_()) || !entity.m_6084_()) {
            return false;
        }
        if (entity instanceof Slime && (slime = (Slime)entity).m_33632_() > 1) {
            return false;
        }
        ResourceLocation resourceLocation = new ResourceLocation("forbidden_arcanus", "edelwood_" + Objects.requireNonNull(entity.m_6095_().getRegistryName()).m_135815_() + "_bucket");
        if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            ItemStack entityBucket = ItemStackUtils.transferEnchantments((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resourceLocation)));
            Item item2 = stack.m_41720_();
            if (item2 instanceof CapacityBucket) {
                CapacityBucket capacityBucket = (CapacityBucket)item2;
                entityBucket = capacityBucket.transferFullness(stack, entityBucket);
            }
            if (entity instanceof Bucketable) {
                Bucketable bucketable = (Bucketable)entity;
                bucketable.m_142146_(entityBucket);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10576_.m_38772_(serverPlayer, entityBucket);
            }
            player.m_6674_(hand);
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)stack, (Player)player, (ItemStack)entityBucket, (boolean)false));
            entity.m_146870_();
            return true;
        }
        return false;
    }
}

